import os
import socket

from . import fs

def write_config(config, name, service_type):
  sensu_config_path = config["sensu_config_dir"] if 'sensu_config_dir' in config else '/etc/sensu'

  if not os.path.exists(sensu_config_path):
    fs.mkdirs(sensu_config_path)

  if not os.path.exists(os.path.join(sensu_config_path, "conf.d")):
    fs.mkdirs(os.path.join(sensu_config_path, "conf.d"))

  redis_host = config["sensu_redis_host"] if 'sensu_redis_host' in config else 'sensu-redis.imply.io'
  redis_port = config["sensu_redis_port"] if 'sensu_redis_port' in config else '6379'
  client_name = socket.gethostname()
  address = socket.gethostbyname(client_name)
  major_type = service_type.split('/')[0]
  service = "{0}/{1}".format(name, major_type)
  subscriptions = "[\"{0}\", \"{1}\", \"{2}\", \"{3}\", \"roundrobin:{1}\", \"roundrobin:{2}\", \"roundrobin:{3}\"]".format(
    "default", name, service, major_type)

  config_json = '''{{
  "redis": {{
    "host": "{0}",
    "port": {1},
    "auto_reconnect": true
  }},
  "transport": {{
    "name": "redis",
    "reconnect_on_error": true
  }},
  "client": {{
    "name": "{2}",
    "address": "{3}",
    "service": "{4}",
    "subscriptions": {5}
  }}
}}'''.format(redis_host, redis_port, client_name, address, service, subscriptions)

  fs.write_file(os.path.join(sensu_config_path, "config.json"), config_json, 0o644)
