import re

from aiohttp import BasicAuth, hdrs, web
from aiohttp.web import middleware

@middleware
class BasicAuthMiddleware(object):
  def __init__(self, regex: str, auth_dict: dict):
    self.regex = re.compile(regex)
    self.auth_dict = auth_dict

  def parse_header(self, request):
    auth_header = request.headers.get(hdrs.AUTHORIZATION)
    if not auth_header:
      return None
    try:
      auth = BasicAuth.decode(auth_header=auth_header)
    except ValueError:
      return None
    return auth

  async def authenticate(self, request):
    auth = self.parse_header(request)
    return auth is not None and self.auth_dict.get(auth.login) == auth.password
  
  async def __call__(self, request, handler):
    if self.regex.fullmatch(request.path) is None:
      return await handler(request)
    else:
      if await self.authenticate(request):
        return await handler(request)
      else:
        raise web.HTTPUnauthorized(headers={'WWW-Authenticate': 'Basic realm="grove"'})
