/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.server.jetty.mapper;

import com.google.common.collect.ImmutableMap;
import io.imply.cloud.config.ApplicationConfig;
import io.imply.cloud.model.error.Error;
import io.imply.cloud.model.error.ErrorCode;
import io.imply.cloud.model.error.ErrorResponse;
import io.imply.cloud.server.jetty.mapper.BaseExceptionMapper;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;

@Provider
public class ThrowableMapper
extends BaseExceptionMapper<Throwable> {
    private final ApplicationConfig applicationConfig;

    @Inject
    public ThrowableMapper(ApplicationConfig applicationConfig) {
        this.applicationConfig = applicationConfig;
    }

    @Override
    public Response innerToResponse(Throwable exception, String requestId) {
        log.error(exception, "Unhandled exception");
        String errorMessage = this.applicationConfig.isOnPrem() ? String.format("%s [%s]%s", "Unexpected error", exception != null ? exception.getMessage() : "", requestId != null ? String.format(" (ref: %s)", requestId) : "") : String.format("%s%s", "Unable to complete operation, please contact support", requestId != null ? String.format(" (ref: %s)", requestId) : "");
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("application/json").entity((Object)(this.useLegacyError() ? this.getLegacyError(errorMessage) : this.getError(errorMessage))).build();
    }

    private Map<String, String> getLegacyError(String errorMessage) {
        return ImmutableMap.of((Object)"error", (Object)errorMessage);
    }

    private ErrorResponse getError(String errorMessage) {
        return ErrorResponse.of((Error)Error.builder().code(ErrorCode.SERVER_ERROR).message(errorMessage).build());
    }
}

