/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.server.jetty.mapper;

import io.imply.cloud.model.error.Error;
import io.imply.cloud.model.error.ErrorCode;
import io.imply.cloud.model.error.ErrorResponse;
import io.imply.cloud.server.jetty.mapper.BaseExceptionMapper;
import java.lang.annotation.Annotation;
import javax.validation.ConstraintViolation;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.hibernate.validator.engine.HibernateConstraintViolation;
import org.jboss.resteasy.api.validation.ResteasyViolationException;

@Provider
public class ResteasyViolationExceptionMapper
extends BaseExceptionMapper<ResteasyViolationException> {
    @Override
    protected Response innerToResponse(ResteasyViolationException exception, String requestId) {
        Error.Builder error = Error.builder().code(ErrorCode.BAD_ARGUMENT).message("Request contains invalid arguments");
        exception.getConstraintViolations().forEach(violation -> {
            HibernateConstraintViolation constraintViolation = (HibernateConstraintViolation)violation.unwrap(HibernateConstraintViolation.class);
            Error payload = (Error)constraintViolation.getDynamicPayload(Error.class);
            if (payload != null) {
                error.detail(payload);
            } else {
                error.detail(this.getError((ConstraintViolation<?>)violation));
            }
        });
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorResponse.of((Error)error.build())).build();
    }

    private Error getError(ConstraintViolation<?> violation) {
        return Error.builder().code(this.getErrorCode(violation.getConstraintDescriptor().getAnnotation())).message(violation.getMessage()).build();
    }

    private ErrorCode getErrorCode(Annotation annotation) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        if (Max.class.equals(annotationType)) {
            return ErrorCode.MAX_VALUE_EXCEEDED;
        }
        if (Min.class.equals(annotationType)) {
            return ErrorCode.MIN_VALUE_EXCEEDED;
        }
        if (NotNull.class.equals(annotationType)) {
            return ErrorCode.NULL_VALUE;
        }
        return ErrorCode.BAD_ARGUMENT;
    }
}

