/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.server.jetty.mapper;

import com.google.common.collect.ImmutableMap;
import io.imply.cloud.model.error.Error;
import io.imply.cloud.model.error.ErrorCode;
import io.imply.cloud.model.error.ErrorResponse;
import io.imply.cloud.server.jetty.mapper.BaseExceptionMapper;
import java.util.Map;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;

@Provider
public class NotFoundExceptionMapper
extends BaseExceptionMapper<NotFoundException> {
    @Override
    public Response innerToResponse(NotFoundException exception, String requestId) {
        log.info("NotFoundException for URI: [%s]", new Object[]{this.uriInfo.getRequestUri()});
        return Response.status((Response.Status)Response.Status.NOT_FOUND).type("application/json").entity((Object)(this.useLegacyError() ? this.getLegacyError(exception) : this.getError())).build();
    }

    private Map<String, String> getLegacyError(NotFoundException exception) {
        return exception.getMessage() == null ? null : ImmutableMap.of((Object)"error", (Object)String.format("The URI [%s] was not found", this.uriInfo.getRequestUri()));
    }

    private ErrorResponse getError() {
        return ErrorResponse.of((Error)Error.builder().code(ErrorCode.INVALID_URI).message(String.format("URI [%s] was not found", this.uriInfo.getRequestUri())).build());
    }
}

