/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.server.jetty.mapper;

import com.google.common.collect.ImmutableMap;
import io.imply.cloud.model.error.Error;
import io.imply.cloud.model.error.ErrorCode;
import io.imply.cloud.model.error.ErrorResponse;
import io.imply.cloud.server.jetty.mapper.BaseExceptionMapper;
import java.util.Map;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import lombok.Generated;
import org.skife.jdbi.v2.exceptions.NoResultsException;

@Provider
public class NoResultsExceptionMapper
extends BaseExceptionMapper<NoResultsException> {
    private static final String MESSAGE = "entity [%s] was not found";

    public NoResultsExceptionMapper(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    @Override
    public Response innerToResponse(NoResultsException exception, String requestId) {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).type("application/json").entity((Object)(this.useLegacyError() ? this.getLegacyError(exception) : this.getError(exception))).build();
    }

    private Map<String, String> getLegacyError(NoResultsException exception) {
        return ImmutableMap.of((Object)"error", (Object)String.format(MESSAGE, exception.getMessage()));
    }

    private ErrorResponse getError(NoResultsException exception) {
        return ErrorResponse.of((Error)Error.builder().code(ErrorCode.NOT_FOUND).message(String.format(MESSAGE, exception.getMessage())).build());
    }

    @Generated
    public NoResultsExceptionMapper() {
    }
}

