/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.server.jetty.mapper;

import com.google.common.collect.ImmutableMap;
import io.imply.cloud.model.error.Error;
import io.imply.cloud.model.error.ErrorCode;
import io.imply.cloud.model.error.ErrorResponse;
import io.imply.cloud.server.jetty.mapper.BaseExceptionMapper;
import java.util.Map;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import lombok.Generated;

@Provider
public class IllegalStateExceptionMapper
extends BaseExceptionMapper<IllegalStateException> {
    public IllegalStateExceptionMapper(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    @Override
    public Response innerToResponse(IllegalStateException exception, String requestId) {
        log.error((Throwable)exception, "IllegalStateException");
        return Response.status((Response.Status)(this.useLegacyError() ? Response.Status.INTERNAL_SERVER_ERROR : Response.Status.CONFLICT)).type("application/json").entity((Object)(this.useLegacyError() ? this.getLegacyError(exception) : this.getError(exception))).build();
    }

    private Map<String, String> getLegacyError(IllegalStateException exception) {
        return exception.getMessage() == null ? null : ImmutableMap.of((Object)"error", (Object)exception.getMessage());
    }

    private ErrorResponse getError(Exception exception) {
        if (exception.getMessage() == null) {
            return null;
        }
        return ErrorResponse.of((Error)Error.builder().code(ErrorCode.STATE_CONFLICT).message(exception.getMessage()).build());
    }

    @Generated
    public IllegalStateExceptionMapper() {
    }
}

