/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.server.jetty.mapper;

import com.google.common.collect.ImmutableMap;
import io.imply.cloud.exception.AlreadyExistsException;
import io.imply.cloud.server.jetty.mapper.AlreadyExistsExceptionMapper;
import io.imply.cloud.server.jetty.mapper.BaseExceptionMapper;
import io.imply.cloud.server.jetty.mapper.IllegalArgumentExceptionMapper;
import io.imply.cloud.server.jetty.mapper.IllegalStateExceptionMapper;
import io.imply.cloud.server.jetty.mapper.NREMapper;
import io.imply.cloud.server.jetty.mapper.NoResultsExceptionMapper;
import io.imply.cloud.util.NRE;
import java.sql.SQLIntegrityConstraintViolationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.skife.jdbi.v2.exceptions.DBIException;
import org.skife.jdbi.v2.exceptions.NoResultsException;
import org.skife.jdbi.v2.exceptions.UnableToExecuteStatementException;

@Provider
public class DBIExceptionMapper
extends BaseExceptionMapper<DBIException> {
    @Override
    public Response innerToResponse(DBIException exception, String requestId) {
        Throwable innerCause;
        Throwable cause = exception.getCause();
        if (cause instanceof NRE) {
            return new NREMapper(this.uriInfo).innerToResponse((NRE)exception.getCause(), requestId);
        }
        if (cause instanceof NoResultsException) {
            return new NoResultsExceptionMapper(this.uriInfo).innerToResponse((NoResultsException)exception.getCause(), requestId);
        }
        if (cause instanceof AlreadyExistsException) {
            return new AlreadyExistsExceptionMapper(this.uriInfo).innerToResponse((AlreadyExistsException)exception.getCause(), requestId);
        }
        if (cause instanceof IllegalArgumentException) {
            return new IllegalArgumentExceptionMapper(this.uriInfo).innerToResponse((IllegalArgumentException)exception.getCause(), requestId);
        }
        if (cause instanceof IllegalStateException) {
            return new IllegalStateExceptionMapper(this.uriInfo).innerToResponse((IllegalStateException)exception.getCause(), requestId);
        }
        if (cause instanceof UnableToExecuteStatementException && (innerCause = cause.getCause()) instanceof SQLIntegrityConstraintViolationException) {
            log.info(cause, "SQLIntegrityConstraintViolationException occurred");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ImmutableMap.of((Object)"error", (Object)"MySQLIntegrityConstraintViolationException: If you are doing an update the version number must be higher than the current version")).build();
        }
        log.warn((Throwable)exception, "DBIExceptionMapper");
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("application/json").entity((Object)ImmutableMap.of((Object)"error", (Object)(exception.getMessage() != null ? exception.getMessage() : exception.toString()))).build();
    }
}

