/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.server.jetty.mapper;

import com.google.common.collect.ImmutableMap;
import io.imply.cloud.model.error.Error;
import io.imply.cloud.model.error.ErrorCode;
import io.imply.cloud.model.error.ErrorResponse;
import io.imply.cloud.server.jetty.mapper.BaseExceptionMapper;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;

@Provider
public class ClientErrorExceptionMapper
extends BaseExceptionMapper<ClientErrorException> {
    @Override
    public Response innerToResponse(ClientErrorException exception, String requestId) {
        log.info("%s for URI: [%s]", new Object[]{exception.getClass().getName(), this.uriInfo.getRequestUri()});
        return Response.status((int)exception.getResponse().getStatus()).type("application/json").entity((Object)(this.useLegacyError() ? this.getLegacyError(exception) : this.getError(exception))).build();
    }

    private Map<String, String> getLegacyError(ClientErrorException exception) {
        return exception.getMessage() == null ? null : ImmutableMap.of((Object)"error", (Object)this.getMessageFromException(exception));
    }

    private ErrorResponse getError(ClientErrorException exception) {
        return ErrorResponse.of((Error)Error.builder().code(ErrorCode.getByStatusCode((int)exception.getResponse().getStatus())).message(this.getMessageFromException(exception)).build());
    }

    private String getMessageFromException(ClientErrorException exception) {
        return Optional.ofNullable(exception.getResponse().getStatusInfo()).map(Response.StatusType::getReasonPhrase).orElse("");
    }
}

