/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.server.jetty.filters;

import io.imply.cloud.model.User;
import io.imply.cloud.util.ThreadLocalContext;
import io.imply.cloud.util.ThreadUtils;
import java.io.IOException;
import java.security.Principal;
import java.util.UUID;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ObjectUtils;

public class ThreadLocalContextFilter
implements Filter {
    public void init(FilterConfig config) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.doFilter((HttpServletRequest)request, (HttpServletResponse)response, chain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        Thread thread = Thread.currentThread();
        String threadName = thread.getName();
        User user = this.getUser(request.getUserPrincipal());
        String requestId = (String)ObjectUtils.getIfNull((Object)request.getHeader("X-Request-ID"), () -> UUID.randomUUID().toString().substring(0, 8));
        String parentSpanId = request.getHeader("X-B3-ParentSpanId");
        String spanId = UUID.randomUUID().toString().substring(0, 8);
        if (user == null) {
            response.sendError(401);
            return;
        }
        ThreadLocalContext.setPrincipal((User)user);
        ThreadLocalContext.setRequestId((String)requestId);
        ThreadLocalContext.setSpanId((String)spanId);
        ThreadLocalContext.setParentSpanId((String)parentSpanId);
        ThreadLocalContext.setCacheId((String)UUID.randomUUID().toString().substring(0, 8));
        try {
            thread.setName(ThreadUtils.getExtendedThreadName((String)threadName, (String)user.getDetailedUserId(), (String)requestId));
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            ThreadLocalContext.clear();
            thread.setName(threadName);
        }
    }

    private User getUser(Principal principal) {
        return principal instanceof User ? (User)principal : null;
    }
}

