/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.server.jetty;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.imply.cloud.util.ToStringBuilder;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.joda.time.Period;

public class ServerConfig {
    @JsonProperty
    private int requestHeaderSize = 16384;
    @JsonProperty
    private int responseHeaderSize = 16384;
    @JsonProperty
    @Min(value=1L)
    private @Min(value=1L) int numThreads = Math.max(10, Runtime.getRuntime().availableProcessors() * 17 / 16 + 2) + 30;
    @JsonProperty
    @NotNull
    private Period maxIdleTime = new Period((Object)"PT5m");
    @JsonProperty
    private String keyStorePath = null;
    @JsonProperty
    private String keyStorePassword = null;
    @JsonProperty
    private String username = null;
    @JsonProperty
    private String password = null;
    @JsonProperty
    private Boolean authenticate = true;

    public String toString() {
        return new ToStringBuilder((Object)this).append("numThreads", this.numThreads).append("maxIdleTime", (Object)this.maxIdleTime).append("keyStorePath", (Object)this.keyStorePath).append("keyStorePassword", (Object)"*****************").append("username", (Object)this.username).append("password", (Object)"*****************").append("authenticate", (Object)this.authenticate).toString();
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public int getRequestHeaderSize() {
        return this.requestHeaderSize;
    }

    @Generated
    public int getResponseHeaderSize() {
        return this.responseHeaderSize;
    }

    @Generated
    public int getNumThreads() {
        return this.numThreads;
    }

    @Generated
    public Period getMaxIdleTime() {
        return this.maxIdleTime;
    }

    @Generated
    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    @Generated
    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public Boolean getAuthenticate() {
        return this.authenticate;
    }

    @Generated
    private ServerConfig() {
    }

    @Generated
    public ServerConfig(int requestHeaderSize, int responseHeaderSize, int numThreads, Period maxIdleTime, String keyStorePath, String keyStorePassword, String username, String password, Boolean authenticate) {
        this.requestHeaderSize = requestHeaderSize;
        this.responseHeaderSize = responseHeaderSize;
        this.numThreads = numThreads;
        this.maxIdleTime = maxIdleTime;
        this.keyStorePath = keyStorePath;
        this.keyStorePassword = keyStorePassword;
        this.username = username;
        this.password = password;
        this.authenticate = authenticate;
    }

    @Generated
    public static class Builder {
        @Generated
        private int requestHeaderSize;
        @Generated
        private int responseHeaderSize;
        @Generated
        private int numThreads;
        @Generated
        private Period maxIdleTime;
        @Generated
        private String keyStorePath;
        @Generated
        private String keyStorePassword;
        @Generated
        private String username;
        @Generated
        private String password;
        @Generated
        private Boolean authenticate;

        @Generated
        Builder() {
        }

        @JsonProperty
        @Generated
        public Builder requestHeaderSize(int requestHeaderSize) {
            this.requestHeaderSize = requestHeaderSize;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder responseHeaderSize(int responseHeaderSize) {
            this.responseHeaderSize = responseHeaderSize;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder numThreads(int numThreads) {
            this.numThreads = numThreads;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder maxIdleTime(Period maxIdleTime) {
            this.maxIdleTime = maxIdleTime;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder keyStorePath(String keyStorePath) {
            this.keyStorePath = keyStorePath;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder keyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder username(String username) {
            this.username = username;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder password(String password) {
            this.password = password;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder authenticate(Boolean authenticate) {
            this.authenticate = authenticate;
            return this;
        }

        @Generated
        public ServerConfig build() {
            return new ServerConfig(this.requestHeaderSize, this.responseHeaderSize, this.numThreads, this.maxIdleTime, this.keyStorePath, this.keyStorePassword, this.username, this.password, this.authenticate);
        }

        @Generated
        public String toString() {
            return "ServerConfig.Builder(requestHeaderSize=" + this.requestHeaderSize + ", responseHeaderSize=" + this.responseHeaderSize + ", numThreads=" + this.numThreads + ", maxIdleTime=" + String.valueOf(this.maxIdleTime) + ", keyStorePath=" + this.keyStorePath + ", keyStorePassword=" + this.keyStorePassword + ", username=" + this.username + ", password=" + this.password + ", authenticate=" + this.authenticate + ")";
        }
    }
}

