/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.server.curator;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import io.imply.cloud.guice.JsonConfigProvider;
import io.imply.cloud.guice.annotations.LazySingleton;
import io.imply.cloud.lifecycle.Lifecycle;
import io.imply.cloud.server.curator.CuratorConfig;
import io.imply.cloud.server.curator.PotentiallyGzippedCompressionProvider;
import io.imply.cloud.util.Logger;
import java.io.IOException;
import java.util.List;
import org.apache.curator.RetryPolicy;
import org.apache.curator.ensemble.EnsembleProvider;
import org.apache.curator.ensemble.fixed.FixedEnsembleProvider;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.api.CompressionProvider;
import org.apache.curator.framework.imps.DefaultACLProvider;
import org.apache.curator.retry.BoundedExponentialBackoffRetry;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;

public class CuratorModule
implements Module {
    static final String CURATOR_CONFIG_PREFIX = "zk.service";
    private static final int BASE_SLEEP_TIME_MS = 1000;
    private static final int MAX_SLEEP_TIME_MS = 45000;
    private static final int MAX_RETRIES = 29;
    private static final Logger log = new Logger(CuratorModule.class);

    public void configure(Binder binder) {
        JsonConfigProvider.bind((Binder)binder, (String)CURATOR_CONFIG_PREFIX, CuratorConfig.class);
    }

    @Provides
    @LazySingleton
    public CuratorFramework makeCurator(CuratorConfig config, Lifecycle lifecycle) throws IOException {
        final CuratorFramework framework = CuratorFrameworkFactory.builder().ensembleProvider((EnsembleProvider)new FixedEnsembleProvider(config.getZkHosts())).sessionTimeoutMs(config.getZkSessionTimeoutMs().intValue()).retryPolicy((RetryPolicy)new BoundedExponentialBackoffRetry(1000, 45000, 29)).compressionProvider((CompressionProvider)new PotentiallyGzippedCompressionProvider(config.getEnableCompression())).aclProvider((ACLProvider)(config.getEnableAcl() ? new SecuredACLProvider() : new DefaultACLProvider())).build();
        lifecycle.addHandler(new Lifecycle.Handler(){

            public void start() throws Exception {
                log.info("Starting Curator");
                framework.start();
            }

            public void stop() {
                log.info("Stopping Curator");
                framework.close();
            }
        });
        return framework;
    }

    class SecuredACLProvider
    implements ACLProvider {
        SecuredACLProvider() {
        }

        public List<ACL> getDefaultAcl() {
            return ZooDefs.Ids.CREATOR_ALL_ACL;
        }

        public List<ACL> getAclForPath(String path) {
            return ZooDefs.Ids.CREATOR_ALL_ACL;
        }
    }
}

