/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import io.imply.cloud.cache.CacheModule;
import io.imply.cloud.config.ApplicationConfig;
import io.imply.cloud.config.ExtensionsConfig;
import io.imply.cloud.configurator.ClusterAuthConfiguratorModule;
import io.imply.cloud.configurator.ConfiguratorModule;
import io.imply.cloud.guice.ApplicationModule;
import io.imply.cloud.guice.CommonModule;
import io.imply.cloud.guice.JettyClientModule;
import io.imply.cloud.guice.JsonConfigProvider;
import io.imply.cloud.guice.LifecycleModule;
import io.imply.cloud.guice.MapboxModule;
import io.imply.cloud.guice.MetricsModule;
import io.imply.cloud.guice.OtelCollectorModule;
import io.imply.cloud.guice.PolyBind;
import io.imply.cloud.guice.SecondaryModule;
import io.imply.cloud.guice.StartupLoggingModule;
import io.imply.cloud.guice.TelemetryModule;
import io.imply.cloud.persistence.PersistenceModule;
import io.imply.cloud.persistence.SQLStorageConnector;
import io.imply.cloud.persistence.mysql.MySQLStorageModule;
import io.imply.cloud.persistence.postgresql.PostgreSQLStorageModule;
import io.imply.cloud.resteasy.RestEasyModule;
import io.imply.cloud.security.SecurityModule;
import io.imply.cloud.server.ExtensionFirstClassLoader;
import io.imply.cloud.server.curator.CuratorModule;
import io.imply.cloud.server.guice.ServerModule;
import io.imply.cloud.server.guice.ServerServletModule;
import io.imply.cloud.server.jetty.JettyServerModule;
import io.imply.cloud.server.kubernetes.KubernetesLeaderModule;
import io.imply.cloud.util.ISE;
import io.imply.cloud.util.Logger;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.io.FileUtils;

public class Initialization {
    private static final Logger log = new Logger(Initialization.class);
    private static final ConcurrentMap<File, URLClassLoader> LOADERS_MAP = new ConcurrentHashMap<File, URLClassLoader>();
    private static final Map<Class<?>, Collection<?>> EXTENSIONS_MAP = Maps.newHashMap();

    public static <T> Collection<T> getLoadedImplementations(Class<T> clazz) {
        Collection<?> retVal = EXTENSIONS_MAP.get(clazz);
        if (retVal == null) {
            return Sets.newHashSet();
        }
        return retVal;
    }

    @VisibleForTesting
    static void clearLoadedImplementations() {
        EXTENSIONS_MAP.clear();
    }

    @VisibleForTesting
    static Map<File, URLClassLoader> getLoadersMap() {
        return LOADERS_MAP;
    }

    public static synchronized <T> Collection<T> getFromExtensions(ExtensionsConfig config, Class<T> serviceClass) {
        List modulesToLoad = new ServiceLoadingFromExtensions<T>((ExtensionsConfig)config, serviceClass).implsToLoad;
        EXTENSIONS_MAP.put(serviceClass, modulesToLoad);
        return modulesToLoad;
    }

    public static File[] getExtensionFilesToLoad(ExtensionsConfig config) {
        File[] extensionsToLoad;
        File rootExtensionsDir = new File(config.getDirectory());
        if (rootExtensionsDir.exists() && !rootExtensionsDir.isDirectory()) {
            throw new ISE("Root extensions directory [%s] is not a directory!?", new Object[]{rootExtensionsDir});
        }
        LinkedHashSet toLoad = config.getLoadList();
        if (toLoad == null) {
            extensionsToLoad = rootExtensionsDir.listFiles();
        } else {
            int i = 0;
            extensionsToLoad = new File[toLoad.size()];
            for (String extensionName : toLoad) {
                File extensionDir = new File(extensionName);
                if (!extensionDir.isAbsolute()) {
                    extensionDir = new File(rootExtensionsDir, extensionName);
                }
                if (!extensionDir.isDirectory()) {
                    throw new ISE("Extension [%s] specified in \"extensions.loadList\" didn't exist!?", new Object[]{extensionDir.getAbsolutePath()});
                }
                extensionsToLoad[i++] = extensionDir;
            }
        }
        return extensionsToLoad == null ? new File[]{} : extensionsToLoad;
    }

    public static URLClassLoader getClassLoaderForExtension(File extension, boolean useExtensionClassloaderFirst) {
        return LOADERS_MAP.computeIfAbsent(extension, theExtension -> Initialization.makeClassLoaderForExtension(theExtension, useExtensionClassloaderFirst));
    }

    private static URLClassLoader makeClassLoaderForExtension(File extension, boolean useExtensionClassloaderFirst) {
        Collection jars = FileUtils.listFiles((File)extension, (String[])new String[]{"jar"}, (boolean)false);
        URL[] urls = new URL[jars.size()];
        try {
            int i = 0;
            for (File jar : jars) {
                URL url = jar.toURI().toURL();
                log.info("added URL[%s] for extension[%s]", new Object[]{url, extension.getName()});
                urls[i++] = url;
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        if (useExtensionClassloaderFirst) {
            return new ExtensionFirstClassLoader(urls, Initialization.class.getClassLoader());
        }
        return new URLClassLoader(urls, Initialization.class.getClassLoader());
    }

    public static List<URL> getURLsForClasspath(String cp) {
        try {
            String[] paths = cp.split(File.pathSeparator);
            ArrayList<URL> urls = new ArrayList<URL>();
            for (String path : paths) {
                File f = new File(path);
                if ("*".equals(f.getName())) {
                    File[] jars;
                    File parentDir = f.getParentFile();
                    if (!parentDir.isDirectory()) continue;
                    for (File jar : jars = parentDir.listFiles(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return name != null && (name.endsWith(".jar") || name.endsWith(".JAR"));
                        }
                    })) {
                        urls.add(jar.toURI().toURL());
                    }
                    continue;
                }
                urls.add(new File(path).toURI().toURL());
            }
            return urls;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Injector makeInjectorWithModules(Injector baseInjector, Iterable<? extends Module> modules) {
        ModuleList defaultModules = new ModuleList(baseInjector);
        defaultModules.addModules(new Object[]{new LifecycleModule(), new MapboxModule(), new OtelCollectorModule(), new TelemetryModule(), new ConfiguratorModule(), new ClusterAuthConfiguratorModule(), new MetricsModule(), new CuratorModule(), new ServerModule(), new JettyServerModule(), new JettyClientModule(), new PersistenceModule(), binder -> PolyBind.createChoice((Binder)binder, (String)"storage.type", (Key)Key.get(SQLStorageConnector.class), null), new MySQLStorageModule(), new PostgreSQLStorageModule(), new SecurityModule(), new StartupLoggingModule(), new CommonModule(), new CacheModule(), new ServerServletModule(), new RestEasyModule(), new KubernetesLeaderModule(), binder -> JsonConfigProvider.bind((Binder)binder, (String)"application", ApplicationConfig.class)});
        ModuleList actualModules = new ModuleList(baseInjector);
        actualModules.addModule(SecondaryModule.class);
        for (Module module : modules) {
            actualModules.addModule(module);
        }
        Module intermediateModules = Modules.override(defaultModules.getModules()).with(actualModules.getModules());
        ModuleList moduleList = new ModuleList(baseInjector);
        ExtensionsConfig config = (ExtensionsConfig)baseInjector.getInstance(ExtensionsConfig.class);
        for (ApplicationModule module : Initialization.getFromExtensions(config, ApplicationModule.class)) {
            moduleList.addModule(module);
        }
        return Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{intermediateModules}).with(moduleList.getModules())});
    }

    private static class ServiceLoadingFromExtensions<T> {
        private final ExtensionsConfig extensionsConfig;
        private final Class<T> serviceClass;
        private final List<T> implsToLoad = new ArrayList<T>();
        private final Set<String> implClassNamesToLoad = new HashSet<String>();

        private ServiceLoadingFromExtensions(ExtensionsConfig extensionsConfig, Class<T> serviceClass) {
            this.extensionsConfig = extensionsConfig;
            this.serviceClass = serviceClass;
            if (extensionsConfig.searchCurrentClassloader()) {
                this.addAllFromCurrentClassLoader();
            }
            this.addAllFromFileSystem();
        }

        private void addAllFromCurrentClassLoader() {
            ServiceLoader.load(this.serviceClass, Thread.currentThread().getContextClassLoader()).forEach(impl -> this.tryAdd(impl, "classpath"));
        }

        private void addAllFromFileSystem() {
            for (File extension : Initialization.getExtensionFilesToLoad(this.extensionsConfig)) {
                log.info("Loading extension [%s] for class [%s]", new Object[]{extension.getName(), this.serviceClass});
                try {
                    URLClassLoader loader = Initialization.getClassLoaderForExtension(extension, this.extensionsConfig.isUseExtensionClassloaderFirst());
                    ServiceLoader.load(this.serviceClass, loader).forEach(impl -> this.tryAdd(impl, "local file system"));
                }
                catch (Exception e) {
                    Throwables.throwIfUnchecked((Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        }

        private void tryAdd(T serviceImpl, String extensionType) {
            String serviceImplName = serviceImpl.getClass().getCanonicalName();
            if (serviceImplName == null) {
                log.warn("Implementation [%s] was ignored because it doesn't have a canonical name, is it a local or anonymous class?", new Object[]{serviceImpl.getClass().getName()});
            } else if (!this.implClassNamesToLoad.contains(serviceImplName)) {
                log.info("Adding implementation [%s] for class [%s] from %s extension", new Object[]{serviceImplName, this.serviceClass, extensionType});
                this.implClassNamesToLoad.add(serviceImplName);
                this.implsToLoad.add(serviceImpl);
            }
        }
    }

    private static class ModuleList {
        private final Injector baseInjector;
        private final ObjectMapper jsonMapper;
        private final List<Module> modules;

        public ModuleList(Injector baseInjector) {
            this.baseInjector = baseInjector;
            this.jsonMapper = (ObjectMapper)baseInjector.getInstance(ObjectMapper.class);
            this.modules = Lists.newArrayList();
        }

        private List<Module> getModules() {
            return Collections.unmodifiableList(this.modules);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void addModule(Object input) {
            if (input instanceof ApplicationModule) {
                this.baseInjector.injectMembers(input);
                this.modules.add((Module)this.registerJacksonModules((ApplicationModule)input));
                this.modules.addAll(((ApplicationModule)input).getModuleOverrides());
                return;
            } else if (input instanceof Module) {
                this.baseInjector.injectMembers(input);
                this.modules.add((Module)input);
                return;
            } else {
                if (!(input instanceof Class)) throw new ISE("Unknown module type[%s]", new Object[]{input.getClass()});
                if (ApplicationModule.class.isAssignableFrom((Class)input)) {
                    this.modules.add((Module)this.registerJacksonModules((ApplicationModule)this.baseInjector.getInstance((Class)input)));
                    this.modules.addAll(((ApplicationModule)this.baseInjector.getInstance((Class)input)).getModuleOverrides());
                    return;
                } else {
                    if (!Module.class.isAssignableFrom((Class)input)) throw new ISE("Class[%s] does not implement %s", new Object[]{input.getClass(), Module.class});
                    this.modules.add((Module)this.baseInjector.getInstance((Class)input));
                    return;
                }
            }
        }

        public void addModules(Object ... object) {
            for (Object o : object) {
                this.addModule(o);
            }
        }

        private ApplicationModule registerJacksonModules(ApplicationModule module) {
            for (com.fasterxml.jackson.databind.Module jacksonModule : module.getJacksonModules()) {
                this.jsonMapper.registerModule(jacksonModule);
            }
            return module;
        }
    }
}

