/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.server;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.net.HostAndPort;
import com.google.inject.name.Named;
import io.imply.cloud.util.IAE;
import io.imply.cloud.util.ISE;
import io.imply.cloud.util.Logger;
import io.imply.cloud.util.SocketUtil;
import io.imply.cloud.util.ToStringBuilder;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class ApplicationNode {
    private static final Logger log = new Logger(ApplicationNode.class);
    @JsonProperty(value="service")
    @NotNull
    private String serviceName;
    @JsonProperty
    @NotNull
    private String host;
    @JsonProperty
    @Min(value=0L)
    @Max(value=65535L)
    private @Min(value=0L) @Max(value=65535L) int port = -1;

    @JsonCreator
    public ApplicationNode(@JacksonInject @Named(value="serviceName") @JsonProperty(value="service") String serviceName, @JsonProperty(value="host") String host, @JacksonInject @Named(value="servicePort") @JsonProperty(value="port") Integer port) {
        this.init(serviceName, host, port);
    }

    private void init(String serviceName, String host, Integer port) {
        this.serviceName = (String)Preconditions.checkNotNull((Object)serviceName);
        if (host == null && port == null) {
            host = ApplicationNode.getDefaultHost();
            port = -1;
        } else {
            HostAndPort hostAndPort;
            if (host != null) {
                hostAndPort = HostAndPort.fromString((String)host);
                if (port != null && hostAndPort.hasPort() && port.intValue() != hostAndPort.getPort()) {
                    throw new IAE("Conflicting host:port [%s] and port [%d] settings", new Object[]{host, port});
                }
            } else {
                hostAndPort = HostAndPort.fromParts((String)ApplicationNode.getDefaultHost(), (int)port);
            }
            host = hostAndPort.getHost();
            if (hostAndPort.hasPort()) {
                port = hostAndPort.getPort();
            }
            if (port == null) {
                port = SocketUtil.findOpenPort((int)8080);
            }
        }
        this.port = port;
        this.host = host;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getHostAndPort() {
        if (this.port < 0) {
            return HostAndPort.fromString((String)this.host).toString();
        }
        return HostAndPort.fromParts((String)this.host, (int)this.port).toString();
    }

    public List<String> getAllAddresses() {
        Enumeration<NetworkInterface> interfaces;
        try {
            interfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (Exception e) {
            log.error((Throwable)e, "Unable to fetch network interfaces");
            return ImmutableList.of();
        }
        if (interfaces == null) {
            log.warn("No interfaces found while calling NetworkInterface.getNetworkInterfaces()");
            return ImmutableList.of();
        }
        return Collections.list(interfaces).stream().filter(x -> {
            try {
                return x.isUp() && !x.isLoopback();
            }
            catch (SocketException e) {
                return true;
            }
        }).flatMap(x -> Collections.list(x.getInetAddresses()).stream()).map(InetAddress::getHostAddress).collect(Collectors.toList());
    }

    public static String getDefaultHost() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            throw new ISE((Throwable)e, "Unable to determine host name", new Object[0]);
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("serviceName", (Object)this.serviceName).append("host", (Object)this.host).append("port", this.port).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationNode node = (ApplicationNode)o;
        if (this.port != node.port) {
            return false;
        }
        if (!this.serviceName.equals(node.serviceName)) {
            return false;
        }
        return this.host.equals(node.host);
    }

    public int hashCode() {
        int result = this.serviceName.hashCode();
        result = 31 * result + this.host.hashCode();
        result = 31 * result + this.port;
        return result;
    }
}

