/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.base.Throwables;
import io.imply.cloud.Constants;
import java.util.Map;
import javax.inject.Singleton;

@Singleton
public class YAML {
    private final ObjectMapper mapper;

    public YAML() {
        this.mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    }

    public YAML(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public ObjectMapper getObjectMapper() {
        return this.mapper;
    }

    public boolean isYaml(String str) {
        try {
            this.mapper.readValue(str, Constants.MAP_TYPE);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String toYaml(Object o) {
        return this.toYaml(o, false);
    }

    public String toYaml(Object o, boolean pretty) {
        try {
            if (pretty) {
                return this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString(o);
            }
            return this.mapper.writeValueAsString(o);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new YamlException(e);
        }
    }

    public byte[] toYamlBytes(Object o) {
        try {
            return this.mapper.writeValueAsBytes(o);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new YamlException(e);
        }
    }

    public Map<String, Object> fromYaml(String str) {
        return this.fromYaml(str, Constants.MAP_TYPE);
    }

    public <T> T fromYaml(String str, TypeReference<T> type) {
        try {
            return (T)this.mapper.readValue(str, type);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new YamlException(e);
        }
    }

    public <T> T fromYaml(String str, Class<T> type) {
        try {
            return (T)this.mapper.readValue(str, type);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new YamlException(e);
        }
    }

    public static class YamlException
    extends RuntimeException {
        public YamlException(Throwable e) {
            super(e);
        }
    }
}

