/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.util;

import com.google.inject.Singleton;
import java.util.StringJoiner;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

@Singleton
public class ThreadUtils {
    private final ScheduledThreadPoolExecutor timeoutExecutor = new ScheduledThreadPoolExecutor(1, new TimeoutThreadFactory());

    ThreadUtils() {
        this.timeoutExecutor.setRemoveOnCancelPolicy(true);
    }

    public static String getExtendedThreadName(String basename, String userId, String requestId) {
        StringJoiner threadName = new StringJoiner(" | ");
        threadName.add(basename);
        if (userId != null) {
            threadName.add(userId);
        }
        if (requestId != null) {
            threadName.add(requestId);
        }
        return threadName.toString();
    }

    public void setTimeout(Runnable runnable, long delay, TimeUnit unit) {
        this.timeoutExecutor.schedule(runnable, delay, unit);
    }

    private static final class TimeoutThreadFactory
    implements ThreadFactory {
        private TimeoutThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread t = new Thread(runnable);
            t.setDaemon(true);
            t.setName("SetTimeoutScheduler");
            return t;
        }
    }
}

