/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.util;

import io.imply.cloud.model.Stage;
import io.imply.cloud.model.User;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.MDC;

public class ThreadLocalContext {
    private static final ThreadLocal<User> threadLocalPrincipal = new ThreadLocal();
    private static final ThreadLocal<String> threadLocalRequestId = new ThreadLocal();
    private static final ThreadLocal<String> threadLocalParentSpanId = new ThreadLocal();
    private static final ThreadLocal<String> threadLocalSpanId = new ThreadLocal();
    private static final ThreadLocal<String> threadLocalCacheId = new ThreadLocal();
    private static final ThreadLocal<Map<String, String>> threadLocalUserContext = new ThreadLocal();
    private static final ThreadLocal<Class<?>> threadLocalNoticeOrActionClass = new ThreadLocal();
    private static final ThreadLocal<Class<? extends Stage>> threadLocalStageClass = new ThreadLocal();
    private static final ThreadLocal<Map<String, Object>> threadLocalSystemContext = ThreadLocal.withInitial(HashMap::new);

    public static void setPrincipal(User principal) {
        if (principal != null) {
            MDC.put((String)"principalId", (String)principal.getUserId());
            MDC.put((String)"organizationId", (String)principal.getAccountId());
        }
        threadLocalPrincipal.set(principal);
    }

    public static User getPrincipal() {
        return threadLocalPrincipal.get();
    }

    public static void setRequestId(String requestId) {
        if (requestId != null) {
            MDC.put((String)"requestId", (String)requestId);
        }
        threadLocalRequestId.set(requestId);
    }

    public static String getRequestId() {
        return threadLocalRequestId.get();
    }

    public static void setParentSpanId(String parentSpanId) {
        MDC.put((String)"parentSpanId", (String)parentSpanId);
        threadLocalParentSpanId.set(parentSpanId);
    }

    public static String getParentSpanId() {
        return threadLocalParentSpanId.get();
    }

    public static void setSpanId(String spanId) {
        MDC.put((String)"spanId", (String)spanId);
        threadLocalSpanId.set(spanId);
    }

    public static String getSpanId() {
        return threadLocalSpanId.get();
    }

    public static void setCacheId(String cacheId) {
        threadLocalCacheId.set(cacheId);
    }

    public static String getCacheId() {
        return threadLocalCacheId.get();
    }

    public static void setUserContext(Map<String, String> userContext) {
        threadLocalUserContext.set(userContext);
    }

    public static Map<String, String> getUserContext() {
        return threadLocalUserContext.get();
    }

    public static boolean userContextIsTrue(String key) {
        Map<String, String> userContext = ThreadLocalContext.getUserContext();
        if (userContext == null) {
            return false;
        }
        String value = userContext.get(key);
        return value != null && "true".equals(value.toLowerCase());
    }

    public static void setNoticeOrActionClass(Class<?> noticeClass) {
        threadLocalNoticeOrActionClass.set(noticeClass);
    }

    public static Class<?> getNoticeOrActionClass() {
        return threadLocalNoticeOrActionClass.get();
    }

    public static void setStageClass(Class<? extends Stage> stageClass) {
        threadLocalStageClass.set(stageClass);
    }

    public static Class<? extends Stage> getStageClass() {
        return threadLocalStageClass.get();
    }

    public static void setSystemContext(String key, Object value) {
        Map<String, Object> context = threadLocalSystemContext.get();
        if (context == null) {
            context = new HashMap<String, Object>();
        }
        context.put(key, value);
        threadLocalSystemContext.set(context);
    }

    public static Object getSystemContext(String key) {
        return threadLocalSystemContext.get() != null ? threadLocalSystemContext.get().get(key) : null;
    }

    public static void setSystemContext(Map<String, Object> systemContext) {
        threadLocalSystemContext.set(systemContext);
    }

    public static Map<String, Object> getSystemContext() {
        return threadLocalSystemContext.get();
    }

    public static boolean systemContextIsTrue(String key) {
        Object value = ThreadLocalContext.getSystemContext(key);
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return "true".equals(((String)value).toLowerCase());
        }
        return false;
    }

    public static void clear() {
        MDC.clear();
        threadLocalPrincipal.remove();
        threadLocalRequestId.remove();
        threadLocalParentSpanId.remove();
        threadLocalSpanId.remove();
        threadLocalCacheId.remove();
        threadLocalUserContext.remove();
        threadLocalNoticeOrActionClass.remove();
        threadLocalStageClass.remove();
        threadLocalSystemContext.remove();
    }
}

