/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.util;

import com.google.common.base.Throwables;
import io.imply.cloud.util.Logger;
import java.util.concurrent.Callable;
import java.util.function.Consumer;

public class Retryable {
    private static final Logger log = new Logger(Retryable.class);

    public static <T> T of(Callable<T> callable) {
        return Retryable.of(callable, null);
    }

    public static <T> T of(Callable<T> callable, int maxRetries, int retryDelayInSeconds) {
        return Retryable.of(callable, maxRetries, retryDelayInSeconds, null, false);
    }

    public static <T> T of(Callable<T> callable, int maxRetries, int retryDelayInSeconds, boolean tryQuietly) {
        return Retryable.of(callable, maxRetries, retryDelayInSeconds, null, tryQuietly);
    }

    public static <T> T of(Callable<T> callable, Consumer<Exception> onFailure) {
        return Retryable.of(callable, 5, 5, onFailure, false);
    }

    public static <T> T of(Callable<T> callable, int maxRetries, int retryDelayInSeconds, Consumer<Exception> onFailure, boolean tryQuietly) {
        int numRetries = 0;
        while (true) {
            try {
                return callable.call();
            }
            catch (Exception e) {
                if (++numRetries < maxRetries) {
                    String logMessage = String.format("Retryable threw an exception; retrying in %d seconds (%d/%d)", retryDelayInSeconds, numRetries, maxRetries);
                    if (tryQuietly) {
                        log.debug(e, logMessage);
                    } else {
                        log.warn(e, logMessage);
                    }
                    try {
                        Thread.sleep(retryDelayInSeconds * 1000);
                    }
                    catch (InterruptedException ie) {
                        throw new RuntimeException(ie);
                    }
                    continue;
                }
                if (onFailure != null) {
                    try {
                        if (tryQuietly) {
                            log.debug(e, "Retries exhausted, invoking onFailure()");
                        } else {
                            log.warn(e, "Retries exhausted, invoking onFailure()");
                        }
                        onFailure.accept(e);
                        return null;
                    }
                    catch (Exception e1) {
                        e1.addSuppressed(e);
                        Throwables.throwIfUnchecked((Throwable)e1);
                        throw new RuntimeException(e1);
                    }
                }
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
            break;
        }
    }

    public static void of(Runnable runnable) {
        Retryable.of(runnable, null);
    }

    public static void of(Runnable runnable, int maxRetries, int retryDelayInSeconds) {
        Retryable.of(runnable, maxRetries, retryDelayInSeconds, null, false);
    }

    public static void of(Runnable runnable, Consumer<Exception> onFailure) {
        Retryable.of(runnable, 5, 5, onFailure, false);
    }

    public static void of(Runnable runnable, int maxRetries, int retryDelayInSeconds, Consumer<Exception> onFailure, boolean tryQuietly) {
        Retryable.of(() -> {
            runnable.run();
            return null;
        }, maxRetries, retryDelayInSeconds, onFailure, tryQuietly);
    }
}

