/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.util;

import com.google.common.collect.ImmutableMap;
import io.imply.cloud.config.MapboxConfig;
import io.imply.cloud.http.HttpClientProvider;
import io.imply.cloud.model.Account;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.Mapbox;
import io.imply.cloud.util.ISE;
import io.imply.cloud.util.JSON;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.util.StringContentProvider;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.MimeTypes;

public class MapboxClient {
    private static final int MAX_NOTE_LENGTH = 127;
    private static final String TOKEN_BASE = "https://api.mapbox.com/tokens/v2";
    private final JSON json;
    private final MapboxConfig mapboxConfig;
    private final HttpClientProvider httpClientProvider;

    public Optional<Mapbox> createToken(Account account, Cluster cluster) {
        ContentResponse response;
        if (!this.isConfigured()) {
            return Optional.empty();
        }
        Request request = this.httpClientProvider.get().newRequest("https://api.mapbox.com/tokens/v2/" + this.mapboxConfig.getAccountName()).method(HttpMethod.POST).param("access_token", this.mapboxConfig.getToken()).content((ContentProvider)new StringContentProvider(MimeTypes.Type.APPLICATION_JSON.asString(), this.json.toJson(ImmutableMap.of((Object)"note", (Object)StringUtils.substring((String)String.format("Account [%s] id [%s] cluster [%s]", account.getName(), account.getAccountId(), cluster.getName()), (int)0, (int)127), (Object)"scopes", this.mapboxConfig.getScopes())), StandardCharsets.UTF_8)).header(HttpHeader.ACCEPT, MimeTypes.Type.APPLICATION_JSON.asString());
        try {
            response = request.send();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ISE(e, "Failed to create a mapbox token", new Object[0]);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new ISE(e, "Failed to create a mapbox token", new Object[0]);
        }
        if (response.getStatus() / 100 != 2) {
            throw new ISE("Status code [%d] calling mapbox", response.getStatus());
        }
        return Optional.ofNullable(this.json.fromJson(response.getContentAsString(), Mapbox.class));
    }

    public boolean isValid(Mapbox mapbox) {
        ContentResponse response;
        if (mapbox == null || mapbox.isEmpty() || StringUtils.isBlank((CharSequence)mapbox.getToken())) {
            return false;
        }
        Request request = this.httpClientProvider.get().newRequest(TOKEN_BASE).method(HttpMethod.GET).param("access_token", mapbox.getToken()).header(HttpHeader.ACCEPT, MimeTypes.Type.APPLICATION_JSON.asString());
        try {
            response = request.send();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ISE(e, "Failed to query a mapbox token", new Object[0]);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new ISE(e, "Failed to query a mapbox token", new Object[0]);
        }
        if (response.getStatus() / 100 != 2) {
            throw new ISE("Status code [%d] querying mapbox", response.getStatus());
        }
        return "TokenValid".equalsIgnoreCase(this.json.fromJson(response.getContentAsString()).get("code").toString());
    }

    public void deleteToken(Mapbox mapbox) {
        ContentResponse response;
        if (!this.isConfigured() || mapbox == null || StringUtils.isBlank((CharSequence)mapbox.getId())) {
            return;
        }
        Request request = this.httpClientProvider.get().newRequest("https://api.mapbox.com/tokens/v2/" + this.mapboxConfig.getAccountName() + "/" + mapbox.getId()).method(HttpMethod.DELETE).param("access_token", this.mapboxConfig.getToken()).header(HttpHeader.ACCEPT, MimeTypes.Type.APPLICATION_JSON.asString());
        try {
            response = request.send();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ISE(e, "Failed to delete a mapbox token", new Object[0]);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new ISE(e, "Failed to delete a mapbox token", new Object[0]);
        }
        if (response.getStatus() == 404) {
            return;
        }
        if (response.getStatus() / 100 != 2) {
            throw new ISE("Status code [%d] deleting mapbox token", response.getStatus());
        }
    }

    public boolean isConfigured() {
        return this.mapboxConfig != null && StringUtils.isNotBlank((CharSequence)this.mapboxConfig.getToken()) && StringUtils.isNotBlank((CharSequence)this.mapboxConfig.getAccountName()) && CollectionUtils.isNotEmpty(this.mapboxConfig.getScopes());
    }

    @Inject
    @Generated
    public MapboxClient(JSON json, MapboxConfig mapboxConfig, HttpClientProvider httpClientProvider) {
        this.json = json;
        this.mapboxConfig = mapboxConfig;
        this.httpClientProvider = httpClientProvider;
    }
}

