/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.util;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.fge.jsonpatch.mergepatch.JsonMergePatch;
import com.google.common.base.Throwables;
import io.imply.cloud.Constants;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class JSON {
    private final ObjectMapper mapper;

    @Inject
    public JSON(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public ObjectMapper getObjectMapper() {
        return this.mapper;
    }

    public boolean isJson(String str) {
        try {
            this.mapper.readValue(str, Constants.MAP_TYPE);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String toJson(Object o) {
        return this.toJson(o, false);
    }

    public String toJson(Object o, boolean pretty) {
        try {
            if (pretty) {
                return this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString(o);
            }
            return this.mapper.writeValueAsString(o);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new JsonException(e);
        }
    }

    public byte[] toJsonBytes(Object o) {
        try {
            return this.mapper.writeValueAsBytes(o);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new JsonException(e);
        }
    }

    public Map<String, Object> fromJson(String str) {
        return this.fromJson(str, Constants.MAP_TYPE);
    }

    public <T> T fromJson(String str, TypeReference<T> type) {
        try {
            return (T)this.mapper.readValue(str, type);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new JsonException(e);
        }
    }

    public <T> T fromJson(String str, Class<T> type) {
        try {
            return (T)this.mapper.readValue(str, type);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new JsonException(e);
        }
    }

    public <T> T merge(T a, T b) {
        try {
            JsonNode original = this.mapper.valueToTree(a);
            JsonNode patch = this.mapper.valueToTree(b);
            return (T)this.mapper.treeToValue((TreeNode)JsonMergePatch.fromJson((JsonNode)patch).apply(original), a.getClass());
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new JsonException(e);
        }
    }

    public <T> T merge(T a, String b) {
        try {
            JsonNode original = this.mapper.valueToTree(a);
            JsonNode patch = this.mapper.readTree(b);
            return (T)this.mapper.treeToValue((TreeNode)JsonMergePatch.fromJson((JsonNode)patch).apply(original), a.getClass());
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new JsonException(e);
        }
    }

    public static class JsonException
    extends RuntimeException {
        public JsonException(Throwable e) {
            super(e);
        }
    }
}

