/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.tls;

import io.imply.cloud.tls.CertAndKeyHolder;
import io.imply.cloud.tls.SubjectInfo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.math.BigInteger;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.ExtensionsGenerator;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.RSAKeyPairGenerator;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.crypto.util.PrivateKeyInfoFactory;
import org.bouncycastle.crypto.util.SubjectPublicKeyInfoFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.bc.BcRSAContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.PKCS10CertificationRequestBuilder;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;

public class TLSUtils {
    public static final String PEM_PRIVATE_KEY_DESCRIPTION = "PRIVATE KEY";
    public static final String PEM_PUBLIC_KEY_DESCRIPTION = "PUBLIC KEY";
    public static final String PEM_CERTIFICATE_DESCRIPTION = "CERTIFICATE";
    public static final String PEM_CRL_DESCRIPTION = "X509 CRL";
    private static final long CERT_LIFESPAN_MILLIS = 630720000000L;
    private static final String KEYSTORE_PRIVATE_KEY_ALIAS = "druid";

    public static CertAndKeyHolder generateIntermediateKeysAndCert(SubjectInfo intermediateSubjectInfo, byte[] rootPrivateKey, byte[] rootCertificate, int keyLength, int certainty) throws Exception {
        X509CertificateHolder rootCertHolder = new X509CertificateHolder(rootCertificate);
        AsymmetricCipherKeyPair pair = TLSUtils.generateKeyPair(keyLength, certainty);
        PrivateKeyInfo intermediatePrivateKeyInfo = PrivateKeyInfoFactory.createPrivateKeyInfo((AsymmetricKeyParameter)pair.getPrivate());
        SubjectPublicKeyInfo intermediatePublicKeyInfo = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo((AsymmetricKeyParameter)pair.getPublic());
        PKCS10CertificationRequest csr = TLSUtils.generateIntermediateCSR(pair.getPrivate(), intermediatePublicKeyInfo, intermediateSubjectInfo);
        X509CertificateHolder intermediateCertHolder = TLSUtils.generateSignedIntermediateCert(rootCertHolder.getSubject(), csr, intermediatePublicKeyInfo, PrivateKeyFactory.createKey((byte[])rootPrivateKey), rootCertHolder.getSubjectPublicKeyInfo());
        return CertAndKeyHolder.of(intermediatePrivateKeyInfo.toASN1Primitive().getEncoded(), intermediatePublicKeyInfo.toASN1Primitive().getEncoded(), intermediateCertHolder.toASN1Structure().getEncoded());
    }

    public static CertAndKeyHolder generateServerKeysAndCert(SubjectInfo serverSubjectInfo, List<String> ipAddresses, List<String> hostnames, byte[] signingPrivateKey, byte[] signingCertificate, int keyLength, int certainty) throws Exception {
        X509CertificateHolder signingCertHolder = new X509CertificateHolder(signingCertificate);
        AsymmetricCipherKeyPair pair = TLSUtils.generateKeyPair(keyLength, certainty);
        PrivateKeyInfo serverPrivateKeyInfo = PrivateKeyInfoFactory.createPrivateKeyInfo((AsymmetricKeyParameter)pair.getPrivate());
        SubjectPublicKeyInfo serverPublicKeyInfo = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo((AsymmetricKeyParameter)pair.getPublic());
        GeneralNames subjectAlternativeNames = TLSUtils.getSubjectAlternativeNames(ipAddresses, hostnames);
        PKCS10CertificationRequest csr = TLSUtils.generateServerCSR(pair.getPrivate(), serverPublicKeyInfo, serverSubjectInfo, subjectAlternativeNames);
        X509CertificateHolder serverCertHolder = TLSUtils.generateSignedServerCert(signingCertHolder.getSubject(), csr, serverPublicKeyInfo, subjectAlternativeNames, PrivateKeyFactory.createKey((byte[])signingPrivateKey), signingCertHolder.getSubjectPublicKeyInfo());
        return CertAndKeyHolder.of(serverPrivateKeyInfo.toASN1Primitive().getEncoded(), serverPublicKeyInfo.toASN1Primitive().getEncoded(), serverCertHolder.toASN1Structure().getEncoded());
    }

    public static byte[] writePemBytes(String type, byte[] content) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (PemWriter pemWriter = new PemWriter((Writer)new OutputStreamWriter(baos));){
                pemWriter.writeObject((PemObjectGenerator)new PemObject(type, content));
                pemWriter.flush();
                byArray = baos.toByteArray();
            }
            return byArray;
        }
    }

    public static byte[] generateServerKeystore(byte[] serverCertificate, byte[] serverPrivateKey, List<byte[]> intermediateCertificates, String keyManagerPassword, String keyStorePassword) throws Exception {
        KeyStore keystore = KeyStore.getInstance("JKS");
        keystore.load(null, null);
        JcaX509CertificateConverter certificateConverter = new JcaX509CertificateConverter();
        X509Certificate serverJKScert = certificateConverter.getCertificate(new X509CertificateHolder(serverCertificate));
        ArrayList<X509Certificate> chain = new ArrayList<X509Certificate>();
        chain.add(serverJKScert);
        if (intermediateCertificates != null) {
            for (byte[] certBytes : intermediateCertificates) {
                chain.add(certificateConverter.getCertificate(new X509CertificateHolder(certBytes)));
            }
        }
        JcaPEMKeyConverter pemKeyConverter = new JcaPEMKeyConverter();
        PrivateKeyInfo serverPrivateKeyInfo = PrivateKeyInfoFactory.createPrivateKeyInfo((AsymmetricKeyParameter)PrivateKeyFactory.createKey((byte[])serverPrivateKey));
        PrivateKey privateKey = pemKeyConverter.getPrivateKey(serverPrivateKeyInfo);
        keystore.setKeyEntry(KEYSTORE_PRIVATE_KEY_ALIAS, privateKey, keyManagerPassword.toCharArray(), chain.toArray(new Certificate[0]));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        keystore.store(baos, keyStorePassword.toCharArray());
        return baos.toByteArray();
    }

    public static byte[] generateClientTruststore(Map<String, byte[]> certificates, String trustStorePassword) throws Exception {
        KeyStore truststore = KeyStore.getInstance("JKS");
        truststore.load(null, null);
        JcaX509CertificateConverter certificateConverter = new JcaX509CertificateConverter();
        for (Map.Entry<String, byte[]> certificate : certificates.entrySet()) {
            X509Certificate x509Cert = certificateConverter.getCertificate(new X509CertificateHolder(certificate.getValue()));
            truststore.setCertificateEntry(certificate.getKey(), x509Cert);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        truststore.store(baos, trustStorePassword.toCharArray());
        return baos.toByteArray();
    }

    public static byte[] generateClientTruststore(String pemEncoded, String certNamePrefix, String trustStorePassword) throws Exception {
        try (PEMParser pemParser = new PEMParser((Reader)new StringReader(pemEncoded));){
            Object object;
            HashMap<String, byte[]> certificates = new HashMap<String, byte[]>();
            int i = 0;
            while ((object = pemParser.readObject()) != null) {
                if (!(object instanceof X509CertificateHolder)) continue;
                certificates.put(String.format("%s%d", certNamePrefix, i++), ((X509CertificateHolder)object).getEncoded());
            }
            byte[] byArray = TLSUtils.generateClientTruststore(certificates, trustStorePassword);
            return byArray;
        }
    }

    private static PrivateKey extractPrivateKey(String pemEncodedKey, String password) throws Exception {
        try (PEMParser pemParser = new PEMParser((Reader)new StringReader(pemEncodedKey));){
            PrivateKeyInfo privateKeyInfo;
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
            Object keyPair = pemParser.readObject();
            if (keyPair == null) {
                PrivateKey privateKey = null;
                return privateKey;
            }
            if (keyPair instanceof PEMEncryptedKeyPair) {
                PEMDecryptorProvider decryptionProv = new JcePEMDecryptorProviderBuilder().build(password.toCharArray());
                PEMKeyPair decryptedKeyPair = ((PEMEncryptedKeyPair)keyPair).decryptKeyPair(decryptionProv);
                privateKeyInfo = decryptedKeyPair.getPrivateKeyInfo();
            } else {
                privateKeyInfo = ((PEMKeyPair)keyPair).getPrivateKeyInfo();
            }
            PrivateKey privateKey = converter.getPrivateKey(privateKeyInfo);
            return privateKey;
        }
    }

    private static Map<String, X509Certificate> extractCertificateChain(String pemEncoded, String certNamePrefix) throws Exception {
        try (PEMParser pemParser = new PEMParser((Reader)new StringReader(pemEncoded));){
            Object object;
            HashMap<String, X509Certificate> certificates = new HashMap<String, X509Certificate>();
            int i = 0;
            JcaX509CertificateConverter certificateConverter = new JcaX509CertificateConverter();
            while ((object = pemParser.readObject()) != null) {
                if (!(object instanceof X509CertificateHolder)) continue;
                X509Certificate x509Cert = certificateConverter.getCertificate((X509CertificateHolder)object);
                certificates.put(String.format("%s%d", certNamePrefix, i++), x509Cert);
            }
            HashMap<String, X509Certificate> hashMap = certificates;
            return hashMap;
        }
    }

    public static byte[] generateClientKeystore(String pemEncodedClientCert, String pemEncodedClientKey, String certNamePrefix, String keyStorePassword) throws Exception {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            Map<String, X509Certificate> certificates = TLSUtils.extractCertificateChain(pemEncodedClientCert, certNamePrefix);
            PrivateKey privateKey = TLSUtils.extractPrivateKey(pemEncodedClientKey, "");
            KeyStore keystore = KeyStore.getInstance("JKS");
            keystore.load(null, null);
            for (Map.Entry<String, X509Certificate> cert : certificates.entrySet()) {
                keystore.setCertificateEntry(cert.getKey(), cert.getValue());
            }
            if (privateKey != null) {
                keystore.setKeyEntry("client-key", privateKey, keyStorePassword.toCharArray(), certificates.values().toArray(new Certificate[0]));
            }
            keystore.store(baos, keyStorePassword.toCharArray());
            Object object = baos.toByteArray();
            return object;
        }
    }

    public static byte[] generateClientDERFromPEM(String pemEncodedClientKey) throws Exception {
        try (PEMParser pemParser = new PEMParser((Reader)new StringReader(pemEncodedClientKey));){
            Object keyPair = pemParser.readObject();
            if (keyPair != null && keyPair instanceof PrivateKeyInfo) {
                PrivateKeyInfo privateKeyInfo = (PrivateKeyInfo)keyPair;
                byte[] byArray = privateKeyInfo.getEncoded("DER");
                return byArray;
            }
            byte[] byArray = new byte[]{};
            return byArray;
        }
    }

    private static PKCS10CertificationRequest generateIntermediateCSR(AsymmetricKeyParameter intermediatePrivateKey, SubjectPublicKeyInfo intermediatePublicKeyInfo, SubjectInfo intermediateSubjectInfo) throws Exception {
        AlgorithmIdentifier sigAlgId = new DefaultSignatureAlgorithmIdentifierFinder().find("SHA256withRSA");
        AlgorithmIdentifier digAlgId = new DefaultDigestAlgorithmIdentifierFinder().find(sigAlgId);
        ContentSigner contentSigner = new BcRSAContentSignerBuilder(sigAlgId, digAlgId).build(intermediatePrivateKey);
        X500Name serverDN = TLSUtils.subjectInfoToX500Name(intermediateSubjectInfo);
        PKCS10CertificationRequestBuilder csrBuilder = new PKCS10CertificationRequestBuilder(serverDN, intermediatePublicKeyInfo);
        return csrBuilder.build(contentSigner);
    }

    private static X509CertificateHolder generateSignedIntermediateCert(X500Name rootName, PKCS10CertificationRequest csr, SubjectPublicKeyInfo intermediatePublicKeyInfo, AsymmetricKeyParameter rootPrivateKey, SubjectPublicKeyInfo rootPublicKeyInfo) throws Exception {
        Date startDate = new Date(System.currentTimeMillis());
        Date endDate = new Date(startDate.getTime() + 630720000000L);
        UUID serverUUID = UUID.randomUUID();
        BigInteger certSerial = new BigInteger(serverUUID.toString().replaceAll("-", ""), 16);
        X509v3CertificateBuilder certificateBuilder = new X509v3CertificateBuilder(rootName, certSerial, startDate, endDate, csr.getSubject(), intermediatePublicKeyInfo);
        JcaX509ExtensionUtils extensionUtils = new JcaX509ExtensionUtils();
        certificateBuilder.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(10));
        certificateBuilder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)extensionUtils.createSubjectKeyIdentifier(intermediatePublicKeyInfo));
        certificateBuilder.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)extensionUtils.createAuthorityKeyIdentifier(rootPublicKeyInfo));
        AlgorithmIdentifier sigAlgId = new DefaultSignatureAlgorithmIdentifierFinder().find("SHA256withRSA");
        AlgorithmIdentifier digAlgId = new DefaultDigestAlgorithmIdentifierFinder().find(sigAlgId);
        ContentSigner contentSigner = new BcRSAContentSignerBuilder(sigAlgId, digAlgId).build(rootPrivateKey);
        return certificateBuilder.build(contentSigner);
    }

    private static PKCS10CertificationRequest generateServerCSR(AsymmetricKeyParameter serverPrivateKey, SubjectPublicKeyInfo serverPublicKeyInfo, SubjectInfo serverSubjectInfo, GeneralNames subjectAlternativeNames) throws Exception {
        AlgorithmIdentifier sigAlgId = new DefaultSignatureAlgorithmIdentifierFinder().find("SHA256withRSA");
        AlgorithmIdentifier digAlgId = new DefaultDigestAlgorithmIdentifierFinder().find(sigAlgId);
        ContentSigner contentSigner = new BcRSAContentSignerBuilder(sigAlgId, digAlgId).build(serverPrivateKey);
        X500Name serverDN = TLSUtils.subjectInfoToX500Name(serverSubjectInfo);
        ExtensionsGenerator extGen = new ExtensionsGenerator();
        extGen.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)subjectAlternativeNames);
        PKCS10CertificationRequestBuilder csrBuilder = new PKCS10CertificationRequestBuilder(serverDN, serverPublicKeyInfo);
        csrBuilder.addAttribute(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest, (ASN1Encodable)extGen.generate());
        return csrBuilder.build(contentSigner);
    }

    private static X509CertificateHolder generateSignedServerCert(X500Name signingName, PKCS10CertificationRequest csr, SubjectPublicKeyInfo serverPublicKeyInfo, GeneralNames subjectAlternativeNames, AsymmetricKeyParameter signingPrivateKey, SubjectPublicKeyInfo signingPublicKeyInfo) throws Exception {
        Date startDate = new Date(System.currentTimeMillis());
        Date endDate = new Date(startDate.getTime() + 630720000000L);
        UUID serverUUID = UUID.randomUUID();
        BigInteger certSerial = new BigInteger(serverUUID.toString().replaceAll("-", ""), 16);
        X509v3CertificateBuilder certificateBuilder = new X509v3CertificateBuilder(signingName, certSerial, startDate, endDate, csr.getSubject(), serverPublicKeyInfo);
        certificateBuilder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)subjectAlternativeNames);
        JcaX509ExtensionUtils extensionUtils = new JcaX509ExtensionUtils();
        certificateBuilder.addExtension(Extension.basicConstraints, false, (ASN1Encodable)new BasicConstraints(false));
        certificateBuilder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)extensionUtils.createSubjectKeyIdentifier(serverPublicKeyInfo));
        certificateBuilder.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)extensionUtils.createAuthorityKeyIdentifier(signingPublicKeyInfo));
        AlgorithmIdentifier sigAlgId = new DefaultSignatureAlgorithmIdentifierFinder().find("SHA256withRSA");
        AlgorithmIdentifier digAlgId = new DefaultDigestAlgorithmIdentifierFinder().find(sigAlgId);
        ContentSigner contentSigner = new BcRSAContentSignerBuilder(sigAlgId, digAlgId).build(signingPrivateKey);
        return certificateBuilder.build(contentSigner);
    }

    private static AsymmetricCipherKeyPair generateKeyPair(int keyLength, int certainty) {
        RSAKeyGenerationParameters params = new RSAKeyGenerationParameters(BigInteger.valueOf(65537L), new SecureRandom(), keyLength, certainty);
        RSAKeyPairGenerator gen = new RSAKeyPairGenerator();
        gen.init((KeyGenerationParameters)params);
        return gen.generateKeyPair();
    }

    private static X500Name subjectInfoToX500Name(SubjectInfo subjectInfo) {
        if (subjectInfo == null || subjectInfo.getCommonName() == null) {
            throw new IllegalArgumentException("commonName must be provided");
        }
        X500NameBuilder serverDNBuilder = new X500NameBuilder();
        serverDNBuilder.addRDN(BCStyle.CN, subjectInfo.getCommonName());
        if (subjectInfo.getCountry() != null) {
            serverDNBuilder.addRDN(BCStyle.C, subjectInfo.getCountry());
        }
        if (subjectInfo.getState() != null) {
            serverDNBuilder.addRDN(BCStyle.ST, subjectInfo.getState());
        }
        if (subjectInfo.getCity() != null) {
            serverDNBuilder.addRDN(BCStyle.L, subjectInfo.getCity());
        }
        if (subjectInfo.getOrganization() != null) {
            serverDNBuilder.addRDN(BCStyle.O, subjectInfo.getOrganization());
        }
        return serverDNBuilder.build();
    }

    private static GeneralNames getSubjectAlternativeNames(List<String> ipAddresses, List<String> hostnames) {
        ArrayList<GeneralName> generalNameList = new ArrayList<GeneralName>();
        for (String ipAddr : ipAddresses) {
            generalNameList.add(new GeneralName(7, ipAddr));
        }
        for (String hostname : hostnames) {
            generalNameList.add(new GeneralName(2, hostname));
        }
        GeneralName[] generalNameArray = generalNameList.toArray(new GeneralName[0]);
        return new GeneralNames(generalNameArray);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

