/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.telemetry;

import com.codahale.metrics.MetricRegistry;
import io.imply.cloud.model.Account;
import io.imply.cloud.model.Cluster;
import io.imply.telemetry.Attribute;
import io.imply.telemetry.Event;
import io.imply.telemetry.MetricEvent;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;

public interface CloudEvent {
    public static final String REQUEST_ID = "request_id";
    public static final String IMPLY_VERSION = "imply_version";

    public static MetricEvent.Builder metricBuilder(String metric, Cluster cluster) {
        return CloudEvent.metricBuilder(metric, (Number)1, cluster);
    }

    public static MetricEvent.Builder metricBuilder(String metric, Number value, Cluster cluster) {
        return MetricEvent.builder((String)metric, (Number)value).addAttribute((Object)Attribute.ORGANIZATION_ID, (Object)cluster.getAccountId()).addAttribute((Object)Attribute.PROJECT_ID, (Object)cluster.getClusterId()).addAttribute((Object)IMPLY_VERSION, (Object)cluster.getImplyVersion());
    }

    public static MetricEvent metric(String metric, Cluster cluster) {
        return CloudEvent.metricBuilder(metric, cluster).build();
    }

    public static MetricEvent metric(String metric, Number value, Cluster cluster) {
        return CloudEvent.metricBuilder(metric, value, cluster).build();
    }

    public static MetricEvent.Builder metricBuilder(String metric, Account account) {
        return CloudEvent.metricBuilder(metric, (Number)1, account);
    }

    public static MetricEvent.Builder metricBuilder(String metric, Number value, Account account) {
        return MetricEvent.builder((String)metric, (Number)value).addAttribute((Object)Attribute.ORGANIZATION_ID, (Object)account.getAccountId());
    }

    public static MetricEvent metric(String metric, Account account) {
        return CloudEvent.metricBuilder(metric, account).build();
    }

    public static MetricEvent metric(String metric, Number value, Account account) {
        return CloudEvent.metricBuilder(metric, value, account).build();
    }

    public static String named(String metric, Cluster cluster, String ... attrs) {
        return Event.name((String)metric, (String[])((String[])ArrayUtils.insert((int)0, (Object[])CloudEvent.sanitize(ArrayUtils.nullToEmpty((String[])attrs)), (Object[])new String[]{cluster.getAccountId(), cluster.getClusterId()})));
    }

    public static String named(Class<?> clazz, String name, Cluster cluster, String ... attrs) {
        return CloudEvent.named(MetricRegistry.name(clazz, (String[])new String[]{name}), cluster, attrs);
    }

    public static String[] sanitize(String ... attrs) {
        return (String[])Stream.of(attrs).map(attr -> attr.replace(".", "_")).toArray(String[]::new);
    }
}

