/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.security;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import io.imply.cloud.security.ImplyToken;
import io.imply.cloud.security.SymmetricTokenValidator;
import io.imply.cloud.security.druid.Action;
import io.imply.cloud.security.druid.Resource;
import io.imply.cloud.security.druid.ResourceAction;
import io.imply.cloud.security.druid.ResourceType;
import io.imply.cloud.util.Logger;
import java.security.GeneralSecurityException;
import java.util.Base64;
import java.util.List;
import lombok.Generated;
import org.joda.time.DateTime;

public class ImplyTokenManager {
    private static final Logger log = new Logger(ImplyTokenManager.class);
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final Object tokenLock = new Object();
    private final int tokenLifetime;
    private final SymmetricTokenValidator tokenValidator;
    private DateTime tokenExpiry;
    private String encodedToken;
    private String tokenSignature;

    public ImplyTokenManager(String hmac) {
        this.tokenValidator = this.getSymmetricTokenValidator(hmac);
        this.tokenLifetime = 60;
    }

    @VisibleForTesting
    protected ImplyTokenManager(String hmac, int tokenExpiry) {
        this.tokenValidator = this.getSymmetricTokenValidator(hmac);
        this.tokenLifetime = tokenExpiry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImplyTokenResult getToken() {
        Object object = this.tokenLock;
        synchronized (object) {
            this.updateTokensIfNeeded();
            return new ImplyTokenResult(this.encodedToken, this.tokenSignature);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTokensIfNeeded() {
        Object object = this.tokenLock;
        synchronized (object) {
            if (this.encodedToken == null || this.isTokenExpired()) {
                this.grantToken();
            }
        }
    }

    private void grantToken() {
        String tokenString;
        DateTime expiry = DateTime.now().plusMinutes(this.tokenLifetime);
        ImplyToken token = new ImplyToken("IMPLY_CLOUD_BACKEND", expiry.getMillis(), (List<ResourceAction>)ImmutableList.of((Object)new ResourceAction(new Resource(".*", ResourceType.DATASOURCE), Action.READ), (Object)new ResourceAction(new Resource(".*", ResourceType.DATASOURCE), Action.WRITE), (Object)new ResourceAction(new Resource(".*", ResourceType.CONFIG), Action.WRITE), (Object)new ResourceAction(new Resource(".*", ResourceType.CONFIG), Action.READ), (Object)new ResourceAction(new Resource(".*", ResourceType.STATE), Action.WRITE), (Object)new ResourceAction(new Resource(".*", ResourceType.STATE), Action.READ), (Object)new ResourceAction(new Resource(".*", ResourceType.SYSTEM_TABLE), Action.WRITE), (Object)new ResourceAction(new Resource(".*", ResourceType.SYSTEM_TABLE), Action.READ), (Object)new ResourceAction(new Resource(".*", ResourceType.EXTERNAL), Action.WRITE), (Object)new ResourceAction(new Resource(".*", ResourceType.EXTERNAL), Action.READ), (Object)new ResourceAction(new Resource(".*", ResourceType.QUERY_CONTEXT), Action.WRITE), (Object)new ResourceAction(new Resource(".*", ResourceType.QUERY_CONTEXT), Action.READ), (Object[])new ResourceAction[0]));
        try {
            tokenString = this.objectMapper.writeValueAsString((Object)token);
        }
        catch (JsonProcessingException e) {
            log.error(e, "Failed to serialize token");
            throw new RuntimeException(e);
        }
        String encodedToken = Base64.getEncoder().encodeToString(tokenString.getBytes());
        String tokenSignature = this.tokenValidator.getSignature(encodedToken);
        this.updateToken(encodedToken, tokenSignature, expiry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateToken(String encodedToken, String tokenSignature, DateTime expiry) {
        Object object = this.tokenLock;
        synchronized (object) {
            this.encodedToken = encodedToken;
            this.tokenSignature = tokenSignature;
            this.tokenExpiry = expiry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isTokenExpired() {
        Object object = this.tokenLock;
        synchronized (object) {
            return this.tokenExpiry.minusMinutes(20).isBeforeNow();
        }
    }

    private SymmetricTokenValidator getSymmetricTokenValidator(String hmac) {
        try {
            return new SymmetricTokenValidator(hmac);
        }
        catch (GeneralSecurityException e) {
            log.error(e, "Failed to create token validator");
            throw new RuntimeException(e);
        }
    }

    public static class ImplyTokenResult {
        private final String encodedToken;
        private final String tokenSignature;

        public ImplyTokenResult(String encodedToken, String tokenSignature) {
            this.encodedToken = encodedToken;
            this.tokenSignature = tokenSignature;
        }

        @Generated
        public String getEncodedToken() {
            return this.encodedToken;
        }

        @Generated
        public String getTokenSignature() {
            return this.tokenSignature;
        }
    }
}

