/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.resteasy;

import com.google.inject.Inject;
import com.google.inject.Injector;
import io.imply.cloud.resteasy.DefaultGeneralValidatorImpl;
import io.imply.cloud.resteasy.GuiceConstraintValidatorFactory;
import io.imply.cloud.util.Logger;
import java.util.Set;
import javax.validation.BootstrapConfiguration;
import javax.validation.Configuration;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import lombok.Generated;
import org.jboss.resteasy.spi.validation.GeneralValidator;

@Provider
public class GeneralValidatorContextResolver
implements ContextResolver<GeneralValidator> {
    @Generated
    private static final Logger log = Logger.from(GeneralValidatorContextResolver.class);
    private final Validator validator;

    @Inject
    public GeneralValidatorContextResolver(Injector injector) {
        this.validator = this.getValidator(injector);
    }

    private Validator getValidator(Injector injector) {
        log.info("Creating hibernate validator");
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        return factory.usingContext().constraintValidatorFactory((ConstraintValidatorFactory)new GuiceConstraintValidatorFactory(injector)).getValidator();
    }

    public GeneralValidator getContext(Class<?> type) {
        Configuration config = Validation.byDefaultProvider().configure();
        BootstrapConfiguration bootstrapConfiguration = config.getBootstrapConfiguration();
        boolean isExecutableValidationEnabled = bootstrapConfiguration.isExecutableValidationEnabled();
        Set defaultValidatedExecutableTypes = bootstrapConfiguration.getDefaultValidatedExecutableTypes();
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        return new DefaultGeneralValidatorImpl(this.validator, factory, isExecutableValidationEnabled, defaultValidatedExecutableTypes);
    }
}

