/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.persistence.postgresql;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Supplier;
import com.google.inject.Inject;
import io.imply.cloud.persistence.SQLStorageConnector;
import io.imply.cloud.persistence.StorageConnectorConfig;
import io.imply.cloud.persistence.postgresql.PostgreSQLTablesConfig;
import io.imply.cloud.util.Logger;
import io.imply.cloud.util.StringUtils;
import java.net.URI;
import java.net.URISyntaxException;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.tweak.ResultColumnMapper;
import org.skife.jdbi.v2.util.StringColumnMapper;

public class PostgreSQLStorageConnector
extends SQLStorageConnector {
    private static final Logger log = new Logger(PostgreSQLStorageConnector.class);
    private static final String PAYLOAD_TYPE = "BYTEA";
    private static final String SERIAL_TYPE = "BIGSERIAL";
    private static final String QUOTE_STRING = "\\\"";
    public static final int DEFAULT_STREAMING_RESULT_SIZE = 100;
    private final DBI dbi;
    private final String dbTableSchema;

    @Inject
    public PostgreSQLStorageConnector(Supplier<StorageConnectorConfig> config, PostgreSQLTablesConfig tablesConfig, MetricRegistry metricRegistry) {
        super(config, metricRegistry);
        this.dbTableSchema = tablesConfig.getDbTableSchema();
        if (!((StorageConnectorConfig)config.get()).isSkipCreateDbCheck()) {
            PostgreSQLStorageConnector.createDatabaseIfNotExists(this.getConfig().getConnectURI(), this.getConfig().getUser(), this.getConfig().getPassword());
            PostgreSQLStorageConnector.createSchemaIfNotExists(this.getConfig().getConnectURI(), this.getConfig().getUser(), this.getConfig().getPassword(), this.dbTableSchema);
        }
        BasicDataSource datasource = this.getDatasource();
        datasource.setDriverClassLoader(this.getClass().getClassLoader());
        datasource.setDriverClassName("org.postgresql.Driver");
        this.dbi = this.createDBI((DataSource)datasource);
        log.info("Configured PostgreSQL as data storage");
    }

    @Override
    public String getPayloadType() {
        return PAYLOAD_TYPE;
    }

    @Override
    protected String getSerialType() {
        return SERIAL_TYPE;
    }

    @Override
    protected int getStreamingFetchSize() {
        return 100;
    }

    @Override
    public String getQuoteString() {
        return QUOTE_STRING;
    }

    @Override
    public boolean tableExists(Handle handle, String tableName) {
        return !((Query)((Query)handle.createQuery("SELECT tablename FROM pg_catalog.pg_tables WHERE schemaname = :dbTableSchema AND tablename ILIKE :tableName").bind("dbTableSchema", this.dbTableSchema)).bind("tableName", tableName)).map((ResultColumnMapper)StringColumnMapper.INSTANCE).list().isEmpty();
    }

    @Override
    protected boolean indexExists(String tableName, String indexName) {
        return super.indexExists(StringUtils.toLowerCase(tableName), indexName);
    }

    @Override
    public DBI getDBI() {
        return this.dbi;
    }

    private static BasicDataSource createBasicDataSource(String user, String password, String connectURI) {
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setUsername(user);
        dataSource.setPassword(password);
        dataSource.setUrl(connectURI);
        dataSource.setValidationQuery("SELECT 1");
        dataSource.setDriverClassName("org.postgresql.Driver");
        return dataSource;
    }

    private static void createSchemaIfNotExists(String connectURI, String user, String password, String dbTableSchema) {
        try {
            URI uri = new URI(connectURI.replaceFirst("^jdbc:", ""));
            String database = StringUtils.stripLeadingAndTrailingChars('/', uri.getPath());
            PostgreSQLStorageConnector.createSchemaIfNotExists(connectURI, database, user, password, dbTableSchema);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private static void createSchemaIfNotExists(String connectURI, String database, String user, String password, String dbTableSchema) {
        BasicDataSource dataSource = PostgreSQLStorageConnector.createBasicDataSource(user, password, connectURI);
        DBI dbi = new DBI((DataSource)dataSource);
        log.info("Testing for existence of schema [%s] in [%s]...", dbTableSchema, database);
        String schemaQuery = String.format("SELECT nspname FROM pg_namespace WHERE nspname='%s';", dbTableSchema);
        String schemaRetVal = (String)dbi.withHandle(handle -> (String)handle.createQuery(String.format(schemaQuery, new Object[0])).map((ResultColumnMapper)StringColumnMapper.INSTANCE).first());
        if (schemaRetVal == null) {
            log.info("Schema [%s] not found.  Creating in database [%s]...", dbTableSchema, database);
            dbi.withHandle(handle -> handle.createStatement(String.format("CREATE SCHEMA \"%s\";", dbTableSchema)).execute());
            log.info("Schema [%s] created successfully.", dbTableSchema);
        }
        log.info("Setting database search_path to use schema [%s]...", dbTableSchema);
        dbi.withHandle(handle -> handle.createStatement(String.format("ALTER DATABASE \"%s\" SET search_path TO \"%s\";", database, dbTableSchema)).execute());
        log.info("Schema [%s] successfully configured.", dbTableSchema);
    }

    private static void createDatabaseIfNotExists(String connectURI, String user, String password) {
        try {
            URI uri = new URI(connectURI.replaceFirst("^jdbc:", ""));
            PostgreSQLStorageConnector.createDatabaseIfNotExists(uri.getHost(), uri.getPort(), StringUtils.stripLeadingAndTrailingChars('/', uri.getPath()), user, password, uri.getQuery());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static void createDatabaseIfNotExists(String host, int port, String database, String user, String password, String connectionParameters) {
        String connectURI = String.format("jdbc:postgresql://%s:%d/postgres%s", host, port, connectionParameters != null ? "?" + connectionParameters : "");
        BasicDataSource dataSource = PostgreSQLStorageConnector.createBasicDataSource(user, password, connectURI);
        DBI dbi = new DBI((DataSource)dataSource);
        log.info("Testing for existence of database [%s] @ [%s]", database, connectURI);
        String query = String.format("SELECT datname FROM pg_database WHERE datname='%s';", database);
        String retVal = (String)dbi.withHandle(handle -> (String)handle.createQuery(String.format(query, new Object[0])).map((ResultColumnMapper)StringColumnMapper.INSTANCE).first());
        if (retVal != null) {
            return;
        }
        log.info("Creating database [%s] @ [%s]", database, connectURI);
        dbi.withHandle(handle -> handle.createStatement(String.format("CREATE DATABASE \"%s\" WITH ENCODING 'UTF8';", database)).execute());
    }
}

