/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.persistence.mysql;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.imply.cloud.model.JdbcURIParser;
import io.imply.cloud.persistence.SQLStorageConnector;
import io.imply.cloud.persistence.StorageConnectorConfig;
import io.imply.cloud.util.ISE;
import io.imply.cloud.util.Logger;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.sql.SQLTransientException;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.tweak.ResultColumnMapper;
import org.skife.jdbi.v2.util.BooleanColumnMapper;
import org.skife.jdbi.v2.util.StringColumnMapper;

public class MySQLStorageConnector
extends SQLStorageConnector {
    private static final Logger log = new Logger(MySQLStorageConnector.class);
    private static final String PAYLOAD_TYPE = "LONGBLOB";
    private static final String SERIAL_TYPE = "BIGINT(20) AUTO_INCREMENT";
    private static final String QUOTE_STRING = "`";
    private final DBI dbi;

    @Inject
    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"})
    public MySQLStorageConnector(Supplier<StorageConnectorConfig> config, MetricRegistry metricRegistry) {
        super(config, metricRegistry);
        JdbcURIParser jdbcURI;
        try {
            jdbcURI = JdbcURIParser.parse(this.getConfig().getConnectURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        if (!((StorageConnectorConfig)config.get()).isSkipCreateDbCheck()) {
            MySQLStorageConnector.createDatabaseIfNotExists(this.getConfig().getConnectURI(), this.getConfig().getUser(), this.getConfig().getPassword());
        }
        BasicDataSource datasource = this.getDatasource();
        datasource.setDriverClassLoader(this.getClass().getClassLoader());
        datasource.setDriverClassName(MySQLStorageConnector.getDriverClassName(jdbcURI.getProtocol()));
        datasource.setConnectionInitSqls((List)ImmutableList.of((Object)"SET sql_mode='ANSI_QUOTES'"));
        this.dbi = this.createDBI((DataSource)datasource);
        log.info("Configured MySQL as data storage");
    }

    @Override
    public String getPayloadType() {
        return PAYLOAD_TYPE;
    }

    @Override
    protected String getSerialType() {
        return SERIAL_TYPE;
    }

    @Override
    public String getQuoteString() {
        return QUOTE_STRING;
    }

    @Override
    protected int getStreamingFetchSize() {
        return Integer.MIN_VALUE;
    }

    @Override
    public boolean tableExists(Handle handle, String tableName) {
        boolean isUtf8 = (Boolean)handle.createQuery("SELECT @@character_set_database = 'utf8' OR @@character_set_database = 'utf8mb4'").map((ResultColumnMapper)BooleanColumnMapper.PRIMITIVE).first();
        if (!isUtf8) {
            throw new ISE("Database default character set is not 'utf8' or 'utf8mb4'.", new Object[0]);
        }
        return !((Query)handle.createQuery("SHOW tables LIKE :tableName").bind("tableName", tableName)).list().isEmpty();
    }

    @Override
    protected boolean connectorIsTransientException(Throwable e) {
        return e instanceof SQLTransientException || e instanceof SQLException && ((SQLException)e).getErrorCode() == 1317;
    }

    @Override
    public DBI getDBI() {
        return this.dbi;
    }

    private static void createDatabaseIfNotExists(String connectURI, String user, String password) {
        try {
            JdbcURIParser jdbcURI = JdbcURIParser.parse(connectURI);
            MySQLStorageConnector.createDatabaseIfNotExists(jdbcURI.getProtocol(), jdbcURI.getHost(), jdbcURI.getPort(), StringUtils.strip((String)jdbcURI.getPath(), (String)"/"), user, password, jdbcURI.getQuery());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static void createDatabaseIfNotExists(String protocol, String host, int port, String database, String user, String password, String connectionParameters) {
        String connectURI = String.format("jdbc:%s://%s:%d%s", StringUtils.isEmpty((CharSequence)protocol) ? "mysql" : protocol, host, port, connectionParameters != null ? "?" + connectionParameters : "");
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setUsername(user);
        dataSource.setPassword(password);
        dataSource.setUrl(connectURI);
        dataSource.setValidationQuery("SELECT 1");
        dataSource.setDriverClassName(MySQLStorageConnector.getDriverClassName(protocol));
        dataSource.setConnectionInitSqls((List)ImmutableList.of((Object)"SET sql_mode='ANSI_QUOTES'"));
        DBI dbi = new DBI((DataSource)dataSource);
        log.info("Testing for existence of database [%s] @ [%s]", database, connectURI);
        String retVal = (String)dbi.withHandle(handle -> (String)handle.createQuery(String.format("SHOW DATABASES LIKE '%s';", database)).map((ResultColumnMapper)StringColumnMapper.INSTANCE).first());
        if (retVal != null) {
            return;
        }
        log.info("Creating database [%s] @ [%s]", database, connectURI);
        dbi.withHandle(handle -> handle.createStatement(String.format("CREATE SCHEMA IF NOT EXISTS `%s` DEFAULT CHARACTER SET utf8mb4;", database)).execute());
    }

    public static void createUserIfNotExists(String protocol, String host, int port, String creationUser, String creationPassword, String user, String password, String connectionParameters) {
        String connectURI = String.format("jdbc:%s://%s:%d%s", StringUtils.isEmpty((CharSequence)protocol) ? "mysql" : protocol, host, port, connectionParameters != null ? "?" + connectionParameters : "");
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setUsername(user);
        dataSource.setPassword(password);
        dataSource.setUrl(connectURI);
        dataSource.setValidationQuery("SELECT 1");
        dataSource.setDriverClassName(MySQLStorageConnector.getDriverClassName(protocol));
        dataSource.setConnectionInitSqls((List)ImmutableList.of((Object)"SET sql_mode='ANSI_QUOTES'"));
        DBI dbi = new DBI((DataSource)dataSource);
        log.info("Testing for existence of user [%s] @ [%s]", creationUser, connectURI);
        String retVal = (String)dbi.withHandle(handle -> (String)handle.createQuery(String.format("SELECT 1 FROM mysql.user WHERE user = '%s';", creationUser)).map((ResultColumnMapper)StringColumnMapper.INSTANCE).first());
        if (retVal != null) {
            log.info("User [%s] already exists, altering password @ [%s]", creationUser, connectURI);
            dbi.withHandle(handle -> handle.createStatement(String.format("ALTER USER '%s'@'%%' IDENTIFIED BY '%s';", creationUser, creationPassword)).execute());
        }
        log.info("Creating user [%s] @ [%s]", creationUser, connectURI);
        dbi.withHandle(handle -> handle.createStatement(String.format("CREATE USER IF NOT EXISTS '%s'@'%%' IDENTIFIED BY '%s';", creationUser, creationPassword)).execute());
    }

    public static void grantUserAllPrivilegesForDatabase(String protocol, String host, int port, String database, String creationUser, String user, String password, String connectionParameters) {
        String connectURI = String.format("jdbc:%s://%s:%d%s", StringUtils.isEmpty((CharSequence)protocol) ? "mysql" : protocol, host, port, connectionParameters != null ? "?" + connectionParameters : "");
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setUsername(user);
        dataSource.setPassword(password);
        dataSource.setUrl(connectURI);
        dataSource.setValidationQuery("SELECT 1");
        dataSource.setDriverClassName(MySQLStorageConnector.getDriverClassName(protocol));
        dataSource.setConnectionInitSqls((List)ImmutableList.of((Object)"SET sql_mode='ANSI_QUOTES'"));
        DBI dbi = new DBI((DataSource)dataSource);
        log.info("Testing for existence of user [%s] @ [%s]", creationUser, connectURI);
        String retVal = (String)dbi.withHandle(handle -> (String)handle.createQuery(String.format("SELECT 1 FROM mysql.user WHERE user = '%s';", creationUser)).map((ResultColumnMapper)StringColumnMapper.INSTANCE).first());
        if (retVal == null) {
            throw new ISE(String.format("User [%s] not found @ [%s]", creationUser, connectURI), new Object[0]);
        }
        log.info("Granting user [%s] all privileges for database [%s] @ [%s]", creationUser, database, connectURI);
        dbi.withHandle(handle -> handle.createStatement(String.format("GRANT ALL PRIVILEGES ON `%s`.* TO '%s'@'%%';", database, creationUser)).execute());
    }

    private static String getDriverClassName(String protocol) {
        if (Strings.CS.indexOf((CharSequence)protocol, (CharSequence)"aws-wrapper") != -1) {
            return "software.amazon.jdbc.Driver";
        }
        return "org.mariadb.jdbc.Driver";
    }
}

