/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.persistence.cache;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.imply.cloud.cache.Cache;
import io.imply.cloud.cache.CacheKey;
import io.imply.cloud.model.Notification;
import io.imply.cloud.model.Notifications;
import io.imply.cloud.persistence.NotificationDataManager;
import io.imply.cloud.util.Logger;

public class CachedNotificationDataManager
implements NotificationDataManager {
    private static final Logger log = new Logger(CachedNotificationDataManager.class);
    private final NotificationDataManager notificationDataManager;
    private final Cache cache;
    private final ObjectMapper objectMapper;

    public CachedNotificationDataManager(NotificationDataManager notificationDataManager, Cache cache, ObjectMapper objectMapper) {
        this.notificationDataManager = notificationDataManager;
        this.cache = cache;
        this.objectMapper = objectMapper;
    }

    @Override
    public Notification insert(Notification notification) {
        Notification retVal = this.notificationDataManager.insert(notification);
        this.cache.invalidate(CacheKey.notifications(retVal.getEntityKey()));
        return retVal;
    }

    @Override
    public Notifications getAllWithEntityKey(String entityKey) {
        Notifications retVal = this.deserialize(this.cache.get(CacheKey.notifications(entityKey)));
        if (retVal == null && (retVal = this.notificationDataManager.getAllWithEntityKey(entityKey)) != null && retVal.getEntityKey() != null) {
            this.cache.put(CacheKey.notifications(retVal.getEntityKey()), this.serialize(retVal));
        }
        return retVal;
    }

    @Override
    public void markNotificationsAsPrevious(String entityKey) {
        this.notificationDataManager.markNotificationsAsPrevious(entityKey);
        this.cache.invalidate(CacheKey.notifications(entityKey));
    }

    @Override
    public void deleteNotificationsWithLevel(String entityKey, Notification.Level level) {
        this.notificationDataManager.deleteNotificationsWithLevel(entityKey, level);
        this.cache.invalidate(CacheKey.notifications(entityKey));
    }

    @Override
    public void deleteNotificationsWithEntityKey(String entityKey) {
        this.notificationDataManager.deleteNotificationsWithEntityKey(entityKey);
        this.cache.invalidate(CacheKey.notifications(entityKey));
    }

    @Override
    public void delete(Notification notification) {
        this.notificationDataManager.delete(notification);
        this.cache.invalidate(CacheKey.notifications(notification.getEntityKey()));
    }

    private byte[] serialize(Notifications notifications) {
        if (notifications == null) {
            return null;
        }
        try {
            return this.objectMapper.writeValueAsBytes((Object)notifications);
        }
        catch (Exception e) {
            log.info(e, "Cache serialization failed: %s", notifications);
            return null;
        }
    }

    private Notifications deserialize(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return (Notifications)this.objectMapper.readValue(data, Notifications.class);
        }
        catch (Exception e) {
            log.info(e, "Cache deserialization failed");
            return null;
        }
    }
}

