/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.persistence.cache;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.imply.cloud.cache.Cache;
import io.imply.cloud.cache.CacheKey;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ClusterWithExtendedInfo;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.Region;
import io.imply.cloud.persistence.ClusterDataManager;
import io.imply.cloud.persistence.DeletedVisibility;
import io.imply.cloud.util.Logger;
import java.util.ArrayList;
import java.util.List;
import org.skife.jdbi.v2.Handle;

public class CachedClusterDataManager
implements ClusterDataManager {
    private static final Logger log = new Logger(CachedClusterDataManager.class);
    private final ClusterDataManager clusterDataManager;
    private final Cache cache;
    private final ObjectMapper objectMapper;

    public CachedClusterDataManager(ClusterDataManager clusterDataManager, Cache cache, ObjectMapper objectMapper) {
        this.clusterDataManager = clusterDataManager;
        this.cache = cache;
        this.objectMapper = objectMapper;
    }

    @Override
    public ClusterWithExtendedInfo createWithInfo(Cluster cluster, Info info, String createdBy, boolean createEmptyClusterNodesEntry, boolean updateProposedClusterVersion, boolean updateConfigServerClusterVersion, Integer clusterLimit, Region region) {
        ClusterWithExtendedInfo retVal = this.clusterDataManager.createWithInfo(cluster, info, createdBy, createEmptyClusterNodesEntry, updateProposedClusterVersion, updateConfigServerClusterVersion, clusterLimit, region);
        String accountId = retVal.getCluster().getAccountId();
        this.cache.put(CacheKey.cluster(retVal.getCluster().getClusterId()), this.serialize(retVal.getCluster()));
        this.cache.invalidate(CacheKey.clusterList(accountId, DeletedVisibility.HIDE));
        this.cache.invalidate(CacheKey.clusterList(accountId, DeletedVisibility.SHOW_ALL));
        this.cache.invalidate(CacheKey.clusterList(accountId, DeletedVisibility.SHOW_RECENT));
        return retVal;
    }

    @Override
    public Cluster update(Cluster cluster, String updatedBy, boolean autoIncrementVersion, boolean mergeWithPrevious) {
        Cluster retVal = this.clusterDataManager.update(cluster, updatedBy, autoIncrementVersion, mergeWithPrevious);
        this.cache.put(CacheKey.cluster(retVal.getClusterId()), this.serialize(retVal));
        this.cache.invalidate(CacheKey.cluster(retVal.getClusterId(), DeletedVisibility.HIDE));
        this.cache.invalidate(CacheKey.cluster(retVal.getClusterId(), DeletedVisibility.SHOW_ALL));
        this.cache.invalidate(CacheKey.cluster(retVal.getClusterId(), DeletedVisibility.SHOW_RECENT));
        return retVal;
    }

    @Override
    public ClusterWithExtendedInfo updateWithInfo(Cluster cluster, Info info, String updatedBy, boolean autoIncrementVersion, boolean mergeWithPrevious, boolean updateDeployedClusterVersion, boolean updateConfigServerClusterVersion, boolean updateProposedClusterVersion) {
        ClusterWithExtendedInfo retVal = this.clusterDataManager.updateWithInfo(cluster, info, updatedBy, autoIncrementVersion, mergeWithPrevious, updateDeployedClusterVersion, updateConfigServerClusterVersion, updateProposedClusterVersion);
        String clusterId = retVal.getCluster().getClusterId();
        this.cache.put(CacheKey.cluster(clusterId), this.serialize(retVal.getCluster()));
        this.cache.invalidate(CacheKey.cluster(clusterId, DeletedVisibility.HIDE));
        this.cache.invalidate(CacheKey.cluster(clusterId, DeletedVisibility.SHOW_ALL));
        this.cache.invalidate(CacheKey.cluster(clusterId, DeletedVisibility.SHOW_RECENT));
        return retVal;
    }

    @Override
    public Cluster get(String clusterId) {
        Cluster retVal = this.deserialize(this.cache.get(CacheKey.cluster(clusterId)));
        if (retVal == null && (retVal = this.clusterDataManager.get(clusterId)) != null) {
            this.cache.put(CacheKey.cluster(retVal.getClusterId()), this.serialize(retVal));
        }
        return retVal;
    }

    @Override
    public Cluster get(String clusterId, DeletedVisibility deletedVisibility) {
        Cluster retVal = this.deserialize(this.cache.get(CacheKey.cluster(clusterId, deletedVisibility)));
        if (retVal == null && (retVal = this.clusterDataManager.get(clusterId, deletedVisibility)) != null) {
            this.cache.put(CacheKey.cluster(retVal.getClusterId(), deletedVisibility), this.serialize(retVal));
        }
        return retVal;
    }

    @Override
    public Cluster getOrNull(String clusterId) {
        Cluster retVal = this.deserialize(this.cache.get(CacheKey.cluster(clusterId)));
        if (retVal == null && (retVal = this.clusterDataManager.getOrNull(clusterId)) != null) {
            this.cache.put(CacheKey.cluster(retVal.getClusterId()), this.serialize(retVal));
        }
        return retVal;
    }

    @Override
    public Cluster getOrNullWithHandle(Handle handle, String clusterId, DeletedVisibility deletedVisibility) {
        Cluster retVal = this.deserialize(this.cache.get(CacheKey.cluster(clusterId)));
        if (retVal == null && (retVal = this.clusterDataManager.getOrNullWithHandle(handle, clusterId, deletedVisibility)) != null) {
            this.cache.put(CacheKey.cluster(retVal.getClusterId()), this.serialize(retVal));
        }
        return retVal;
    }

    @Override
    public Cluster getVersionOrNull(String clusterId, int version) {
        Cluster retVal = this.deserialize(this.cache.get(CacheKey.cluster(clusterId, version)));
        if (retVal == null && (retVal = this.clusterDataManager.getVersionOrNull(clusterId, version)) != null) {
            this.cache.put(CacheKey.cluster(retVal.getClusterId(), version), this.serialize(retVal));
        }
        return retVal;
    }

    @Override
    public List<Cluster> getAllWithAccountId(String accountId) {
        List<Cluster> retVal = this.getCachedClusterList(accountId, DeletedVisibility.HIDE);
        if (retVal == null && (retVal = this.clusterDataManager.getAllWithAccountId(accountId)) != null) {
            this.cacheClusterList(retVal, accountId, DeletedVisibility.HIDE);
        }
        return retVal;
    }

    @Override
    public List<Cluster> getAllWithAccountId(String accountId, DeletedVisibility deletedVisibility) {
        List<Cluster> retVal = this.getCachedClusterList(accountId, deletedVisibility);
        if (retVal == null && (retVal = this.clusterDataManager.getAllWithAccountId(accountId, deletedVisibility)) != null) {
            this.cacheClusterList(retVal, accountId, deletedVisibility);
        }
        return retVal;
    }

    @Override
    public List<Cluster> getAllVersions(String clusterId, DeletedVisibility deletedVisibility) {
        return this.clusterDataManager.getAllVersions(clusterId, deletedVisibility);
    }

    @Override
    public List<Cluster> getVersions(String clusterId, DeletedVisibility deletedVisibility, int limit) {
        return this.clusterDataManager.getVersions(clusterId, deletedVisibility, limit);
    }

    @Override
    public List<Cluster> getAll() {
        return this.getAll(DeletedVisibility.HIDE);
    }

    @Override
    public List<Cluster> getAll(DeletedVisibility deletedVisibility) {
        String cacheName = String.format("%s_%s", "ALL", deletedVisibility.toString());
        List<Cluster> retVal = this.getCachedClusterList(cacheName, deletedVisibility);
        if (retVal == null && (retVal = this.clusterDataManager.getAll(deletedVisibility)) != null) {
            this.cacheClusterList(retVal, cacheName, deletedVisibility);
        }
        return retVal;
    }

    @Override
    public String delete(String clusterId, String deletedBy, boolean deleteClusterNodesEntry) {
        String retVal = this.clusterDataManager.delete(clusterId, deletedBy, deleteClusterNodesEntry);
        this.cache.invalidateAll();
        return retVal;
    }

    @Override
    public boolean isDeleted(String clusterId) {
        return this.clusterDataManager.isDeleted(clusterId);
    }

    private byte[] serialize(Cluster cluster) {
        if (cluster == null) {
            return null;
        }
        try {
            return this.objectMapper.writeValueAsBytes((Object)cluster);
        }
        catch (Exception e) {
            log.info(e, "Cache serialization failed: %s", cluster);
            return null;
        }
    }

    private Cluster deserialize(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return (Cluster)this.objectMapper.readValue(data, Cluster.class);
        }
        catch (Exception e) {
            log.info(e, "Cache deserialization failed");
            return null;
        }
    }

    private void cacheClusterList(List<Cluster> clusters, String accountId, DeletedVisibility deletedVisibility) {
        if (clusters == null || accountId == null) {
            return;
        }
        ArrayList<String> clusterIds = new ArrayList<String>();
        for (Cluster cluster : clusters) {
            try {
                this.cache.put(CacheKey.cluster(cluster.getClusterId(), deletedVisibility), this.objectMapper.writeValueAsBytes((Object)cluster));
                clusterIds.add(cluster.getClusterId());
            }
            catch (Exception e) {
                log.info(e, "Cache serialization failed for clusterId [%s]", cluster.getClusterId());
            }
        }
        try {
            this.cache.put(CacheKey.clusterList(accountId, deletedVisibility), this.objectMapper.writeValueAsBytes(clusterIds));
        }
        catch (Exception e) {
            log.info(e, "Cache serialization failed: %s", clusterIds);
        }
    }

    private List<Cluster> getCachedClusterList(String accountId, DeletedVisibility deletedVisibility) {
        byte[] bClusterList = this.cache.get(CacheKey.clusterList(accountId, deletedVisibility));
        if (bClusterList == null) {
            return null;
        }
        try {
            List clusterIds = (List)this.objectMapper.readValue(bClusterList, (TypeReference)new TypeReference<List<String>>(){});
            ArrayList<Cluster> clusters = new ArrayList<Cluster>();
            for (String clusterId : clusterIds) {
                byte[] bCluster = this.cache.get(CacheKey.cluster(clusterId, deletedVisibility));
                if (bCluster == null) {
                    return null;
                }
                clusters.add((Cluster)this.objectMapper.readValue(bCluster, Cluster.class));
            }
            return clusters;
        }
        catch (Exception e) {
            log.info(e, "Cache deserialization failed");
            return null;
        }
    }
}

