/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.persistence.cache;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.imply.cloud.cache.Cache;
import io.imply.cloud.cache.CacheKey;
import io.imply.cloud.model.Account;
import io.imply.cloud.model.AccountWithExtendedInfo;
import io.imply.cloud.model.Info;
import io.imply.cloud.persistence.AccountDataManager;
import io.imply.cloud.persistence.DeletedVisibility;
import io.imply.cloud.util.Logger;
import java.util.List;

public class CachedAccountDataManager
implements AccountDataManager {
    private static final Logger log = new Logger(CachedAccountDataManager.class);
    private final AccountDataManager accountDataManager;
    private final Cache cache;
    private final ObjectMapper objectMapper;

    public CachedAccountDataManager(AccountDataManager accountDataManager, Cache cache, ObjectMapper objectMapper) {
        this.accountDataManager = accountDataManager;
        this.cache = cache;
        this.objectMapper = objectMapper;
    }

    @Override
    public AccountWithExtendedInfo createWithInfo(Account account, Info info, String createdBy) {
        AccountWithExtendedInfo retVal = this.accountDataManager.createWithInfo(account, info, createdBy);
        this.cache.put(CacheKey.account(retVal.getAccount().getAccountId()), this.serialize(retVal.getAccount()));
        return retVal;
    }

    @Override
    public Account update(Account account, String updatedBy, boolean autoIncrementVersion, boolean mergeWithPrevious) {
        Account retVal = this.accountDataManager.update(account, updatedBy, autoIncrementVersion, mergeWithPrevious);
        this.cache.put(CacheKey.account(retVal.getAccountId()), this.serialize(retVal));
        return retVal;
    }

    @Override
    public Account get(String accountId) {
        Account retVal = this.deserialize(this.cache.get(CacheKey.account(accountId)));
        if (retVal == null && (retVal = this.accountDataManager.get(accountId)) != null) {
            this.cache.put(CacheKey.account(retVal.getAccountId()), this.serialize(retVal));
        }
        return retVal;
    }

    @Override
    public Account getOrNull(String accountId) {
        Account retVal = this.deserialize(this.cache.get(CacheKey.account(accountId)));
        if (retVal == null && (retVal = this.accountDataManager.getOrNull(accountId)) != null) {
            this.cache.put(CacheKey.account(retVal.getAccountId()), this.serialize(retVal));
        }
        return retVal;
    }

    @Override
    public List<Account> getAllVersions(String accountId) {
        return this.accountDataManager.getAllVersions(accountId);
    }

    @Override
    public List<Account> getAll(DeletedVisibility deletedVisibility) {
        return this.accountDataManager.getAll(deletedVisibility);
    }

    @Override
    public boolean exists(String accountId) {
        Account retVal = this.deserialize(this.cache.get(CacheKey.account(accountId)));
        if (retVal == null && (retVal = this.accountDataManager.getOrNull(accountId)) != null) {
            this.cache.put(CacheKey.account(retVal.getAccountId()), this.serialize(retVal));
        }
        return retVal != null;
    }

    @Override
    public String delete(String accountId, String deletedBy) {
        String retVal = this.accountDataManager.delete(accountId, deletedBy);
        this.cache.invalidate(CacheKey.account(accountId));
        return retVal;
    }

    private byte[] serialize(Account account) {
        if (account == null) {
            return null;
        }
        try {
            return this.objectMapper.writeValueAsBytes((Object)account);
        }
        catch (Exception e) {
            log.info(e, "Cache serialization failed: %s", account);
            return null;
        }
    }

    private Account deserialize(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return (Account)this.objectMapper.readValue(data, Account.class);
        }
        catch (Exception e) {
            log.info(e, "Cache deserialization failed");
            return null;
        }
    }
}

