/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.persistence;

import io.imply.cloud.model.EntityType;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.State;
import io.imply.cloud.model.UpdateState;
import io.imply.cloud.model.UpdateType;
import io.imply.cloud.persistence.EntityStateDataManager;
import java.util.List;
import java.util.function.Consumer;
import org.skife.jdbi.v2.Handle;

public class TransformingEntityStateDataManager
implements EntityStateDataManager {
    private final EntityStateDataManager entityStateDataManager;

    public TransformingEntityStateDataManager(EntityStateDataManager entityStateDataManager) {
        this.entityStateDataManager = entityStateDataManager;
    }

    @Override
    public Info insert(String entityKey, String entityId, EntityType entityType, Info entityState, Consumer<Handle> inTxn) {
        return this.entityStateDataManager.insert(entityKey, entityId, entityType, this.setUpdateStateFlags(entityId, entityType, entityState), inTxn);
    }

    @Override
    public Info insertWithHandle(Handle handle, String entityKey, String entityId, EntityType entityType, Info entityState) {
        return this.entityStateDataManager.insertWithHandle(handle, entityKey, entityId, entityType, this.setUpdateStateFlags(entityId, entityType, entityState));
    }

    @Override
    public Info get(String entityId) {
        return this.entityStateDataManager.get(entityId);
    }

    @Override
    public Info getOrNull(String entityId) {
        return this.entityStateDataManager.getOrNull(entityId);
    }

    @Override
    public String delete(String entityId) {
        return this.entityStateDataManager.delete(entityId);
    }

    @Override
    public List<Info> getAllWithType(EntityType entityType) {
        return this.entityStateDataManager.getAllWithType(entityType);
    }

    @Override
    public List<Info> getAllInTransitionStates() {
        return this.entityStateDataManager.getAllInTransitionStates();
    }

    private Info setUpdateStateFlags(String entityId, EntityType entityType, Info entityState) {
        if (entityState != null && entityState.getState() != null && !EntityType.ACCOUNT.equals((Object)entityType)) {
            Info existingInfo = this.entityStateDataManager.getOrNull(entityId);
            Info mergedInfo = existingInfo != null ? ((Info.Builder)existingInfo.cloner().withInfo(entityState, true)).build() : entityState;
            UpdateState.Builder updateStateBuilder = UpdateState.builder(mergedInfo.getUpdateState()).waitingForRetryOrRollback(State.CLUSTER_UPDATE_FAILED_PROMPT_USER.equals((Object)mergedInfo.getState())).cancelAllowed(State.CLUSTER_CANCEL_UPDATE_WITH_ROLLBACK_REQUEST_RECEIVED.getValidPreviousStates().contains((Object)mergedInfo.getState()) && !State.CLUSTER_UPDATE_ROLLED_BACK.equals((Object)mergedInfo.getDesiredState())).performingRollback(State.CLUSTER_UPDATE_ROLLED_BACK.equals((Object)mergedInfo.getDesiredState()) && !State.CLUSTER_UPDATE_ROLLED_BACK.equals((Object)mergedInfo.getState())).switchToHardUpdateAllowed(State.CLUSTER_ROLLING_UPDATE_IN_PROGRESS.equals((Object)mergedInfo.getState()) && UpdateType.ROLLING.equals((Object)mergedInfo.getUpdateType()) && mergedInfo.getUpdateState() != null && mergedInfo.getUpdateState().getSupportedTypes() != null && mergedInfo.getUpdateState().getSupportedTypes().contains((Object)UpdateType.HARD));
            switch (entityState.getState()) {
                case CLUSTER_UPDATE_REQUEST_RECEIVED: 
                case CLUSTER_RESTART_REQUEST_RECEIVED: {
                    updateStateBuilder.phase(UpdateState.UpdatePhase.PENDING);
                    break;
                }
                case CREATING_RDS_SNAPSHOT: {
                    updateStateBuilder.phase(UpdateState.UpdatePhase.CREATING_SNAPSHOT);
                    break;
                }
                case UPDATING_CLUSTER_STACK: {
                    updateStateBuilder.phase(UpdateState.UpdatePhase.UPDATING_CF_STACK);
                    break;
                }
                case CLUSTER_ROLLING_UPDATE_IN_PROGRESS: {
                    updateStateBuilder.phase(UpdateState.UpdatePhase.UPDATING_CLUSTER);
                    break;
                }
                case CLUSTER_ROLLING_UPDATE_COMPLETE: {
                    updateStateBuilder.phase(UpdateState.UpdatePhase.NOT_SET);
                }
            }
            return ((Info.Builder)entityState.cloner().withUpdateState(updateStateBuilder.build())).build();
        }
        return entityState;
    }
}

