/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.persistence;

import io.imply.cloud.config.SecurityConfig;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ClusterWithExtendedInfo;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.Region;
import io.imply.cloud.model.SecurityConfiguration;
import io.imply.cloud.persistence.ClusterDataManager;
import io.imply.cloud.persistence.DeletedVisibility;
import io.imply.cloud.security.DruidAuthManager;
import io.imply.cloud.util.DiffResultHelper;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.builder.DiffResult;
import org.skife.jdbi.v2.Handle;

public class TransformingClusterDataManager
implements ClusterDataManager {
    private final ClusterDataManager clusterDataManager;
    private final SecurityConfig securityConfig;
    private final DruidAuthManager druidAuthManager;

    public TransformingClusterDataManager(ClusterDataManager clusterDataManager, SecurityConfig securityConfig, DruidAuthManager druidAuthManager) {
        this.clusterDataManager = clusterDataManager;
        this.securityConfig = securityConfig;
        this.druidAuthManager = druidAuthManager;
    }

    @Override
    public ClusterWithExtendedInfo createWithInfo(Cluster cluster, Info info, String createdBy, boolean createEmptyClusterNodesEntry, boolean updateProposedClusterVersion, boolean updateConfigServerClusterVersion, Integer clusterLimit, Region region) {
        return this.clusterDataManager.createWithInfo(this.maybeGenerateSecurityConfiguration(this.maybeSetClusterId(cluster), false, true), info, createdBy, createEmptyClusterNodesEntry, updateProposedClusterVersion, updateConfigServerClusterVersion, clusterLimit, region);
    }

    @Override
    public Cluster update(Cluster cluster, String updatedBy, boolean autoIncrementVersion, boolean mergeWithPrevious) {
        boolean forceGenerateMissingSecurityFields = "SYSTEM_SECURITY".equals(updatedBy);
        Cluster updatedCluster = this.clusterDataManager.update(this.maybeGenerateSecurityConfiguration(cluster, mergeWithPrevious, forceGenerateMissingSecurityFields), updatedBy, autoIncrementVersion, mergeWithPrevious);
        this.druidAuthManager.clear(updatedCluster.getClusterId());
        return updatedCluster;
    }

    @Override
    public ClusterWithExtendedInfo updateWithInfo(Cluster cluster, Info info, String updatedBy, boolean autoIncrementVersion, boolean mergeWithPrevious, boolean updateDeployedClusterVersion, boolean updateConfigServerClusterVersion, boolean updateProposedClusterVersion) {
        boolean forceGenerateMissingSecurityFields = "SYSTEM_SECURITY".equals(updatedBy);
        ClusterWithExtendedInfo updatedCluster = this.clusterDataManager.updateWithInfo(this.maybeGenerateSecurityConfiguration(cluster, mergeWithPrevious, forceGenerateMissingSecurityFields), info, updatedBy, autoIncrementVersion, mergeWithPrevious, updateDeployedClusterVersion, updateConfigServerClusterVersion, updateProposedClusterVersion);
        this.druidAuthManager.clear(cluster.getClusterId());
        return updatedCluster;
    }

    @Override
    public Cluster get(String clusterId) {
        return this.clusterDataManager.get(clusterId);
    }

    @Override
    public Cluster get(String clusterId, DeletedVisibility deletedVisibility) {
        return this.clusterDataManager.get(clusterId, deletedVisibility);
    }

    @Override
    public Cluster getOrNull(String clusterId) {
        return this.clusterDataManager.getOrNull(clusterId);
    }

    @Override
    public Cluster getOrNullWithHandle(Handle handle, String clusterId, DeletedVisibility deletedVisibility) {
        return this.clusterDataManager.getOrNullWithHandle(handle, clusterId, deletedVisibility);
    }

    @Override
    public Cluster getVersionOrNull(String clusterId, int version) {
        return this.clusterDataManager.getVersionOrNull(clusterId, version);
    }

    @Override
    public List<Cluster> getAllWithAccountId(String accountId) {
        return this.clusterDataManager.getAllWithAccountId(accountId);
    }

    @Override
    public List<Cluster> getAllWithAccountId(String accountId, DeletedVisibility deletedVisibility) {
        return this.clusterDataManager.getAllWithAccountId(accountId, deletedVisibility);
    }

    @Override
    public List<Cluster> getAllVersions(String clusterId, DeletedVisibility deletedVisibility) {
        return this.clusterDataManager.getAllVersions(clusterId, deletedVisibility);
    }

    @Override
    public List<Cluster> getVersions(String clusterId, DeletedVisibility deletedVisibility, int limit) {
        return this.clusterDataManager.getVersions(clusterId, deletedVisibility, limit);
    }

    @Override
    public List<Cluster> getAll() {
        return this.clusterDataManager.getAll();
    }

    @Override
    public List<Cluster> getAll(DeletedVisibility deletedVisibility) {
        return this.clusterDataManager.getAll(deletedVisibility);
    }

    @Override
    public String delete(String clusterId, String deletedBy, boolean deleteClusterNodesEntry) {
        return this.clusterDataManager.delete(clusterId, deletedBy, deleteClusterNodesEntry);
    }

    @Override
    public boolean isDeleted(String clusterId) {
        return this.clusterDataManager.isDeleted(clusterId);
    }

    private Cluster maybeSetClusterId(Cluster cluster) {
        return cluster.getClusterId() != null ? cluster : ((Cluster.Builder)cluster.cloner().withClusterId(this.generateUUID())).build();
    }

    private Cluster maybeGenerateSecurityConfiguration(Cluster cluster, boolean mergeWithPrevious, boolean forceGenerateMissingFields) {
        DiffResult<Cluster> diffs;
        if (cluster == null) {
            return null;
        }
        Cluster previousCluster = this.clusterDataManager.getOrNull(cluster.getClusterId());
        if (!forceGenerateMissingFields && previousCluster != null && !DiffResultHelper.contains(diffs = previousCluster.diff(cluster), "implyVersionFull")) {
            return cluster;
        }
        Object mergedCluster = mergeWithPrevious ? (previousCluster != null ? ((Cluster.Builder)previousCluster.cloner().withCluster(cluster, true)).build() : cluster) : cluster;
        if (((Cluster)mergedCluster).getSecurityConfiguration() != null && ((Cluster)mergedCluster).getSecurityConfiguration().isComplete()) {
            return cluster;
        }
        SecurityConfiguration.Builder builder = ((Cluster)mergedCluster).getSecurityConfiguration() == null ? SecurityConfiguration.builder() : ((Cluster)mergedCluster).getSecurityConfiguration().cloner();
        return ((Cluster.Builder)cluster.cloner().withSecurityConfiguration((SecurityConfiguration)((SecurityConfiguration.Builder)builder.withMissingKeysGenerated(((Cluster)mergedCluster).getClusterId(), this.securityConfig)).build())).build();
    }

    private String generateUUID() {
        return UUID.randomUUID().toString();
    }
}

