/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.persistence;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import io.imply.cloud.persistence.DeletedVisibility;
import io.imply.cloud.persistence.SQLBaseDataManager;
import io.imply.cloud.persistence.SQLStorageConnector;
import io.imply.cloud.util.NRE;
import java.io.IOException;
import java.util.List;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.exceptions.DBIException;
import org.skife.jdbi.v2.exceptions.NoResultsException;
import org.skife.jdbi.v2.tweak.ResultColumnMapper;
import org.skife.jdbi.v2.util.IntegerColumnMapper;

public abstract class SQLUpdatingDataManager<T>
extends SQLBaseDataManager<T> {
    protected SQLUpdatingDataManager(ObjectMapper jsonMapper, SQLStorageConnector connector) {
        super(jsonMapper, connector);
    }

    @Override
    protected boolean existsWithHandle(Handle handle, String key, DeletedVisibility deletedVisibility) {
        if (!DeletedVisibility.HIDE.equals((Object)deletedVisibility)) {
            throw new IllegalStateException("Only DeletedVisibility.HIDE is supported by this implementation");
        }
        if (key == null) {
            return false;
        }
        int count = (Integer)((Query)handle.createQuery(String.format("SELECT COUNT(*) FROM %1$s WHERE %2$s = :key", this.getTableName(), this.getMainKeyColumnName())).bind("key", key)).map((ResultColumnMapper)IntegerColumnMapper.PRIMITIVE).first();
        return count != 0;
    }

    @Override
    protected T getWithHandle(Handle handle, String key, DeletedVisibility deletedVisibility) {
        if (!DeletedVisibility.HIDE.equals((Object)deletedVisibility)) {
            throw new IllegalStateException("Only DeletedVisibility.HIDE is supported by this implementation");
        }
        Object retVal = ((Query)handle.createQuery(String.format("SELECT payload FROM %1$s WHERE %2$s=:key", this.getTableName(), this.getMainKeyColumnName())).bind("key", key)).map((index, r, ctx) -> {
            try {
                Object payload = this.jsonMapper.readValue(r.getBytes("payload"), this.getJavaType());
                return payload;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).first();
        if (retVal == null) {
            throw new NRE(this.getJavaType().getRawClass(), key);
        }
        return (T)retVal;
    }

    @Override
    protected List<T> getAllVersionsWithHandle(Handle handle, String key, DeletedVisibility deletedVisibility, int limit) {
        if (!DeletedVisibility.HIDE.equals((Object)deletedVisibility)) {
            throw new IllegalStateException("Only DeletedVisibility.HIDE is supported by this implementation");
        }
        return ImmutableList.of(this.getWithHandle(handle, key, deletedVisibility));
    }

    @Override
    protected List<T> getAllWithHandle(Handle handle, DeletedVisibility deletedVisibility) {
        if (!DeletedVisibility.HIDE.equals((Object)deletedVisibility)) {
            throw new IllegalStateException("Only DeletedVisibility.HIDE is supported by this implementation");
        }
        List retVal = handle.createQuery(String.format("SELECT payload FROM %1$s", this.getTableName())).map((index, r, ctx) -> {
            try {
                Object payload = this.jsonMapper.readValue(r.getBytes("payload"), this.getJavaType());
                return payload;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).list();
        if (retVal == null) {
            return ImmutableList.of();
        }
        return retVal;
    }

    public String delete(String key) {
        return (String)this.dbi.inTransaction((handle, transactionStatus) -> {
            if (!this.existsWithHandle(handle, key, DeletedVisibility.HIDE)) {
                throw new NRE(this.getJavaType().getRawClass(), key);
            }
            ((Update)handle.createStatement(String.format("DELETE FROM %1$s WHERE %2$s=:key", this.getTableName(), this.getMainKeyColumnName())).bind("key", key)).execute();
            return key;
        });
    }

    public boolean deleteQuietly(String key) {
        if (key == null) {
            return false;
        }
        try {
            this.delete(key);
            return true;
        }
        catch (DBIException e) {
            if (e instanceof NoResultsException || e.getCause() instanceof NoResultsException) {
                return false;
            }
            throw e;
        }
    }
}

