/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.persistence;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Enums;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.imply.cloud.guice.annotations.ManageLifecycle;
import io.imply.cloud.lifecycle.LifecycleStart;
import io.imply.cloud.model.Notification;
import io.imply.cloud.model.Notifications;
import io.imply.cloud.persistence.DeletedVisibility;
import io.imply.cloud.persistence.NotificationDataManager;
import io.imply.cloud.persistence.SQLStorageConnector;
import io.imply.cloud.persistence.SQLUpdatingDataManager;
import io.imply.cloud.persistence.StorageTablesConfig;
import java.sql.Timestamp;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.tweak.ResultColumnMapper;
import org.skife.jdbi.v2.util.IntegerColumnMapper;

@ManageLifecycle
public class SQLNotificationDataManager
extends SQLUpdatingDataManager<Notification>
implements NotificationDataManager {
    private final String tableName;
    private final JavaType javaType;

    @Inject
    public SQLNotificationDataManager(ObjectMapper jsonMapper, SQLStorageConnector connector, Supplier<StorageTablesConfig> dbTables) {
        super(jsonMapper, connector);
        this.tableName = ((StorageTablesConfig)dbTables.get()).getNotificationsTable();
        this.javaType = jsonMapper.getTypeFactory().constructType(Notification.class);
    }

    @Override
    public Notification insert(Notification notification) {
        return (Notification)this.dbi.withHandle(handle -> this.insertWithHandle(handle, notification));
    }

    @Override
    protected String getTableName() {
        return this.tableName;
    }

    @Override
    protected String getMainKeyColumnName() {
        return "key_name";
    }

    @Override
    protected JavaType getJavaType() {
        return this.javaType;
    }

    @Override
    @LifecycleStart
    public void start() {
        super.start();
        this.conditionallyUpdateTable();
    }

    private void conditionallyUpdateTable() {
        this.dbi.withHandle(handle -> {
            boolean needsUpdate;
            String colName = "detailed_message";
            boolean bl = needsUpdate = (Integer)((Query)((Query)handle.createQuery("SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS WHERE LOWER(TABLE_NAME)=LOWER(:tableName) AND COLUMN_NAME=:colName").bind("tableName", this.getTableName())).bind("colName", "detailed_message")).map((ResultColumnMapper)IntegerColumnMapper.PRIMITIVE).first() == 0;
            if (needsUpdate) {
                handle.createStatement(String.format("ALTER TABLE %1$s ADD COLUMN %2$s VARCHAR(8000);", this.getTableName(), "detailed_message")).execute();
            }
            return null;
        });
    }

    @Override
    protected void createTable() {
        this.connector.createTable(this.getTableName(), (Iterable<String>)ImmutableList.of((Object)String.format("CREATE TABLE %1$s (%n  %2$s VARCHAR(32) NOT NULL,%n  entity_key VARCHAR(100),%n  level VARCHAR(15),%n  source VARCHAR(15),%n  timestamp TIMESTAMP(3) DEFAULT CURRENT_TIMESTAMP(3),%n  relevance VARCHAR(15),%n  message VARCHAR(4096),%n  detailed_message VARCHAR(8000),%n  PRIMARY KEY (%2$s)%n);", this.getTableName(), this.getMainKeyColumnName()), (Object)String.format("CREATE INDEX idx_%1$s_entity_key ON %1$s(entity_key)", this.getTableName()), (Object)String.format("CREATE INDEX idx_%1$s_level ON %1$s(level)", this.getTableName()), (Object)String.format("CREATE INDEX idx_%1$s_source ON %1$s(source)", this.getTableName())));
    }

    private Notification insertWithHandle(Handle handle, Notification notification) {
        handle.inTransaction((myHandle, transactionStatus) -> {
            String statement = String.format(!this.existsWithHandle(myHandle, notification.getKey(), DeletedVisibility.HIDE) ? "INSERT INTO %1$s (%2$s, entity_key, level, source, timestamp, relevance, message, detailed_message) VALUES (:keyName, :entityKey, :level, :source, :timestamp, :relevance, :message, :detailedMessage)" : "UPDATE %1$s SET entity_key=:entityKey,level=:level,source=:source,timestamp=:timestamp,relevance=:relevance,message=:message,detailed_message=:detailedMessage WHERE %2$s=:keyName", this.getTableName(), this.getMainKeyColumnName());
            String message = notification.getMessage() == null || notification.getMessage().length() <= 4096 ? notification.getMessage() : notification.getMessage().substring(0, 4096);
            ((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)myHandle.createStatement(statement).bind("keyName", notification.getKey())).bind("entityKey", notification.getEntityKey())).bind("level", (Object)notification.getLevel())).bind("source", (Object)notification.getSource())).bind("timestamp", notification.getTimestamp() != null ? new Timestamp(notification.getTimestamp().toDateTime(DateTimeZone.UTC).getMillis()) : null)).bind("relevance", (Object)notification.getRelevance())).bind("message", message)).bind("detailedMessage", notification.getDetailedMessage())).execute();
            return null;
        });
        return notification;
    }

    @Override
    public Notifications getAllWithEntityKey(String entityKey) {
        List notifications = (List)this.dbi.withHandle(handle -> ((Query)handle.createQuery(String.format("SELECT * FROM %1$s WHERE entity_key=:entityKey ORDER BY timestamp DESC", this.getTableName())).bind("entityKey", entityKey)).map((index, r, ctx) -> Notification.of(r.getString("message"), r.getString("detailed_message"), (Notification.Level)((Object)((Object)((Object)Enums.getIfPresent(Notification.Level.class, (String)r.getString("level")).or((Object)Notification.Level.UNKNOWN)))), new DateTime((Object)r.getTimestamp("timestamp")), (Notification.Source)((Object)((Object)((Object)Enums.getIfPresent(Notification.Source.class, (String)r.getString("source")).or((Object)Notification.Source.UNKNOWN)))), (Notification.Relevance)((Object)((Object)((Object)Enums.getIfPresent(Notification.Relevance.class, (String)r.getString("relevance")).or((Object)Notification.Relevance.UNKNOWN)))), r.getString("entity_key"))).list());
        return new Notifications(entityKey, notifications);
    }

    @Override
    public void markNotificationsAsPrevious(String entityKey) {
        this.dbi.withHandle(handle -> ((Update)((Update)handle.createStatement(String.format("UPDATE %1$s SET relevance=:relevance WHERE entity_key=:entityKey", this.getTableName())).bind("relevance", (Object)Notification.Relevance.PREVIOUS)).bind("entityKey", entityKey)).execute());
    }

    @Override
    public void deleteNotificationsWithLevel(String entityKey, Notification.Level level) {
        this.dbi.withHandle(handle -> ((Update)((Update)handle.createStatement(String.format("DELETE FROM %1$s WHERE entity_key=:entityKey AND level=:level", this.getTableName())).bind("entityKey", entityKey)).bind("level", (Object)level)).execute());
    }

    @Override
    public void deleteNotificationsWithEntityKey(String entityKey) {
        this.dbi.withHandle(handle -> ((Update)handle.createStatement(String.format("DELETE FROM %1$s WHERE entity_key=:entityKey", this.getTableName())).bind("entityKey", entityKey)).execute());
    }

    @Override
    public void delete(Notification notification) {
        this.dbi.withHandle(handle -> ((Update)handle.createStatement(String.format("DELETE FROM %1$s WHERE key_name=:keyName", this.getTableName())).bind("keyName", notification.getKey())).execute());
    }
}

