/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.persistence;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.imply.cloud.guice.annotations.ManageLifecycle;
import io.imply.cloud.model.EntityType;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.State;
import io.imply.cloud.persistence.DeletedVisibility;
import io.imply.cloud.persistence.EntityStateDataManager;
import io.imply.cloud.persistence.SQLStorageConnector;
import io.imply.cloud.persistence.SQLUpdatingDataManager;
import io.imply.cloud.persistence.StorageTablesConfig;
import io.imply.cloud.util.IAE;
import io.imply.cloud.util.Logger;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.Update;

@ManageLifecycle
public class SQLEntityStateDataManager
extends SQLUpdatingDataManager<Info>
implements EntityStateDataManager {
    private static final Logger log = new Logger(SQLEntityStateDataManager.class);
    private final String tableName;
    private final JavaType javaType;

    @Inject
    public SQLEntityStateDataManager(ObjectMapper jsonMapper, SQLStorageConnector connector, Supplier<StorageTablesConfig> dbTables) {
        super(jsonMapper, connector);
        this.tableName = ((StorageTablesConfig)dbTables.get()).getStateTable();
        this.javaType = jsonMapper.getTypeFactory().constructType(Info.class);
    }

    @Override
    public Info insert(String entityKey, String entityId, EntityType entityType, Info entityState, Consumer<Handle> inTxn) {
        return (Info)this.dbi.inTransaction((handle, transactionStatus) -> {
            if (inTxn != null) {
                inTxn.accept(handle);
            }
            return this.insertWithHandle(handle, entityKey, entityId, entityType, entityState);
        });
    }

    @Override
    public List<Info> getAllWithType(EntityType entityType) {
        return (List)this.dbi.withHandle(handle -> this.getAllWithTypeWithHandle(handle, entityType));
    }

    public List<Info> getAllWithTypeWithHandle(Handle handle, EntityType entityType) {
        Query query = entityType != null ? (Query)handle.createQuery(String.format("SELECT payload FROM %1$s WHERE entity_type=:entityType", this.getTableName())).bind("entityType", (Object)entityType) : handle.createQuery(String.format("SELECT payload FROM %1$s", this.getTableName()));
        return query.map((index, r, ctx) -> {
            try {
                Info payload = (Info)this.jsonMapper.readValue(r.getBytes("payload"), this.getJavaType());
                return payload;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).list();
    }

    @Override
    public List<Info> getAllInTransitionStates() {
        return (List)this.dbi.withHandle(handle -> {
            String query = String.format("SELECT payload FROM %1$s WHERE is_final_state=false", this.getTableName());
            return handle.createQuery(query).map((index, r, ctx) -> {
                try {
                    Info payload = (Info)this.jsonMapper.readValue(r.getBytes("payload"), this.getJavaType());
                    return payload;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }).list();
        });
    }

    @Override
    protected String getTableName() {
        return this.tableName;
    }

    @Override
    protected String getMainKeyColumnName() {
        return "entity_id";
    }

    @Override
    protected JavaType getJavaType() {
        return this.javaType;
    }

    @Override
    protected void createTable() {
        this.connector.createTable(this.getTableName(), (Iterable<String>)ImmutableList.of((Object)String.format("CREATE TABLE %1$s (%n  %2$s VARCHAR(100) NOT NULL,%n  entity_type VARCHAR(50) NOT NULL,%n  desired_state VARCHAR(100),%n  actual_state VARCHAR(100),%n  last_modified TIMESTAMP DEFAULT CURRENT_TIMESTAMP,%n  payload %3$s NOT NULL,%n  is_final_state BOOLEAN,%n  PRIMARY KEY (%2$s)%n);", this.getTableName(), this.getMainKeyColumnName(), this.connector.getPayloadType()), (Object)String.format("CREATE INDEX idx_%1$s_is_final_state ON %1$s(is_final_state)", this.getTableName())));
    }

    @Override
    public Info insertWithHandle(Handle handle, String entityKey, String entityId, EntityType entityType, Info entityState) {
        Info myEntityState;
        Info previousInfo = null;
        if (this.existsWithHandle(handle, entityId, DeletedVisibility.HIDE)) {
            previousInfo = (Info)this.getWithHandle(handle, entityId, DeletedVisibility.HIDE);
            if (previousInfo.getState() != null && entityState.getState() != null && !previousInfo.getState().equals((Object)entityState.getState())) {
                if (!entityState.getState().getValidPreviousStates().contains((Object)previousInfo.getState())) {
                    if (entityState.getState().isUserInitiated()) {
                        throw new IAE("Invalid state change: [%s] cannot transition from [%s] -> [%s] (valid: %s)", new Object[]{entityId, previousInfo.getState(), entityState.getState(), entityState.getState().getValidPreviousStates()});
                    }
                    log.warn("Unexpected state change: [%s] transitioned from [%s] -> [%s] (valid: %s)", new Object[]{entityId, previousInfo.getState(), entityState.getState(), entityState.getState().getValidPreviousStates()});
                } else {
                    log.info("State change [%s] -> [%s] for entityId [%s]", new Object[]{previousInfo.getState(), entityState.getState(), entityId});
                }
                entityState = ((Info.Builder)entityState.cloner().withLastStateChange(DateTime.now())).build();
            }
            myEntityState = ((Info.Builder)previousInfo.cloner().withInfo(entityState, true)).build();
        } else {
            myEntityState = entityState;
        }
        List<State> transitionStateChain = this.getTransitionStateChainFromPreviousAndCurrentEntityState(previousInfo, myEntityState);
        if (!transitionStateChain.isEmpty()) {
            log.debug("state transition chain for entityId [%s] is [%s]", entityId, transitionStateChain);
        }
        Preconditions.checkArgument((myEntityState.getKey() == null || myEntityState.getKey().equals(entityKey) ? 1 : 0) != 0, (Object)"key mismatch");
        Preconditions.checkArgument((myEntityState.getEntityId() == null || myEntityState.getEntityId().equals(entityId) ? 1 : 0) != 0, (Object)"entityId mismatch");
        Preconditions.checkArgument((myEntityState.getEntityType() == null || myEntityState.getEntityType().equals((Object)entityType) ? 1 : 0) != 0, (Object)"entityType mismatch");
        Object entityStateToInsert = ((Info.Builder)((Info.Builder)((Info.Builder)((Info.Builder)((Info.Builder)((Info.Builder)myEntityState.cloner().withKey(entityKey)).withEntityId(entityId)).withEntityType(entityType)).withLastModified(DateTime.now())).withTransitionStateChain(transitionStateChain)).removeClearedFields()).build();
        if (handle.isInTransaction()) {
            this.insertWithHandleInternal(handle, (Info)entityStateToInsert);
        } else {
            handle.useTransaction((myHandle, transactionStatus) -> this.insertWithHandleInternal(myHandle, (Info)entityStateToInsert));
        }
        return entityStateToInsert;
    }

    @VisibleForTesting
    List<State> getTransitionStateChainFromPreviousAndCurrentEntityState(Info previousEntityState, Info currentEntityState) {
        ArrayList<State> transitionStateChain = new ArrayList<State>();
        if (currentEntityState == null) {
            return new ArrayList<State>();
        }
        if (previousEntityState != null) {
            if (currentEntityState.getState() == previousEntityState.getState() && previousEntityState.getState().isFinalState()) {
                return new ArrayList<State>();
            }
            if (previousEntityState.getTransitionStateChain() != null && !previousEntityState.getTransitionStateChain().isEmpty() && !previousEntityState.getState().isFinalState()) {
                transitionStateChain.addAll(previousEntityState.getTransitionStateChain());
            }
        }
        if (transitionStateChain.isEmpty() || transitionStateChain.get(transitionStateChain.size() - 1) != currentEntityState.getState()) {
            transitionStateChain.add(currentEntityState.getState());
        }
        return transitionStateChain;
    }

    private void insertWithHandleInternal(Handle handle, Info entityState) {
        byte[] payload;
        String statement = String.format(!this.existsWithHandle(handle, entityState.getEntityId(), DeletedVisibility.HIDE) ? "INSERT INTO %1$s (entity_id, entity_type, desired_state, actual_state, last_modified, payload, is_final_state) VALUES (:entityId, :entityType, :desiredState, :actualState, :lastModified, :payload, :isFinalState)" : "UPDATE %1$s SET entity_id=:entityId,entity_type=:entityType,desired_state=:desiredState,actual_state=:actualState,last_modified=:lastModified,payload=:payload,is_final_state=:isFinalState WHERE %2$s=:entityId", this.getTableName(), this.getMainKeyColumnName());
        try {
            payload = this.jsonMapper.writeValueAsBytes((Object)entityState);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        ((Update)((Update)((Update)((Update)((Update)((Update)((Update)handle.createStatement(statement).bind("entityId", entityState.getEntityId())).bind("entityType", (Object)entityState.getEntityType())).bind("desiredState", entityState.getDesiredState() == null ? null : entityState.getDesiredState().name())).bind("actualState", entityState.getState() == null ? null : entityState.getState().name())).bind("lastModified", entityState.getLastModified() != null ? new Timestamp(entityState.getLastModified().toDateTime(DateTimeZone.UTC).getMillis()) : null)).bind("payload", payload)).bind("isFinalState", entityState.getState() != null && entityState.getState().isFinalState())).execute();
    }
}

