/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.persistence;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.imply.cloud.guice.annotations.ManageLifecycle;
import io.imply.cloud.model.ClusterNodes;
import io.imply.cloud.model.Info;
import io.imply.cloud.persistence.ClusterNodesDataManager;
import io.imply.cloud.persistence.DeletedVisibility;
import io.imply.cloud.persistence.EntityStateDataManager;
import io.imply.cloud.persistence.SQLAppendingDataManager;
import io.imply.cloud.persistence.SQLStorageConnector;
import io.imply.cloud.persistence.StorageTablesConfig;
import io.imply.cloud.util.IAE;
import java.sql.Timestamp;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Update;

@ManageLifecycle
public class SQLClusterNodesDataManager
extends SQLAppendingDataManager<ClusterNodes>
implements ClusterNodesDataManager {
    private final String clusterNodesTableName;
    private final JavaType javaType;
    private final EntityStateDataManager entityStateDataManager;

    @Inject
    public SQLClusterNodesDataManager(ObjectMapper jsonMapper, SQLStorageConnector connector, Supplier<StorageTablesConfig> dbTables, EntityStateDataManager entityStateDataManager) {
        super(jsonMapper, connector);
        this.clusterNodesTableName = ((StorageTablesConfig)dbTables.get()).getClusterNodesTable();
        this.javaType = jsonMapper.getTypeFactory().constructType(ClusterNodes.class);
        this.entityStateDataManager = entityStateDataManager;
    }

    @Override
    public ClusterNodes insert(ClusterNodes clusterNodes, String insertedBy, boolean autoIncrementVersion, boolean mergeWithPrevious) {
        return (ClusterNodes)this.dbi.withHandle(handle -> this.insertWithHandle(handle, clusterNodes, insertedBy, autoIncrementVersion, mergeWithPrevious));
    }

    @Override
    public ClusterNodes insertWithInfo(ClusterNodes clusterNodes, Info info, String insertedBy, boolean autoIncrementVersion, boolean updateDeployedClusterNodesVersion, boolean mergeWithPrevious) {
        return (ClusterNodes)this.dbi.inTransaction((handle, transactionStatus) -> {
            ClusterNodes insertedClusterNodes = this.insertWithHandle(handle, clusterNodes, insertedBy, autoIncrementVersion, mergeWithPrevious);
            Info.Builder infoToInsert = info.cloner();
            if (updateDeployedClusterNodesVersion) {
                ((Info.Builder)infoToInsert.withDeployedClusterNodesVersion(insertedClusterNodes.getVersion())).withProposedClusterNodesVersion(insertedClusterNodes.getVersion());
            }
            this.entityStateDataManager.insertWithHandle(handle, info.getKey(), info.getEntityId(), info.getEntityType(), (Info)infoToInsert.build());
            return insertedClusterNodes;
        });
    }

    @Override
    public ClusterNodes getVersionOrNull(String clusterId, int version) {
        return this.getAllVersions(clusterId).stream().filter(x -> x.getVersion().equals(version)).findFirst().orElse(null);
    }

    @Override
    public String delete(String clusterId, String deletedBy) {
        return (String)this.dbi.withHandle(handle -> this.deleteWithHandle(handle, clusterId, deletedBy));
    }

    @Override
    public String deleteWithHandle(Handle handle, String clusterId, String deletedBy) {
        try {
            this.insertWithHandle(handle, new ClusterNodes(clusterId, null, null, null, null), deletedBy, true, false);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        ((Update)((Update)handle.createStatement(String.format("UPDATE %1$s SET used=:used WHERE %2$s=:key", this.getTableName(), this.getMainKeyColumnName())).bind("used", false)).bind("key", clusterId)).execute();
        return clusterId;
    }

    @Override
    protected String getTableName() {
        return this.clusterNodesTableName;
    }

    @Override
    protected String getMainKeyColumnName() {
        return "cluster_id";
    }

    @Override
    protected JavaType getJavaType() {
        return this.javaType;
    }

    @Override
    protected void createTable() {
        this.connector.createTable(this.getTableName(), (Iterable<String>)ImmutableList.of((Object)String.format("CREATE TABLE %1$s (%n  %2$s VARCHAR(100) NOT NULL,%n  version INT NOT NULL,%n  inserted_by VARCHAR(100),%n  last_modified TIMESTAMP DEFAULT CURRENT_TIMESTAMP,%n  payload %3$s NOT NULL,%n  used BOOLEAN NOT NULL,%n  cluster_id_version_sha1 VARCHAR(100) NOT NULL,%n  PRIMARY KEY (cluster_id_version_sha1)%n);", this.getTableName(), this.getMainKeyColumnName(), this.connector.getPayloadType()), (Object)String.format("CREATE INDEX idx_%1$s_%2$s ON %1$s(%2$s)", this.getTableName(), this.getMainKeyColumnName())));
        this.connector.createIndex(this.getTableName(), String.format("idx_%1$s_%2$s_used_version", this.getTableName(), this.getMainKeyColumnName()), (List<String>)ImmutableList.of((Object)this.getMainKeyColumnName(), (Object)"used", (Object)"version"));
    }

    private ClusterNodes insertWithHandle(Handle handle, ClusterNodes clusterNodes, String insertedBy, boolean autoIncrementVersion, boolean mergeWithPrevious) throws JsonProcessingException {
        Object clusterNodesToInsert;
        String clusterId = (String)Preconditions.checkNotNull((Object)clusterNodes.getClusterId());
        if (this.existsWithHandle(handle, clusterId, DeletedVisibility.SHOW_ALL)) {
            ClusterNodes previousClusterNodes = (ClusterNodes)this.getWithHandle(handle, clusterId, DeletedVisibility.SHOW_ALL);
            int expectedVersion = previousClusterNodes.getVersion() + 1;
            ClusterNodes.Builder clusterNodesBuilder = mergeWithPrevious ? previousClusterNodes.cloner().withClusterNodes(clusterNodes, true) : clusterNodes.cloner();
            Object TypeToBuild = clusterNodesToInsert = autoIncrementVersion ? ((ClusterNodes.Builder)clusterNodesBuilder.withVersion(expectedVersion)).build() : clusterNodesBuilder.build();
            if (((ClusterNodes)clusterNodesToInsert).getVersion() != expectedVersion) {
                throw new IAE("ClusterNodes update failed for cluster [%s]: received version [%d], expecting version [%d]", clusterId, ((ClusterNodes)clusterNodesToInsert).getVersion(), expectedVersion);
            }
        } else {
            clusterNodesToInsert = ((ClusterNodes.Builder)clusterNodes.cloner().withVersion(0)).build();
        }
        clusterNodesToInsert = ((ClusterNodes.Builder)((ClusterNodes.Builder)((ClusterNodes)clusterNodesToInsert).cloner().withLastModified(DateTime.now())).withModifiedBy(insertedBy)).build();
        String clusterIdVersionSha1 = DigestUtils.sha1Hex((String)(clusterId + String.valueOf(Preconditions.checkNotNull((Object)((ClusterNodes)clusterNodesToInsert).getVersion()))));
        ((Update)((Update)((Update)((Update)((Update)((Update)((Update)handle.createStatement(String.format("INSERT INTO %1$s (%2$s, version, inserted_by, last_modified, payload, used, cluster_id_version_sha1) VALUES (:clusterId, :version, :insertedBy, :lastModified, :payload, :used, :clusterIdVersionSha1)", this.getTableName(), this.getMainKeyColumnName())).bind("clusterId", clusterId)).bind("version", ((ClusterNodes)clusterNodesToInsert).getVersion())).bind("insertedBy", ((ClusterNodes)clusterNodesToInsert).getModifiedBy())).bind("lastModified", ((ClusterNodes)clusterNodesToInsert).getLastModified() != null ? new Timestamp(((ClusterNodes)clusterNodesToInsert).getLastModified().toDateTime(DateTimeZone.UTC).getMillis()) : null)).bind("payload", this.jsonMapper.writeValueAsBytes(clusterNodesToInsert))).bind("used", true)).bind("clusterIdVersionSha1", clusterIdVersionSha1)).execute();
        return clusterNodesToInsert;
    }
}

