/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.persistence;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.imply.cloud.lifecycle.LifecycleStart;
import io.imply.cloud.persistence.DeletedVisibility;
import io.imply.cloud.persistence.SQLStorageConnector;
import io.imply.cloud.util.ISE;
import io.imply.cloud.util.Logger;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.exceptions.DBIException;
import org.skife.jdbi.v2.exceptions.NoResultsException;

public abstract class SQLBaseDataManager<T> {
    private static final Logger log = new Logger(SQLBaseDataManager.class);
    protected final ObjectMapper jsonMapper;
    protected final SQLStorageConnector connector;
    protected final IDBI dbi;

    protected SQLBaseDataManager(ObjectMapper jsonMapper, SQLStorageConnector connector) {
        this.jsonMapper = jsonMapper;
        this.connector = connector;
        this.dbi = connector.getDBI();
    }

    @LifecycleStart
    public void start() {
        this.createTable();
    }

    public boolean exists(String key, DeletedVisibility deletedVisibility) {
        if (key == null) {
            return false;
        }
        return (Boolean)this.dbi.withHandle(handle -> this.existsWithHandle(handle, key, deletedVisibility));
    }

    public T get(String key, DeletedVisibility deletedVisibility) {
        return (T)this.dbi.withHandle(handle -> this.getWithHandle(handle, key, deletedVisibility));
    }

    public T getOrNull(String key, DeletedVisibility deletedVisibility) {
        if (key == null) {
            return null;
        }
        try {
            return this.get(key, deletedVisibility);
        }
        catch (DBIException e) {
            if (e instanceof NoResultsException || e.getCause() instanceof NoResultsException) {
                return null;
            }
            throw e;
        }
    }

    public T getOrNullWithHandle(Handle handle, String key, DeletedVisibility deletedVisibility) {
        if (key == null) {
            return null;
        }
        try {
            return this.getWithHandle(handle, key, deletedVisibility);
        }
        catch (DBIException e) {
            if (e instanceof NoResultsException || e.getCause() instanceof NoResultsException) {
                return null;
            }
            throw e;
        }
    }

    public List<T> getAllVersions(String key, DeletedVisibility deletedVisibility) {
        return (List)this.dbi.withHandle(handle -> this.getAllVersionsWithHandle(handle, key, deletedVisibility, -1));
    }

    public List<T> getVersions(String key, DeletedVisibility deletedVisibility, int limit) {
        return (List)this.dbi.withHandle(handle -> this.getAllVersionsWithHandle(handle, key, deletedVisibility, limit));
    }

    public List<T> getAll(DeletedVisibility deletedVisibility) {
        return (List)this.dbi.withHandle(handle -> this.getAllWithHandle(handle, deletedVisibility));
    }

    public List<T> getAll() {
        return this.getAll(DeletedVisibility.HIDE);
    }

    public T get(String key) {
        return this.get(key, DeletedVisibility.HIDE);
    }

    public T getOrNull(String key) {
        return this.getOrNull(key, DeletedVisibility.HIDE);
    }

    public List<T> getAllVersions(String key) {
        return this.getAllVersions(key, DeletedVisibility.HIDE);
    }

    public boolean exists(String key) {
        return this.exists(key, DeletedVisibility.HIDE);
    }

    protected String generateUUIDWithHandle(Handle handle) {
        String uuid = UUID.randomUUID().toString();
        if (this.existsWithHandle(handle, uuid, DeletedVisibility.SHOW_ALL)) {
            log.wtf("Generated UUID [%s] already exists in table [%s]!", uuid, this.getTableName());
            throw new ISE("Generated UUID [%s] already exists in table [%s]!", uuid, this.getTableName());
        }
        return uuid;
    }

    protected static String buildDeletedFilter(DeletedVisibility deletedVisibility, Map<String, Object> namedArguments) {
        if (DeletedVisibility.SHOW_RECENT.equals((Object)deletedVisibility)) {
            namedArguments.put("cutoffTime", new Timestamp(DateTime.now().minusMinutes(720).toDateTime(DateTimeZone.UTC).getMillis()));
            return "AND (used=true OR last_modified > :cutoffTime)";
        }
        return DeletedVisibility.HIDE.equals((Object)deletedVisibility) ? "AND used=true" : "";
    }

    protected abstract boolean existsWithHandle(Handle var1, String var2, DeletedVisibility var3);

    protected abstract T getWithHandle(Handle var1, String var2, DeletedVisibility var3);

    protected abstract List<T> getAllVersionsWithHandle(Handle var1, String var2, DeletedVisibility var3, int var4);

    protected abstract List<T> getAllWithHandle(Handle var1, DeletedVisibility var2);

    protected abstract String getTableName();

    protected abstract String getMainKeyColumnName();

    protected abstract JavaType getJavaType();

    protected abstract void createTable();
}

