/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.persistence;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import io.imply.cloud.persistence.DeletedVisibility;
import io.imply.cloud.persistence.SQLBaseDataManager;
import io.imply.cloud.persistence.SQLStorageConnector;
import io.imply.cloud.util.NRE;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.exceptions.DBIException;
import org.skife.jdbi.v2.exceptions.NoResultsException;
import org.skife.jdbi.v2.tweak.ResultColumnMapper;
import org.skife.jdbi.v2.util.IntegerColumnMapper;

public abstract class SQLAppendingDataManager<T>
extends SQLBaseDataManager<T> {
    protected SQLAppendingDataManager(ObjectMapper jsonMapper, SQLStorageConnector connector) {
        super(jsonMapper, connector);
    }

    @Override
    protected boolean existsWithHandle(Handle handle, String key, DeletedVisibility deletedVisibility) {
        if (key == null) {
            return false;
        }
        HashMap<String, Object> namedArguments = new HashMap<String, Object>();
        namedArguments.put("key", key);
        String queryStr = String.format("SELECT COUNT(*) FROM %1$s WHERE %2$s = :key %3$s", this.getTableName(), this.getMainKeyColumnName(), SQLAppendingDataManager.buildDeletedFilter(deletedVisibility, namedArguments));
        int count = (Integer)((Query)handle.createQuery(queryStr).bindFromMap(namedArguments)).map((ResultColumnMapper)IntegerColumnMapper.PRIMITIVE).first();
        return count != 0;
    }

    @Override
    protected T getWithHandle(Handle handle, String key, DeletedVisibility deletedVisibility) {
        HashMap<String, Object> namedArguments = new HashMap<String, Object>();
        namedArguments.put("key", key);
        Object retVal = ((Query)handle.createQuery(String.format("SELECT payload FROM %1$s WHERE %2$s=:key %3$s ORDER BY version DESC LIMIT 1", this.getTableName(), this.getMainKeyColumnName(), SQLAppendingDataManager.buildDeletedFilter(deletedVisibility, namedArguments))).bindFromMap(namedArguments)).map((index, r, ctx) -> {
            try {
                Object payload = this.jsonMapper.readValue(r.getBytes("payload"), this.getJavaType());
                return payload;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).first();
        if (retVal == null) {
            throw new NRE(this.getJavaType().getRawClass(), key);
        }
        return (T)retVal;
    }

    @Override
    protected List<T> getAllVersionsWithHandle(Handle handle, String key, DeletedVisibility deletedVisibility, int limit) {
        List retVal;
        HashMap<String, Object> namedArguments = new HashMap<String, Object>();
        namedArguments.put("key", key);
        String query = String.format("SELECT payload FROM %1$s WHERE %2$s=:key %3$s ORDER BY version DESC", this.getTableName(), this.getMainKeyColumnName(), SQLAppendingDataManager.buildDeletedFilter(deletedVisibility, namedArguments));
        if (limit > 0) {
            query = String.format(query + " LIMIT %s", limit);
        }
        if ((retVal = ((Query)handle.createQuery(query).bindFromMap(namedArguments)).map((index, r, ctx) -> {
            try {
                Object payload = this.jsonMapper.readValue(r.getBytes("payload"), this.getJavaType());
                return payload;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).list()) == null) {
            return ImmutableList.of();
        }
        return retVal;
    }

    @Override
    protected List<T> getAllWithHandle(Handle handle, DeletedVisibility deletedVisibility) {
        HashMap<String, Object> namedArguments = new HashMap<String, Object>();
        List retVal = ((Query)handle.createQuery(String.format("SELECT r.%1$s, r.payload FROM %2$s r INNER JOIN(SELECT %1$s, max(version) as version FROM %2$s WHERE TRUE %3$s GROUP BY %1$s) latest ON r.%1$s = latest.%1$s and r.version = latest.version ORDER BY last_modified ASC", this.getMainKeyColumnName(), this.getTableName(), SQLAppendingDataManager.buildDeletedFilter(deletedVisibility, namedArguments))).bindFromMap(namedArguments)).map((index, r, ctx) -> {
            try {
                Object payload = this.jsonMapper.readValue(r.getBytes("payload"), this.getJavaType());
                return payload;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).list();
        if (retVal == null) {
            return ImmutableList.of();
        }
        return retVal;
    }

    public String delete(String key, String deletedBy) {
        return (String)this.dbi.inTransaction((handle, transactionStatus) -> {
            if (!this.existsWithHandle(handle, key, DeletedVisibility.HIDE)) {
                throw new NRE(this.getJavaType().getRawClass(), key);
            }
            ((Update)((Update)handle.createStatement(String.format("UPDATE %1$s SET used=:used WHERE %2$s=:key", this.getTableName(), this.getMainKeyColumnName())).bind("used", false)).bind("key", key)).execute();
            return key;
        });
    }

    public boolean deleteQuietly(String key, String deletedBy) {
        if (key == null) {
            return false;
        }
        try {
            this.delete(key, deletedBy);
            return true;
        }
        catch (DBIException e) {
            if (e instanceof NoResultsException || e.getCause() instanceof NoResultsException) {
                return false;
            }
            throw e;
        }
    }
}

