/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.persistence;

import com.google.common.base.Preconditions;
import io.imply.cloud.model.Account;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.EntityType;
import io.imply.cloud.model.Info;
import java.util.List;
import java.util.function.Consumer;
import org.skife.jdbi.v2.Handle;

public interface EntityStateDataManager {
    public Info insert(String var1, String var2, EntityType var3, Info var4, Consumer<Handle> var5);

    public Info insertWithHandle(Handle var1, String var2, String var3, EntityType var4, Info var5);

    public Info get(String var1);

    public Info getOrNull(String var1);

    public List<Info> getAllWithType(EntityType var1);

    public List<Info> getAllInTransitionStates();

    public String delete(String var1);

    default public Info insert(Account account, Info entityState) {
        return this.insert(account.key(), account.getAccountId(), EntityType.ACCOUNT, entityState, null);
    }

    default public Info insert(Cluster cluster, Info entityState) {
        return this.insert(cluster.key(), cluster.getClusterId(), EntityType.CLUSTER, entityState, null);
    }

    default public Info insert(Info info, Info entityState) {
        return this.insert(info.getKey(), info.getEntityId(), info.getEntityType(), entityState, null);
    }

    default public Info get(Cluster cluster) {
        return this.get(((Cluster)Preconditions.checkNotNull((Object)cluster, (Object)"cluster")).getClusterId());
    }

    default public Info get(Account account) {
        return this.get(((Account)Preconditions.checkNotNull((Object)account, (Object)"account")).getAccountId());
    }

    default public Info get(Info info) {
        return this.get(((Info)Preconditions.checkNotNull((Object)info, (Object)"info")).getEntityId());
    }

    default public Info getOrNull(Cluster cluster) {
        return ((Cluster)Preconditions.checkNotNull((Object)cluster, (Object)"cluster")).getClusterId() == null ? null : this.getOrNull(cluster.getClusterId());
    }

    default public Info getOrNull(Account account) {
        return ((Account)Preconditions.checkNotNull((Object)account, (Object)"account")).getAccountId() == null ? null : this.getOrNull(account.getAccountId());
    }

    default public String delete(Info info) {
        return this.delete(info.getEntityId());
    }
}

