/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.persistence;

import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ClusterWithExtendedInfo;
import io.imply.cloud.model.ConfigRequestBody;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.Region;
import io.imply.cloud.persistence.DeletedVisibility;
import io.imply.cloud.persistence.EntityStateDataManager;
import java.util.List;
import org.skife.jdbi.v2.Handle;

public interface ClusterDataManager {
    public ClusterWithExtendedInfo createWithInfo(Cluster var1, Info var2, String var3, boolean var4, boolean var5, boolean var6, Integer var7, Region var8);

    public Cluster update(Cluster var1, String var2, boolean var3, boolean var4);

    public ClusterWithExtendedInfo updateWithInfo(Cluster var1, Info var2, String var3, boolean var4, boolean var5, boolean var6, boolean var7, boolean var8);

    public Cluster get(String var1);

    public Cluster get(String var1, DeletedVisibility var2);

    public Cluster getOrNull(String var1);

    public Cluster getOrNullWithHandle(Handle var1, String var2, DeletedVisibility var3);

    public Cluster getVersionOrNull(String var1, int var2);

    public List<Cluster> getAllWithAccountId(String var1);

    public List<Cluster> getAllWithAccountId(String var1, DeletedVisibility var2);

    public List<Cluster> getAllVersions(String var1, DeletedVisibility var2);

    public List<Cluster> getVersions(String var1, DeletedVisibility var2, int var3);

    public List<Cluster> getAll();

    public List<Cluster> getAll(DeletedVisibility var1);

    public String delete(String var1, String var2, boolean var3);

    public boolean isDeleted(String var1);

    default public Cluster getVersionForConfig(ConfigRequestBody configRequestBody, EntityStateDataManager entityStateDataManager) {
        if (configRequestBody == null || configRequestBody.getClusterId() == null) {
            return null;
        }
        String clusterId = configRequestBody.getClusterId();
        Cluster cluster = this.getOrNull(clusterId);
        if (cluster == null) {
            return null;
        }
        if (configRequestBody.getConfigVersion() != null) {
            return this.getVersionOrNull(clusterId, configRequestBody.getConfigVersion());
        }
        Info info = entityStateDataManager.getOrNull(cluster);
        return info == null || info.getConfigServerClusterVersion() == null ? cluster : this.getVersionOrNull(clusterId, info.getConfigServerClusterVersion());
    }
}

