/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model.usage;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.imply.cloud.model.usage.UsageReportClusterEntry;
import io.imply.cloud.model.usage.UsageReportInstanceTypeEntry;
import io.imply.cloud.util.ToStringBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.joda.time.Interval;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UsageReportIntervalReport {
    private final Interval interval;
    private final List<UsageReportClusterEntry> clusters;
    private final long totalMICU;
    private final List<UsageReportInstanceTypeEntry> totalInstanceUsage;

    @JsonCreator
    public UsageReportIntervalReport(@JsonProperty(value="interval") Interval interval, @JsonProperty(value="clusters") List<UsageReportClusterEntry> clusters) {
        this.interval = (Interval)Preconditions.checkNotNull((Object)interval);
        this.clusters = (List)Preconditions.checkNotNull(clusters);
        this.totalMICU = this.clusters.stream().mapToLong(UsageReportClusterEntry::getClusterMICU).sum();
        this.totalInstanceUsage = this.generateTotalInstanceUsageList(this.clusters);
    }

    @JsonProperty
    public Interval getInterval() {
        return this.interval;
    }

    @JsonProperty
    public List<UsageReportClusterEntry> getClusters() {
        return this.clusters;
    }

    @JsonProperty
    public Long getTotalMICU() {
        return this.totalMICU;
    }

    @JsonProperty
    public List<UsageReportInstanceTypeEntry> getTotalInstanceUsage() {
        return this.totalInstanceUsage;
    }

    public String toString() {
        return new ToStringBuilder(this).append("interval", this.interval).append("clusters", this.clusters).append("totalMICU", this.totalMICU).append("totalInstanceUsage", this.totalInstanceUsage).toString();
    }

    private List<UsageReportInstanceTypeEntry> generateTotalInstanceUsageList(List<UsageReportClusterEntry> clusters) {
        HashMap<String, Long> instanceUsage = new HashMap<String, Long>();
        for (UsageReportClusterEntry clusterEntry : clusters) {
            for (UsageReportInstanceTypeEntry instanceTypeEntry : clusterEntry.getClusterInstanceUsage()) {
                instanceUsage.compute(instanceTypeEntry.getType(), (k, v) -> v == null ? instanceTypeEntry.getSeconds() : v + instanceTypeEntry.getSeconds());
            }
        }
        return instanceUsage.entrySet().stream().map(x -> new UsageReportInstanceTypeEntry((String)x.getKey(), (Long)x.getValue())).collect(Collectors.toList());
    }
}

