/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model.usage;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.imply.cloud.model.ImplyNodeType;
import io.imply.cloud.model.usage.UsageHelper;
import io.imply.cloud.model.usage.UsageReportNodeEntry;
import io.imply.cloud.util.ToStringBuilder;
import java.util.Map;
import org.joda.time.Interval;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UsageReportIntervalEntry {
    private final Interval interval;
    private final Map<ImplyNodeType, UsageReportNodeEntry> nodes;

    @JsonCreator
    public UsageReportIntervalEntry(@JsonProperty(value="interval") Interval interval, @JsonProperty(value="nodes") Map<ImplyNodeType, UsageReportNodeEntry> nodes) {
        this.interval = (Interval)Preconditions.checkNotNull((Object)interval);
        this.nodes = this.validateNodeEntries((Map)Preconditions.checkNotNull(nodes));
    }

    @JsonProperty
    public Interval getInterval() {
        return this.interval;
    }

    @JsonProperty
    public Map<ImplyNodeType, UsageReportNodeEntry> getNodes() {
        return this.nodes;
    }

    @JsonProperty
    public Long getIntervalSeconds() {
        return UsageHelper.getIntervalSeconds(this.interval);
    }

    @JsonProperty
    public Long getIntervalMICU() {
        return this.nodes.values().stream().mapToLong(x -> (long)x.getCount().intValue() * UsageHelper.getIntervalMICU(x.getPerNodeHourlyMICU(), this.interval)).sum();
    }

    private Map<ImplyNodeType, UsageReportNodeEntry> validateNodeEntries(Map<ImplyNodeType, UsageReportNodeEntry> nodes) {
        nodes.values().forEach(x -> Preconditions.checkState((x != null && x.getCount() != null && x.getPerNodeHourlyMICU() != null && x.getCount() >= 0 && x.getPerNodeHourlyMICU() >= 0L ? 1 : 0) != 0, (Object)"[count] and [perNodeHourlyMICU] must be positive"));
        return nodes;
    }

    public String toString() {
        return new ToStringBuilder(this).append("interval", this.interval).append("nodes", this.nodes).toString();
    }
}

