/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model.metadatastorage;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Strings;
import io.imply.cloud.RefreshableConstants;
import io.imply.cloud.config.DefaultsConfig;
import io.imply.cloud.model.ImplyConstraintViolation;
import io.imply.cloud.model.metadatastorage.MetadataStorage;
import io.imply.cloud.util.InstanceTypeHelper;
import io.imply.cloud.util.ToStringBuilder;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.builder.DiffResult;
import org.apache.commons.lang3.builder.ReflectionDiffBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public abstract class SqlMetadataStorage
implements MetadataStorage {
    private final String host;
    private final Integer port;
    private final String schema;
    private final String user;
    private final String password;
    private final String tlsCert;
    private final String clientCert;
    private final String clientKey;

    protected SqlMetadataStorage(String host, Integer port, String schema, String user, String password, String tlsCert, String clientCert, String clientKey) {
        this.host = host;
        this.port = port;
        this.schema = schema;
        this.user = user;
        this.password = password;
        this.tlsCert = tlsCert;
        this.clientCert = clientCert;
        this.clientKey = clientKey;
    }

    protected abstract MetadataStorage newInstance(String var1, Integer var2, String var3, String var4, String var5, String var6, String var7, String var8);

    @Override
    @JsonProperty
    public String getHost() {
        return this.host;
    }

    @Override
    @JsonProperty
    public Integer getPort() {
        return this.port;
    }

    @Override
    @JsonProperty
    public String getSchema() {
        return this.schema;
    }

    @Override
    @JsonProperty
    public String getUser() {
        return this.user;
    }

    @Override
    @JsonProperty
    public String getPassword() {
        return this.password;
    }

    @Override
    @JsonProperty
    public String getTlsCert() {
        return this.tlsCert;
    }

    @Override
    @JsonProperty
    public String getClientCert() {
        return this.clientCert;
    }

    @Override
    @JsonProperty
    public String getClientKey() {
        return this.clientKey;
    }

    @Override
    public String getConnectURI() {
        return String.format("jdbc:%s://%s:%s/%s%s", this.getJdbcPrefix(), this.host, this.port, this.schema, this.getConnectionParameters() != null ? "?" + this.getConnectionParameters() : "");
    }

    public String getJdbcPrefix() {
        return this.getMetadataType();
    }

    @Override
    public abstract String getMetadataType();

    public abstract String getConnectionParameters();

    @Override
    public MetadataStorage merge(MetadataStorage other) {
        if (other == null) {
            return this;
        }
        if (!this.getClass().equals(other.getClass())) {
            return other;
        }
        SqlMetadataStorage mysqlOther = (SqlMetadataStorage)other;
        String host = mysqlOther.host != null ? mysqlOther.host : this.host;
        Integer port = mysqlOther.port != null ? mysqlOther.port : this.port;
        String schema = mysqlOther.schema != null ? mysqlOther.schema : this.schema;
        String user = mysqlOther.user != null ? mysqlOther.user : this.user;
        String password = mysqlOther.password != null ? mysqlOther.password : this.password;
        String tlsCert = mysqlOther.tlsCert != null ? mysqlOther.tlsCert : this.tlsCert;
        String clientCert = mysqlOther.clientCert != null ? mysqlOther.clientCert : this.clientCert;
        String clientKey = mysqlOther.clientKey != null ? mysqlOther.clientKey : this.clientKey;
        return this.newInstance(host, port, schema, user, password, tlsCert, clientCert, clientKey);
    }

    @Override
    public MetadataStorage mergeDiff(MetadataStorage other) {
        String clientCert;
        String tlsCert;
        String password;
        String user;
        String schema;
        Integer port;
        String host;
        if (other == null || !this.getClass().equals(other.getClass())) {
            return this;
        }
        SqlMetadataStorage sqlOther = (SqlMetadataStorage)other;
        String string = this.host == null ? null : (host = this.host.equals(sqlOther.host) ? null : this.host);
        Integer n = this.port == null ? null : (port = this.port.equals(sqlOther.port) ? null : this.port);
        String string2 = this.schema == null ? null : (schema = this.schema.equals(sqlOther.schema) ? null : this.schema);
        String string3 = this.user == null ? null : (user = this.user.equals(sqlOther.user) ? null : this.user);
        String string4 = this.password == null ? null : (password = this.password.equals(sqlOther.password) ? null : this.password);
        String string5 = this.tlsCert == null ? null : (tlsCert = this.tlsCert.equals(sqlOther.tlsCert) ? null : this.tlsCert);
        String string6 = this.clientCert == null ? null : (clientCert = this.clientCert.equals(sqlOther.clientCert) ? null : this.clientCert);
        String clientKey = this.clientKey == null ? null : (this.clientKey.equals(sqlOther.clientKey) ? null : this.clientKey);
        return this.newInstance(host, port, schema, user, password, tlsCert, clientCert, clientKey);
    }

    public DiffResult<MetadataStorage> diff(MetadataStorage other) {
        return new ReflectionDiffBuilder((Object)this, (Object)other, ToStringStyle.SHORT_PREFIX_STYLE).build();
    }

    @Override
    public MetadataStorage filterNonNullFields(MetadataStorage filter) {
        if (filter == null || !this.getClass().equals(filter.getClass())) {
            return this.newInstance(null, null, null, null, null, null, null, null);
        }
        SqlMetadataStorage sqlFilter = (SqlMetadataStorage)filter;
        String host = sqlFilter.host == null ? null : this.host;
        Integer port = sqlFilter.port == null ? null : this.port;
        String schema = sqlFilter.schema == null ? null : this.schema;
        String user = sqlFilter.user == null ? null : this.user;
        String password = sqlFilter.password == null ? null : this.password;
        String tlsCert = sqlFilter.tlsCert == null ? null : this.tlsCert;
        String clientCert = sqlFilter.clientCert == null ? null : this.clientCert;
        String clientKey = sqlFilter.clientKey == null ? null : this.clientKey;
        return this.newInstance(host, port, schema, user, password, tlsCert, clientCert, clientKey);
    }

    @Override
    public MetadataStorage withDefaultsForUnset(boolean setCreationOnlyDefaults, InstanceTypeHelper instanceTypeHelper) {
        return this.newInstance(this.host, this.port, this.schema != null ? this.schema : "druid", this.user, this.password, this.tlsCert, this.clientCert, this.clientKey);
    }

    @Override
    public MetadataStorage withSensitiveFieldsMasked() {
        return this.newInstance(this.host, this.port, this.schema, this.user, this.password != null ? "{secret}" : null, this.tlsCert, this.clientCert, this.clientKey != null ? "{secret}" : null);
    }

    @Override
    public MetadataStorage withSensitiveFieldPlaceholdersRemoved() {
        return this.newInstance(this.host, this.port, this.schema, this.user, "{secret}".equals(this.password) ? null : this.password, this.tlsCert, this.clientCert, "{secret}".equals(this.clientKey) ? null : this.clientKey);
    }

    @Override
    public MetadataStorage withSensitiveFieldPlaceholdersReplaced(DefaultsConfig defaultsConfig) {
        String password = this.password;
        String clientKey = this.clientKey;
        if ("{secret}".equals(password) && this.user != null && this.user.equals(defaultsConfig.getMetadataStorageUser())) {
            password = defaultsConfig.getMetadataStoragePassword();
        }
        if ("{secret}".equals(clientKey) && this.clientCert != null && this.clientCert.equals(defaultsConfig.getMetadataStorageClientCert())) {
            clientKey = defaultsConfig.getMetadataStorageClientKey();
        }
        return this.newInstance(this.host, this.port, this.schema, this.user, password, this.tlsCert, this.clientCert, clientKey);
    }

    @Override
    public void validate(List<ImplyConstraintViolation> results, RefreshableConstants refreshableConstants) {
        if (Strings.isNullOrEmpty((String)this.host)) {
            results.add(ImplyConstraintViolation.error("metadataStorage.host", "[host] cannot be empty", new Object[0]));
        }
        if (this.port == null) {
            results.add(ImplyConstraintViolation.error("metadataStorage.port", "[port] cannot be null", new Object[0]));
        }
        if (Strings.isNullOrEmpty((String)this.schema)) {
            results.add(ImplyConstraintViolation.error("metadataStorage.schema", "[schema] cannot be empty", new Object[0]));
        }
        if (Strings.isNullOrEmpty((String)this.user)) {
            results.add(ImplyConstraintViolation.error("metadataStorage.user", "[user] cannot be empty", new Object[0]));
        }
        if (Strings.isNullOrEmpty((String)this.tlsCert) && !Strings.isNullOrEmpty((String)this.clientCert) && !Strings.isNullOrEmpty((String)this.clientKey)) {
            results.add(ImplyConstraintViolation.error("metadataStorage.tlsCert", "[tlsCert] cannot be empty if [clientCert] and [clientKey] are provided", new Object[0]));
        }
        if (Strings.isNullOrEmpty((String)this.clientCert) && !Strings.isNullOrEmpty((String)this.clientKey)) {
            results.add(ImplyConstraintViolation.error("metadataStorage.clientCert", "[clientCert] cannot be empty if [clientKey] is provided", new Object[0]));
        }
        if (Strings.isNullOrEmpty((String)this.clientKey) && !Strings.isNullOrEmpty((String)this.clientCert)) {
            results.add(ImplyConstraintViolation.error("metadataStorage.clientKey", "[clientKey] cannot be empty if [clientCert] is provided", new Object[0]));
        }
    }

    @Override
    public boolean isEmpty() {
        return this.host == null && this.port == null && this.schema == null && this.user == null && this.password == null && this.tlsCert == null && this.clientCert == null && this.clientKey == null;
    }

    public String toString() {
        return new ToStringBuilder(this).append("host", this.host).append("port", (Object)this.port).append("schema", (Object)this.schema).append("user", (Object)this.user).append("password", (Object)"*****************").append("tlsCert", (Object)this.tlsCert).append("clientCert", (Object)this.clientCert).append("clientKey", (Object)"*****************").toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlMetadataStorage that = (SqlMetadataStorage)o;
        return Objects.equals(this.host, that.host) && Objects.equals(this.port, that.port) && Objects.equals(this.schema, that.schema) && Objects.equals(this.user, that.user) && Objects.equals(this.password, that.password) && Objects.equals(this.tlsCert, that.tlsCert) && Objects.equals(this.clientCert, that.clientCert) && Objects.equals(this.clientKey, that.clientKey);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port, this.schema, this.user, this.password, this.tlsCert, this.clientCert, this.clientKey);
    }

    @Generated
    protected SqlMetadataStorage(Builder<?, ?> b) {
        this.host = b.host;
        this.port = b.port;
        this.schema = b.schema;
        this.user = b.user;
        this.password = b.password;
        this.tlsCert = b.tlsCert;
        this.clientCert = b.clientCert;
        this.clientKey = b.clientKey;
    }

    @Generated
    public static abstract class Builder<C extends SqlMetadataStorage, B extends Builder<C, B>> {
        @Generated
        private String host;
        @Generated
        private Integer port;
        @Generated
        private String schema;
        @Generated
        private String user;
        @Generated
        private String password;
        @Generated
        private String tlsCert;
        @Generated
        private String clientCert;
        @Generated
        private String clientKey;

        @Generated
        protected B $fillValuesFrom(C instance) {
            Builder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(SqlMetadataStorage instance, Builder<?, ?> b) {
            b.host(instance.host);
            b.port(instance.port);
            b.schema(instance.schema);
            b.user(instance.user);
            b.password(instance.password);
            b.tlsCert(instance.tlsCert);
            b.clientCert(instance.clientCert);
            b.clientKey(instance.clientKey);
        }

        @Generated
        public B host(String host) {
            this.host = host;
            return this.self();
        }

        @Generated
        public B port(Integer port) {
            this.port = port;
            return this.self();
        }

        @Generated
        public B schema(String schema) {
            this.schema = schema;
            return this.self();
        }

        @Generated
        public B user(String user) {
            this.user = user;
            return this.self();
        }

        @Generated
        public B password(String password) {
            this.password = password;
            return this.self();
        }

        @Generated
        public B tlsCert(String tlsCert) {
            this.tlsCert = tlsCert;
            return this.self();
        }

        @Generated
        public B clientCert(String clientCert) {
            this.clientCert = clientCert;
            return this.self();
        }

        @Generated
        public B clientKey(String clientKey) {
            this.clientKey = clientKey;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "SqlMetadataStorage.Builder(host=" + this.host + ", port=" + this.port + ", schema=" + this.schema + ", user=" + this.user + ", password=" + this.password + ", tlsCert=" + this.tlsCert + ", clientCert=" + this.clientCert + ", clientKey=" + this.clientKey + ")";
        }
    }
}

