/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model.druid;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.imply.cloud.model.ImplyConstraintViolation;
import io.imply.cloud.model.druid.DeepStorage;
import io.imply.cloud.util.ToStringBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import lombok.Generated;
import org.apache.commons.lang3.builder.DiffResult;
import org.apache.commons.lang3.builder.ReflectionDiffBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class LocalDeepStorage
implements DeepStorage {
    private final String storageDirectory;

    @JsonCreator
    public LocalDeepStorage(@JsonProperty(value="storageDirectory") String storageDirectory) {
        this.storageDirectory = storageDirectory;
    }

    @JsonProperty
    public String getStorageDirectory() {
        return this.storageDirectory;
    }

    @Override
    public void validate(List<ImplyConstraintViolation> results) {
        if (this.storageDirectory == null) {
            results.add(ImplyConstraintViolation.error("deepStorage.storageDirectory", "[storageDirectory] must be set", new Object[0]));
        }
    }

    @Override
    public DeepStorage merge(DeepStorage other) {
        if (other == null) {
            return this;
        }
        if (!(other instanceof LocalDeepStorage)) {
            return other;
        }
        LocalDeepStorage localOther = (LocalDeepStorage)other;
        return new LocalDeepStorage(localOther.storageDirectory == null ? this.storageDirectory : localOther.storageDirectory);
    }

    @Override
    public DeepStorage mergeDiff(DeepStorage other) {
        if (other == null || !(other instanceof LocalDeepStorage)) {
            return this;
        }
        LocalDeepStorage localOther = (LocalDeepStorage)other;
        return new LocalDeepStorage(this.storageDirectory == null ? null : (this.storageDirectory.equals(localOther.storageDirectory) ? null : this.storageDirectory));
    }

    public DiffResult<DeepStorage> diff(DeepStorage other) {
        return new ReflectionDiffBuilder((Object)this, (Object)other, ToStringStyle.SHORT_PREFIX_STYLE).build();
    }

    @Override
    public DeepStorage filterNonNullFields(DeepStorage filter) {
        if (filter == null || !(filter instanceof LocalDeepStorage)) {
            return new LocalDeepStorage(null);
        }
        LocalDeepStorage localFilter = (LocalDeepStorage)filter;
        return new LocalDeepStorage(localFilter.getStorageDirectory() == null ? null : this.storageDirectory);
    }

    @Override
    public boolean isEmpty() {
        return this.storageDirectory == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalDeepStorage that = (LocalDeepStorage)o;
        return Objects.equals(this.storageDirectory, that.storageDirectory);
    }

    public int hashCode() {
        return Objects.hash(this.storageDirectory);
    }

    @Override
    public Properties getSegmentLocationProperties() {
        Properties props = new Properties();
        props.setProperty("druid.storage.type", "local");
        props.setProperty("druid.storage.storageDirectory", String.format("%s/segments", this.storageDirectory));
        return props;
    }

    @Override
    public Properties getIndexingLogLocationProperties() {
        Properties props = new Properties();
        props.setProperty("druid.indexer.logs.type", "file");
        props.setProperty("druid.indexer.logs.directory", String.format("%s/indexing-logs", this.storageDirectory));
        return props;
    }

    public String toString() {
        return new ToStringBuilder(this).append("storageDirectory", this.storageDirectory).toString();
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public Builder toBuilder() {
        return new Builder().storageDirectory(this.storageDirectory);
    }

    @Generated
    public static class Builder {
        @Generated
        private String storageDirectory;

        @Generated
        Builder() {
        }

        @Generated
        public Builder storageDirectory(String storageDirectory) {
            this.storageDirectory = storageDirectory;
            return this;
        }

        @Generated
        public LocalDeepStorage build() {
            return new LocalDeepStorage(this.storageDirectory);
        }

        @Generated
        public String toString() {
            return "LocalDeepStorage.Builder(storageDirectory=" + this.storageDirectory + ")";
        }
    }
}

