/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model.druid;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import io.imply.cloud.model.druid.Worker;
import io.imply.cloud.util.ToStringBuilder;
import java.util.Collection;
import java.util.Set;
import org.joda.time.DateTime;

public class ImmutableWorkerInfo {
    private final Worker worker;
    private final int currCapacityUsed;
    private final ImmutableSet<String> availabilityGroups;
    private final ImmutableSet<String> runningTasks;
    private final DateTime lastCompletedTaskTime;

    @JsonCreator
    public ImmutableWorkerInfo(@JsonProperty(value="worker") Worker worker, @JsonProperty(value="currCapacityUsed") int currCapacityUsed, @JsonProperty(value="availabilityGroups") Set<String> availabilityGroups, @JsonProperty(value="runningTasks") Collection<String> runningTasks, @JsonProperty(value="lastCompletedTaskTime") DateTime lastCompletedTaskTime) {
        this.worker = worker;
        this.currCapacityUsed = currCapacityUsed;
        this.availabilityGroups = ImmutableSet.copyOf(availabilityGroups);
        this.runningTasks = ImmutableSet.copyOf(runningTasks);
        this.lastCompletedTaskTime = lastCompletedTaskTime;
    }

    @JsonProperty(value="worker")
    public Worker getWorker() {
        return this.worker;
    }

    @JsonProperty(value="currCapacityUsed")
    public int getCurrCapacityUsed() {
        return this.currCapacityUsed;
    }

    @JsonProperty(value="availabilityGroups")
    public Set<String> getAvailabilityGroups() {
        return this.availabilityGroups;
    }

    public int getAvailableCapacity() {
        return this.getWorker().getCapacity() - this.getCurrCapacityUsed();
    }

    @JsonProperty(value="runningTasks")
    public Set<String> getRunningTasks() {
        return this.runningTasks;
    }

    @JsonProperty(value="lastCompletedTaskTime")
    public DateTime getLastCompletedTaskTime() {
        return this.lastCompletedTaskTime;
    }

    public boolean isValidVersion(String minVersion) {
        return this.worker.getVersion().compareTo(minVersion) >= 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableWorkerInfo that = (ImmutableWorkerInfo)o;
        if (this.currCapacityUsed != that.currCapacityUsed) {
            return false;
        }
        if (!this.worker.equals(that.worker)) {
            return false;
        }
        if (!this.availabilityGroups.equals(that.availabilityGroups)) {
            return false;
        }
        if (!this.runningTasks.equals(that.runningTasks)) {
            return false;
        }
        return this.lastCompletedTaskTime.equals((Object)that.lastCompletedTaskTime);
    }

    public int hashCode() {
        int result = this.worker.hashCode();
        result = 31 * result + this.currCapacityUsed;
        result = 31 * result + this.availabilityGroups.hashCode();
        result = 31 * result + this.runningTasks.hashCode();
        result = 31 * result + this.lastCompletedTaskTime.hashCode();
        return result;
    }

    public String toString() {
        return new ToStringBuilder(this).append("worker", this.worker).append("currCapacityUsed", this.currCapacityUsed).append("availabilityGroups", this.availabilityGroups).append("runningTasks", this.runningTasks).append("lastCompletedTaskTime", (Object)this.lastCompletedTaskTime).toString();
    }
}

