/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model.druid;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.imply.cloud.Constants;
import io.imply.cloud.config.DefaultsConfig;
import io.imply.cloud.jackson.DefaultObjectMapper;
import io.imply.cloud.model.ImplyConstraintViolation;
import io.imply.cloud.model.druid.DeepStorage;
import io.imply.cloud.util.ToStringBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Matcher;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.DiffResult;
import org.apache.commons.lang3.builder.ReflectionDiffBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class GCSDeepStorage
implements DeepStorage {
    private final String gsLocation;
    private final String jsonKey;

    @JsonCreator
    public GCSDeepStorage(@JsonProperty(value="gsLocation") String gsLocation, @JsonProperty(value="jsonKey") String jsonKey) {
        this.gsLocation = gsLocation;
        this.jsonKey = jsonKey;
    }

    @JsonProperty
    public String getGsLocation() {
        return this.gsLocation;
    }

    @JsonProperty
    public String getJsonKey() {
        return this.jsonKey;
    }

    public String getGsBucket() {
        Matcher gsLocationMatcher = Constants.GCS_LOCATION_PATTERN.matcher(this.gsLocation);
        return gsLocationMatcher.matches() ? gsLocationMatcher.group(1) : null;
    }

    public String getGsPrefix() {
        Matcher gsLocationMatcher = Constants.GCS_LOCATION_PATTERN.matcher(this.gsLocation);
        return gsLocationMatcher.matches() ? gsLocationMatcher.group(2) : null;
    }

    @Override
    public void validate(List<ImplyConstraintViolation> results) {
        if (this.gsLocation == null || !Constants.GCS_LOCATION_PATTERN.matcher(this.gsLocation).matches()) {
            results.add(ImplyConstraintViolation.error("deepStorage.gsLocation", "[gsLocation] must match regex: %s", Constants.GCS_LOCATION_PATTERN.toString()));
        }
        if (StringUtils.isNotBlank((CharSequence)this.jsonKey) && !"{secret}".equals(this.jsonKey)) {
            try {
                new DefaultObjectMapper().readTree(this.jsonKey);
            }
            catch (JsonProcessingException e) {
                results.add(ImplyConstraintViolation.error("deepStorage.jsonKey", "[jsonKey] must be valid JSON\n%s", e.getMessage()));
            }
        }
    }

    @Override
    public DeepStorage merge(DeepStorage other) {
        if (other == null) {
            return this;
        }
        if (!(other instanceof GCSDeepStorage)) {
            return other;
        }
        GCSDeepStorage gcsOther = (GCSDeepStorage)other;
        return new GCSDeepStorage(gcsOther.gsLocation == null ? this.gsLocation : gcsOther.gsLocation, gcsOther.jsonKey == null ? this.jsonKey : gcsOther.jsonKey);
    }

    @Override
    public DeepStorage mergeDiff(DeepStorage other) {
        if (other == null || !(other instanceof GCSDeepStorage)) {
            return this;
        }
        GCSDeepStorage gcsOther = (GCSDeepStorage)other;
        return new GCSDeepStorage(this.gsLocation == null ? null : (this.gsLocation.equals(gcsOther.gsLocation) ? null : this.gsLocation), this.jsonKey == null ? null : (this.jsonKey.equals(gcsOther.jsonKey) ? null : this.jsonKey));
    }

    public DiffResult<DeepStorage> diff(DeepStorage other) {
        return new ReflectionDiffBuilder((Object)this, (Object)other, ToStringStyle.SHORT_PREFIX_STYLE).build();
    }

    @Override
    public DeepStorage filterNonNullFields(DeepStorage filter) {
        if (filter == null || !(filter instanceof GCSDeepStorage)) {
            return new GCSDeepStorage(null, null);
        }
        GCSDeepStorage gcsFilter = (GCSDeepStorage)filter;
        return new GCSDeepStorage(gcsFilter.gsLocation == null ? null : this.gsLocation, gcsFilter.jsonKey == null ? null : this.jsonKey);
    }

    @Override
    public boolean isEmpty() {
        return StringUtils.isBlank((CharSequence)this.gsLocation) && StringUtils.isBlank((CharSequence)this.jsonKey);
    }

    public int hashCode() {
        return Objects.hash(this.gsLocation, this.jsonKey);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GCSDeepStorage that = (GCSDeepStorage)o;
        return Objects.equals(this.gsLocation, that.gsLocation) && Objects.equals(this.jsonKey, that.jsonKey);
    }

    @Override
    public Properties getSegmentLocationProperties() {
        Properties props = new Properties();
        props.setProperty("druid.storage.type", "google");
        props.setProperty("druid.google.bucket", this.getGsBucket());
        props.setProperty("druid.google.prefix", this.getGsPrefix() == null ? "segments" : String.format("%s/segments", this.getGsPrefix()));
        return props;
    }

    @Override
    public Properties getIndexingLogLocationProperties() {
        Properties props = new Properties();
        props.setProperty("druid.indexer.logs.type", "google");
        props.setProperty("druid.indexer.logs.bucket", this.getGsBucket());
        props.setProperty("druid.indexer.logs.prefix", this.getGsPrefix() == null ? "indexing-logs" : String.format("%s/indexing-logs", this.getGsPrefix()));
        return props;
    }

    @Override
    public DeepStorage withSensitiveFieldsMasked() {
        return new GCSDeepStorage(this.gsLocation, this.jsonKey != null ? "{secret}" : null);
    }

    @Override
    public DeepStorage withSensitiveFieldPlaceholdersRemoved() {
        return new GCSDeepStorage(this.gsLocation, "{secret}".equals(this.jsonKey) ? null : this.jsonKey);
    }

    @Override
    public DeepStorage withSensitiveFieldPlaceholdersReplaced(DefaultsConfig defaultsConfig) {
        if ("{secret}".equals(this.jsonKey)) {
            return new GCSDeepStorage(this.gsLocation, defaultsConfig.getDeepStoragePassword());
        }
        return this;
    }

    public String toString() {
        return new ToStringBuilder(this).append("gsLocation", this.gsLocation).append("jsonKey", (Object)"*****************").toString();
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public Builder toBuilder() {
        return new Builder().gsLocation(this.gsLocation).jsonKey(this.jsonKey);
    }

    @Generated
    public static class Builder {
        @Generated
        private String gsLocation;
        @Generated
        private String jsonKey;

        @Generated
        Builder() {
        }

        @Generated
        public Builder gsLocation(String gsLocation) {
            this.gsLocation = gsLocation;
            return this;
        }

        @Generated
        public Builder jsonKey(String jsonKey) {
            this.jsonKey = jsonKey;
            return this;
        }

        @Generated
        public GCSDeepStorage build() {
            return new GCSDeepStorage(this.gsLocation, this.jsonKey);
        }

        @Generated
        public String toString() {
            return "GCSDeepStorage.Builder(gsLocation=" + this.gsLocation + ", jsonKey=" + this.jsonKey + ")";
        }
    }
}

