/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model.druid;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.imply.cloud.RefreshableConstants;
import io.imply.cloud.config.ApplicationConfig;
import io.imply.cloud.config.DefaultsConfig;
import io.imply.cloud.model.DruidExtensions;
import io.imply.cloud.model.ImplyConstraintViolation;
import io.imply.cloud.model.ImplyVersion;
import io.imply.cloud.model.Mergeable;
import io.imply.cloud.model.UpdateDetails;
import io.imply.cloud.model.druid.AzureDeepStorage;
import io.imply.cloud.model.druid.GCSDeepStorage;
import io.imply.cloud.model.druid.HdfsDeepStorage;
import io.imply.cloud.model.druid.LocalDeepStorage;
import io.imply.cloud.model.druid.S3DeepStorage;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang3.builder.Diff;
import org.apache.commons.lang3.builder.Diffable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSubTypes(value={@JsonSubTypes.Type(name="s3", value=S3DeepStorage.class), @JsonSubTypes.Type(name="local", value=LocalDeepStorage.class), @JsonSubTypes.Type(name="hdfs", value=HdfsDeepStorage.class), @JsonSubTypes.Type(name="google", value=GCSDeepStorage.class), @JsonSubTypes.Type(name="azure", value=AzureDeepStorage.class)})
public interface DeepStorage
extends Mergeable<DeepStorage>,
Diffable<DeepStorage> {
    public static final String INDEXER_LOGS_PREFIX = "druid.indexer.logs.prefix";
    public static final String INDEXER_LOGS_TYPE = "druid.indexer.logs.type";
    public static final String STORAGE_TYPE = "druid.storage.type";
    public static final String MSQE_INTERMEDIATE_STORAGE_TYPE = "druid.msq.intermediate.storage.type";

    public void validate(List<ImplyConstraintViolation> var1);

    public DeepStorage merge(DeepStorage var1);

    @Override
    public DeepStorage mergeDiff(DeepStorage var1);

    public DeepStorage filterNonNullFields(DeepStorage var1);

    default public DeepStorage withDefaultsForUnset(boolean setCreationOnlyDefaults) {
        return this;
    }

    @Override
    public boolean isEmpty();

    public Properties getSegmentLocationProperties();

    public Properties getIndexingLogLocationProperties();

    default public Properties getMSQEDurableStorageLocationProperties(@Nullable ImplyVersion implyVersion) {
        return new Properties();
    }

    default public DeepStorage withSensitiveFieldsMasked() {
        return this;
    }

    default public DeepStorage withSensitiveFieldPlaceholdersRemoved() {
        return this;
    }

    default public DeepStorage withSensitiveFieldPlaceholdersReplaced(DefaultsConfig defaultsConfig) {
        return this;
    }

    default public Boolean isUseEncryption() {
        return false;
    }

    default public List<Set<UpdateDetails>> getSupportedUpdatesForDiff(boolean hasMultipleMasterNodes) {
        return this.isEmpty() ? ImmutableList.of() : DeepStorage.getSupportedUpdates(hasMultipleMasterNodes);
    }

    default public List<Set<UpdateDetails>> getSupportedUpdatesForDiff(Diff<DeepStorage> diff, boolean hasMultipleMasterNodes) {
        return DeepStorage.getSupportedUpdates(hasMultipleMasterNodes);
    }

    public static List<Set<UpdateDetails>> getSupportedUpdates(boolean hasMultipleMasterNodes) {
        return hasMultipleMasterNodes ? ImmutableList.of((Object)ImmutableSet.of((Object)UpdateDetails.hard(10), (Object)UpdateDetails.rolling(999))) : ImmutableList.of((Object)ImmutableSet.of((Object)UpdateDetails.hard(10)));
    }

    public static Map<String, Class<? extends DeepStorage>> getForImplyVersion(ImplyVersion implyVersion, ApplicationConfig applicationConfig, RefreshableConstants refreshableConstants) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        mapBuilder.put((Object)"s3", S3DeepStorage.class);
        if (!applicationConfig.isOnPrem() && !applicationConfig.isSaaS()) {
            return mapBuilder.build();
        }
        mapBuilder.put((Object)"local", LocalDeepStorage.class).put((Object)"hdfs", HdfsDeepStorage.class);
        DruidExtensions extensions = DruidExtensions.getForImplyVersion(implyVersion, refreshableConstants);
        if (extensions == null) {
            return mapBuilder.build();
        }
        if (extensions.getAllExtensions().contains("druid-google-extensions")) {
            mapBuilder.put((Object)"google", GCSDeepStorage.class);
        }
        if (extensions.getAllExtensions().contains("druid-azure-extensions")) {
            mapBuilder.put((Object)"azure", AzureDeepStorage.class);
        }
        return mapBuilder.build();
    }
}

