/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.imply.cloud.model.UpdateType;
import io.imply.cloud.util.ToStringBuilder;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UpdateDetails {
    private final UpdateType type;
    private final Integer estimatedTimeInMinutes;
    private final List<String> displayText;

    @JsonCreator
    public UpdateDetails(@JsonProperty(value="type") UpdateType type, @JsonProperty(value="estimatedTimeInMinutes") Integer estimatedTimeInMinutes, @JsonProperty(value="displayText") List<String> displayText) {
        this.type = type;
        this.estimatedTimeInMinutes = estimatedTimeInMinutes;
        this.displayText = displayText;
    }

    public UpdateDetails(UpdateType type, Integer estimatedTimeInMinutes) {
        this(type, estimatedTimeInMinutes, (List<String>)null);
    }

    public UpdateDetails(UpdateType type, Integer estimatedTimeInMinutes, String displayText) {
        this(type, estimatedTimeInMinutes, (List<String>)(displayText == null ? null : ImmutableList.of((Object)displayText)));
    }

    @JsonProperty
    public UpdateType getType() {
        return this.type;
    }

    @JsonProperty
    public Integer getEstimatedTimeInMinutes() {
        return this.estimatedTimeInMinutes;
    }

    @JsonProperty
    public List<String> getDisplayText() {
        return this.displayText == null ? null : (this.displayText.isEmpty() ? null : this.displayText);
    }

    public UpdateDetails merge(UpdateDetails partialRecord) {
        UpdateType type = partialRecord.type != null ? partialRecord.type : this.type;
        Integer estimatedTimeInMinutes = partialRecord.estimatedTimeInMinutes != null ? partialRecord.estimatedTimeInMinutes : this.estimatedTimeInMinutes;
        List<String> displayText = partialRecord.displayText != null ? partialRecord.displayText : this.displayText;
        return new UpdateDetails(type, estimatedTimeInMinutes, displayText);
    }

    public String toString() {
        return new ToStringBuilder(this).append("type", (Object)this.type).append("estimatedTimeInMinutes", (Object)this.estimatedTimeInMinutes).append("displayText", this.displayText).toString();
    }

    public static UpdateDetails rolling(int estimatedTimeInMinutes) {
        return new UpdateDetails(UpdateType.ROLLING, estimatedTimeInMinutes);
    }

    public static UpdateDetails rolling(int estimatedTimeInMinutes, String displayText) {
        return new UpdateDetails(UpdateType.ROLLING, (Integer)estimatedTimeInMinutes, displayText);
    }

    public static UpdateDetails hard(int estimatedTimeInMinutes) {
        return new UpdateDetails(UpdateType.HARD, estimatedTimeInMinutes);
    }

    public static UpdateDetails hard(int estimatedTimeInMinutes, String displayText) {
        return new UpdateDetails(UpdateType.HARD, (Integer)estimatedTimeInMinutes, displayText);
    }
}

