/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.imply.cloud.Constants;
import io.imply.cloud.config.ApplicationConfig;
import io.imply.cloud.util.Logger;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.joda.time.Period;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum State {
    PENDING(Type.EXTERNAL),
    CREATING(Type.EXTERNAL),
    CREATED(Type.EXTERNAL),
    RUNNING(Type.EXTERNAL),
    STOPPING(Type.EXTERNAL),
    STOPPED(Type.EXTERNAL),
    PAUSING(Type.EXTERNAL),
    PAUSED(Type.EXTERNAL),
    TERMINATING(Type.EXTERNAL),
    TERMINATED(Type.EXTERNAL),
    UPDATING(Type.EXTERNAL),
    FAILED(Type.EXTERNAL),
    UNKNOWN(Type.EXTERNAL),
    STARTING(Type.EXTERNAL),
    READY(Type.EXTERNAL),
    ACCOUNT_INFO_RECEIVED(Type.USER_INITIATED){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)ACCOUNT_CREATION_FAILED), (Object)((Object)ACCOUNT_WITH_NETWORK_STACK_DELETED), (Object)((Object)ACCOUNT_WITH_NETWORK_STACK_DELETED_FAILED), (Object)((Object)ACCOUNT_DELETION_FAILED));
        }

        @Override
        public State getExternalState(State desiredState) {
            return PENDING;
        }
    }
    ,
    ACCOUNT_DELETE_REQUEST_RECEIVED(Type.USER_INITIATED){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)ACCOUNT_CREATED), (Object)((Object)ACCOUNT_CREATION_FAILED), (Object)((Object)ACCOUNT_DELETION_FAILED), (Object)((Object)ACCOUNT_WITH_NETWORK_STACK_DELETED), (Object)((Object)ACCOUNT_WITH_NETWORK_STACK_DELETED_FAILED), (Object)((Object)ACCOUNT_UPDATED), (Object[])new State[]{ACCOUNT_UPDATE_FAILED});
        }

        @Override
        public State getExternalState(State desiredState) {
            return PENDING;
        }
    }
    ,
    CREATING_NETWORK_STACK(Type.TRANSITION){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)ACCOUNT_INFO_RECEIVED));
        }

        @Override
        public State getExternalState(State desiredState) {
            return CREATING;
        }
    }
    ,
    NETWORK_STACK_CREATED(Type.TRANSITION){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)CREATING_NETWORK_STACK));
        }

        @Override
        public State getExternalState(State desiredState) {
            return CREATING;
        }
    }
    ,
    ACCOUNT_CONFIGURED(Type.TRANSITION){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)NETWORK_STACK_CREATED), (Object)((Object)CREATING_NETWORK_STACK));
        }

        @Override
        public State getExternalState(State desiredState) {
            return CREATING;
        }
    }
    ,
    VPC_PEERING_FAILED(Type.TRANSITION){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)NETWORK_STACK_CREATED));
        }

        @Override
        public State getExternalState(State desiredState) {
            return ACCOUNT_CREATED.equals((Object)desiredState) ? FAILED : TERMINATING;
        }
    }
    ,
    VPC_PEERING_CONNECTION_DELETED(Type.TRANSITION){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)VPC_PEERING_FAILED), (Object)((Object)ACCOUNT_DELETE_REQUEST_RECEIVED));
        }

        @Override
        public State getExternalState(State desiredState) {
            return ACCOUNT_CREATED.equals((Object)desiredState) ? FAILED : TERMINATING;
        }
    }
    ,
    DELETING_NETWORK_STACK(Type.TRANSITION){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)CREATING_NETWORK_STACK), (Object)((Object)VPC_PEERING_CONNECTION_DELETED));
        }

        @Override
        public State getExternalState(State desiredState) {
            return ACCOUNT_CREATED.equals((Object)desiredState) ? FAILED : TERMINATING;
        }
    }
    ,
    NETWORK_STACK_DELETED(Type.TRANSITION){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)DELETING_NETWORK_STACK), (Object)((Object)CREATING_NETWORK_STACK), (Object)((Object)VPC_PEERING_CONNECTION_DELETED));
        }

        @Override
        public State getExternalState(State desiredState) {
            return ACCOUNT_CREATED.equals((Object)desiredState) ? FAILED : TERMINATING;
        }
    }
    ,
    ACCOUNT_CREATED(Type.FINAL){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)ACCOUNT_CONFIGURED));
        }

        @Override
        public State getExternalState(State desiredState) {
            return CREATED;
        }
    }
    ,
    ACCOUNT_CREATION_FAILED(Type.FINAL){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)CREATING_NETWORK_STACK), (Object)((Object)DELETING_NETWORK_STACK), (Object)((Object)NETWORK_STACK_DELETED), (Object)((Object)VPC_PEERING_CONNECTION_DELETED));
        }

        @Override
        public State getExternalState(State desiredState) {
            return FAILED;
        }
    }
    ,
    ACCOUNT_UPDATE_REQUEST_RECEIVED(Type.TRANSITION){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)ACCOUNT_CREATED), (Object)((Object)ACCOUNT_UPDATED), (Object)((Object)ACCOUNT_CREATION_FAILED), (Object)((Object)ACCOUNT_UPDATE_FAILED), (Object)((Object)ACCOUNT_WITH_NETWORK_STACK_DELETED));
        }

        @Override
        public State getExternalState(State desiredState) {
            return PENDING;
        }
    }
    ,
    ACCOUNT_UPDATE_IN_PROGRESS(Type.TRANSITION){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)ACCOUNT_UPDATE_REQUEST_RECEIVED));
        }

        @Override
        public State getExternalState(State desiredState) {
            return UPDATING;
        }
    }
    ,
    ACCOUNT_UPDATED(Type.FINAL){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)ACCOUNT_UPDATE_REQUEST_RECEIVED), (Object)((Object)ACCOUNT_UPDATE_IN_PROGRESS));
        }

        @Override
        public State getExternalState(State desiredState) {
            return CREATED;
        }
    }
    ,
    ACCOUNT_UPDATE_FAILED(Type.FINAL){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)ACCOUNT_UPDATE_REQUEST_RECEIVED), (Object)((Object)ACCOUNT_UPDATE_IN_PROGRESS));
        }

        @Override
        public State getExternalState(State desiredState) {
            return FAILED;
        }
    }
    ,
    ACCOUNT_DELETED(Type.FINAL){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)NETWORK_STACK_DELETED));
        }

        @Override
        public State getExternalState(State desiredState) {
            return ACCOUNT_CREATED.equals((Object)desiredState) ? FAILED : TERMINATED;
        }
    }
    ,
    ACCOUNT_WITH_NETWORK_STACK_DELETED(Type.FINAL){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)NETWORK_STACK_DELETED));
        }

        @Override
        public State getExternalState(State desiredState) {
            return STOPPED;
        }
    }
    ,
    ACCOUNT_WITH_NETWORK_STACK_DELETED_FAILED(Type.FINAL){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)VPC_PEERING_CONNECTION_DELETED), (Object)((Object)DELETING_NETWORK_STACK));
        }

        @Override
        public State getExternalState(State desiredState) {
            return FAILED;
        }
    }
    ,
    ACCOUNT_DELETION_FAILED(Type.FINAL){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)VPC_PEERING_CONNECTION_DELETED), (Object)((Object)DELETING_NETWORK_STACK));
        }

        @Override
        public State getExternalState(State desiredState) {
            return FAILED;
        }
    }
    ,
    CLUSTER_INFO_RECEIVED(Type.USER_INITIATED){

        @Override
        public State getExternalState(State desiredState) {
            return CREATING;
        }
    }
    ,
    CLUSTER_DELETE_REQUEST_RECEIVED(Type.USER_INITIATED){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.builder().add((Object)CLUSTER_CREATED).add((Object)CLUSTER_STARTED).add((Object)CLUSTER_STOP_ROLLED_BACK).add((Object)CLUSTER_UPDATED).add((Object)CLUSTER_AGENT_UPDATED).add((Object)CLUSTER_UPDATE_ROLLED_BACK).add((Object)CLUSTER_DELETE_ROLLED_BACK).add((Object)CLUSTER_UPDATE_FAILED).add((Object)CLUSTER_AGENT_UPDATE_FAILED).add((Object)CLUSTER_UPDATE_FAILED_PROMPT_USER).add((Object)CLUSTER_START_REQUEST_RECEIVED).add((Object)CREATE_RDS_SNAPSHOT_REQUEST_RECEIVED).add((Object)CREATING_RDS_SNAPSHOT).add((Object)RDS_SNAPSHOT_CREATED).add((Object)CREATING_CLUSTER_STACK).add((Object)CLUSTER_STACK_CREATED).add((Object)CLUSTER_STACK_FAILED_AND_REQUIRES_DELETION).add((Object)CLUSTER_STAGED_CREATION_IN_PROGRESS).add((Object)CLUSTER_UPDATE_REQUEST_INTERNAL).add((Object)UPDATING_CLUSTER_STACK).add((Object)CLUSTER_STACK_UPDATED).add((Object)CLUSTER_UPDATE_REVERT_SPEC_THEN_SET_ROLLED_BACK).add((Object)CLUSTER_UPDATE_REVERT_SPEC_THEN_REQUEST_CF_ROLLBACK).add((Object)CLUSTER_UPDATE_REVERT_SPEC_THEN_SET_FAILED).add((Object)CLUSTER_UPDATE_ROLLBACK_STACK).add((Object)CLUSTER_UPDATE_ROLLING_BACK_STACK).add((Object)CLUSTER_UPDATE_ROLLED_BACK_STACK).add((Object)CLUSTER_ROLLING_UPDATE_IN_PROGRESS).add((Object)PLAN_KUBERNETES_STATEFULSET_ROLLING_UPDATE).add((Object)KUBERNETES_STATEFULSET_ROLLING_UPDATE).add((Object)CLUSTER_AGENT_UPDATE_IN_PROGRESS).add((Object)CLUSTER_ROLLING_UPDATE_COMPLETE).add((Object)PLAN_CLUSTER_CREATION).add((Object)PLAN_CLUSTER_UPDATE).add((Object)CLUSTER_STAGED_CREATION_IN_PROGRESS).add((Object)CLUSTER_STAGED_CREATION_COMPLETE).add((Object)CLUSTER_STAGED_CREATION_FAILED).add((Object)CLUSTER_INFO_RECEIVED).add((Object)CLUSTER_CREATION_FAILED).add((Object)CLUSTER_DELETE_FAILED).add((Object)CLUSTER_STOPPED).add((Object)CLUSTER_PAUSED).add((Object)CLUSTER_STOP_FAILED).add((Object)CLUSTER_PAUSE_FAILED).add((Object)CLUSTER_START_FAILED).add((Object)CRUD_CLUSTER_MONITORING_STACK).add((Object)CRUDING_CLUSTER_MONITORING_STACK).add((Object)RDS_UPDATE_FAILED).add((Object)RDS_UPDATED).build();
        }

        @Override
        public State getExternalState(State desiredState) {
            return PENDING;
        }
    }
    ,
    CLUSTER_DELETE_REQUEST_INTERNAL(Type.TRANSITION){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)CLUSTER_STOP_REQUEST_RECEIVED), (Object)((Object)CLUSTER_UPDATE_REQUEST_RECEIVED), (Object)((Object)CLUSTER_DELETE_REQUEST_RECEIVED), (Object)((Object)CLUSTER_RESTART_REQUEST_RECEIVED));
        }

        @Override
        public State getExternalState(State desiredState) {
            if (desiredState == null) {
                return UNKNOWN;
            }
            switch (desiredState) {
                case CLUSTER_UPDATED: {
                    return UPDATING;
                }
                case CLUSTER_PAUSED: {
                    return PAUSING;
                }
            }
            return STOPPING;
        }
    }
    ,
    CLUSTER_STOP_REQUEST_RECEIVED(Type.USER_INITIATED){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.builder().add((Object)CLUSTER_CREATED).add((Object)CLUSTER_STARTED).add((Object)CLUSTER_STOP_ROLLED_BACK).add((Object)CLUSTER_UPDATED).add((Object)CLUSTER_PAUSED).add((Object)CLUSTER_AGENT_UPDATED).add((Object)CLUSTER_UPDATE_ROLLED_BACK).add((Object)CLUSTER_DELETE_ROLLED_BACK).add((Object)CLUSTER_UPDATE_FAILED).add((Object)CLUSTER_AGENT_UPDATE_FAILED).add((Object)CLUSTER_UPDATE_FAILED_PROMPT_USER).add((Object)CLUSTER_START_REQUEST_RECEIVED).add((Object)CREATE_RDS_SNAPSHOT_REQUEST_RECEIVED).add((Object)CREATING_RDS_SNAPSHOT).add((Object)RDS_SNAPSHOT_CREATED).add((Object)CREATING_CLUSTER_STACK).add((Object)CLUSTER_STACK_CREATED).add((Object)CLUSTER_STACK_FAILED_AND_REQUIRES_DELETION).add((Object)CLUSTER_STAGED_CREATION_IN_PROGRESS).add((Object)CLUSTER_UPDATE_REQUEST_INTERNAL).add((Object)UPDATING_CLUSTER_STACK).add((Object)CLUSTER_STACK_UPDATED).add((Object)CLUSTER_UPDATE_REVERT_SPEC_THEN_SET_ROLLED_BACK).add((Object)CLUSTER_UPDATE_REVERT_SPEC_THEN_REQUEST_CF_ROLLBACK).add((Object)CLUSTER_UPDATE_REVERT_SPEC_THEN_SET_FAILED).add((Object)CLUSTER_UPDATE_ROLLBACK_STACK).add((Object)CLUSTER_UPDATE_ROLLING_BACK_STACK).add((Object)CLUSTER_UPDATE_ROLLED_BACK_STACK).add((Object)CLUSTER_ROLLING_UPDATE_IN_PROGRESS).add((Object)PLAN_KUBERNETES_STATEFULSET_ROLLING_UPDATE).add((Object)KUBERNETES_STATEFULSET_ROLLING_UPDATE).add((Object)CLUSTER_AGENT_UPDATE_IN_PROGRESS).add((Object)CLUSTER_ROLLING_UPDATE_COMPLETE).add((Object)PLAN_CLUSTER_CREATION).add((Object)PLAN_CLUSTER_UPDATE).add((Object)CLUSTER_STAGED_CREATION_IN_PROGRESS).add((Object)CLUSTER_STAGED_CREATION_COMPLETE).add((Object)CLUSTER_STAGED_CREATION_FAILED).add((Object)CRUD_CLUSTER_MONITORING_STACK).add((Object)CRUDING_CLUSTER_MONITORING_STACK).add((Object)RDS_UPDATE_FAILED).add((Object)RDS_UPDATED).build();
        }

        @Override
        public State getExternalState(State desiredState) {
            if (desiredState == CLUSTER_PAUSED) {
                return PAUSING;
            }
            return STOPPING;
        }
    }
    ,
    CLUSTER_START_REQUEST_RECEIVED(Type.USER_INITIATED){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)CLUSTER_CREATION_FAILED), (Object)((Object)CLUSTER_DELETE_FAILED), (Object)((Object)CLUSTER_STOPPED), (Object)((Object)CLUSTER_PAUSED), (Object)((Object)CLUSTER_STOP_FAILED), (Object)((Object)CLUSTER_PAUSE_FAILED), (Object[])new State[]{CLUSTER_START_FAILED, CLUSTER_UPDATE_FAILED});
        }

        @Override
        public State getExternalState(State desiredState) {
            return STARTING;
        }
    }
    ,
    CREATE_CLUSTER_STACK(Type.TRANSITION){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)CLUSTER_START_REQUEST_RECEIVED), (Object)((Object)CLUSTER_INFO_RECEIVED));
        }

        @Override
        public State getExternalState(State desiredState) {
            return CLUSTER_STARTED.equals((Object)desiredState) ? STARTING : CREATING;
        }
    }
    ,
    CREATE_RDS_SNAPSHOT_REQUEST_RECEIVED(Type.TRANSITION){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)CLUSTER_STOP_REQUEST_RECEIVED), (Object)((Object)CLUSTER_UPDATE_REQUEST_RECEIVED), (Object)((Object)CLUSTER_DELETE_REQUEST_RECEIVED), (Object)((Object)CLUSTER_RESTART_REQUEST_RECEIVED));
        }

        @Override
        public State getExternalState(State desiredState) {
            if (desiredState == null) {
                return UNKNOWN;
            }
            switch (desiredState) {
                case CLUSTER_UPDATED: {
                    return UPDATING;
                }
            }
            return STOPPING;
        }
    }
    ,
    CREATING_RDS_SNAPSHOT(Type.TRANSITION){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)CREATE_RDS_SNAPSHOT_REQUEST_RECEIVED));
        }

        @Override
        public State getExternalState(State desiredState) {
            if (desiredState == null) {
                return UNKNOWN;
            }
            switch (desiredState) {
                case CLUSTER_UPDATED: {
                    return UPDATING;
                }
            }
            return STOPPING;
        }
    }
    ,
    RDS_SNAPSHOT_CREATED(Type.TRANSITION){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)CREATE_RDS_SNAPSHOT_REQUEST_RECEIVED), (Object)((Object)CREATING_RDS_SNAPSHOT), (Object)((Object)CLUSTER_RETRY_UPDATE_REQUEST_RECEIVED));
        }

        @Override
        public State getExternalState(State desiredState) {
            if (desiredState == null) {
                return UNKNOWN;
            }
            switch (desiredState) {
                case CLUSTER_UPDATED: {
                    return UPDATING;
                }
            }
            return STOPPING;
        }
    }
    ,
    CREATING_CLUSTER_STACK(Type.TRANSITION){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)CLUSTER_INFO_RECEIVED), (Object)((Object)CREATE_CLUSTER_STACK), (Object)((Object)CLUSTER_STACK_DELETED));
        }

        @Override
        public State getExternalState(State desiredState) {
            if (desiredState == null) {
                return UNKNOWN;
            }
            switch (desiredState) {
                case CLUSTER_STARTED: {
                    return STARTING;
                }
                case CLUSTER_UPDATED: {
                    return UPDATING;
                }
            }
            return CREATING;
        }
    }
    ,
    CLUSTER_STACK_CREATED(Type.TRANSITION){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)CREATING_CLUSTER_STACK), (Object)((Object)CRUD_CLUSTER_MONITORING_STACK), (Object)((Object)CRUDING_CLUSTER_MONITORING_STACK), (Object)((Object)CLUSTER_MONITORING_STACK_FAILED_AND_REQUIRES_DELETION));
        }

        @Override
        public State getExternalState(State desiredState) {
            if (desiredState == null) {
                return UNKNOWN;
            }
            switch (desiredState) {
                case CLUSTER_STARTED: {
                    return STARTING;
                }
                case CLUSTER_UPDATED: {
                    return UPDATING;
                }
            }
            return CREATING;
        }
    }
    ,
    DELETING_CLUSTER_STACK(Type.TRANSITION){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)CREATING_CLUSTER_STACK), (Object)((Object)CLUSTER_DELETE_REQUEST_RECEIVED), (Object)((Object)RDS_SNAPSHOT_CREATED), (Object)((Object)CLUSTER_DELETE_REQUEST_INTERNAL));
        }

        @Override
        public State getExternalState(State desiredState) {
            if (desiredState == null) {
                return UNKNOWN;
            }
            switch (desiredState) {
                case CLUSTER_CREATED: {
                    return CREATING;
                }
                case CLUSTER_STOPPED: {
                    return STOPPING;
                }
                case CLUSTER_PAUSED: {
                    return PAUSING;
                }
                case CLUSTER_STARTED: {
                    return STARTING;
                }
                case CLUSTER_UPDATED: {
                    return UPDATING;
                }
            }
            return TERMINATING;
        }
    }
    ,
    CLUSTER_STACK_DELETED(Type.TRANSITION){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)CREATING_CLUSTER_STACK), (Object)((Object)DELETING_CLUSTER_STACK), (Object)((Object)CLUSTER_DELETE_REQUEST_INTERNAL), (Object)((Object)CLUSTER_DELETE_REQUEST_RECEIVED), (Object)((Object)RDS_SNAPSHOT_CREATED), (Object)((Object)UPDATING_CLUSTER_STACK), (Object[])new State[]{CRUD_CLUSTER_MONITORING_STACK, CRUDING_CLUSTER_MONITORING_STACK, CLUSTER_MONITORING_STACK_FAILED_AND_REQUIRES_DELETION});
        }

        @Override
        public State getExternalState(State desiredState) {
            if (desiredState == null) {
                return UNKNOWN;
            }
            switch (desiredState) {
                case CLUSTER_CREATED: {
                    return CREATING;
                }
                case CLUSTER_STOPPED: {
                    return STOPPING;
                }
                case CLUSTER_PAUSED: {
                    return PAUSING;
                }
                case CLUSTER_STARTED: {
                    return STARTING;
                }
                case CLUSTER_UPDATED: {
                    return UPDATING;
                }
            }
            return TERMINATING;
        }
    }
    ,
    CLUSTER_CREATED(Type.FINAL){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)CLUSTER_STACK_CREATED), (Object)((Object)CLUSTER_STAGED_CREATION_COMPLETE));
        }

        @Override
        public State getExternalState(State desiredState) {
            return RUNNING;
        }
    }
    ,
    CLUSTER_STACK_FAILED_AND_REQUIRES_DELETION(Type.TRANSITION){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)CREATING_CLUSTER_STACK), (Object)((Object)DELETING_CLUSTER_STACK), (Object)((Object)CLUSTER_DELETE_REQUEST_RECEIVED), (Object)((Object)RDS_SNAPSHOT_CREATED), (Object)((Object)UPDATING_CLUSTER_STACK));
        }

        @Override
        public State getExceptionState(State desiredState) {
            switch (desiredState) {
                case CLUSTER_CREATED: {
                    return CLUSTER_STAGED_CREATION_FAILED;
                }
                case CLUSTER_DELETED: {
                    return CLUSTER_DELETE_FAILED;
                }
                case CLUSTER_STOPPED: {
                    return CLUSTER_STOP_FAILED;
                }
                case CLUSTER_PAUSED: {
                    return CLUSTER_PAUSE_FAILED;
                }
                case CLUSTER_STARTED: {
                    return CLUSTER_STAGED_CREATION_FAILED;
                }
                case CLUSTER_UPDATED: 
                case CLUSTER_UPDATE_ROLLED_BACK: {
                    return CLUSTER_UPDATE_REVERT_SPEC_THEN_SET_FAILED;
                }
            }
            return FAILED;
        }

        @Override
        public State getExternalState(State desiredState) {
            if (desiredState == null) {
                return UNKNOWN;
            }
            switch (desiredState) {
                case CLUSTER_CREATED: {
                    return CREATING;
                }
                case CLUSTER_STOPPED: {
                    return STOPPING;
                }
                case CLUSTER_PAUSED: {
                    return PAUSING;
                }
                case CLUSTER_STARTED: {
                    return STARTING;
                }
                case CLUSTER_UPDATED: {
                    return UPDATING;
                }
            }
            return TERMINATING;
        }
    }
    ,
    CLUSTER_CREATION_FAILED(Type.FINAL){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)CLUSTER_INFO_RECEIVED), (Object)((Object)CREATING_CLUSTER_STACK), (Object)((Object)CLUSTER_STACK_FAILED_AND_REQUIRES_DELETION), (Object)((Object)CLUSTER_STACK_DELETED), (Object)((Object)CLUSTER_STAGED_CREATION_FAILED), (Object)((Object)CRUD_CLUSTER_MONITORING_STACK), (Object[])new State[]{CRUDING_CLUSTER_MONITORING_STACK, CLUSTER_MONITORING_STACK_FAILED_AND_REQUIRES_DELETION, CREATE_CLUSTER_STACK});
        }

        @Override
        public State getExternalState(State desiredState) {
            return FAILED;
        }
    }
    ,
    CLUSTER_DELETED(Type.FINAL){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)CLUSTER_STACK_DELETED));
        }

        @Override
        public State getExternalState(State desiredState) {
            return TERMINATED;
        }
    }
    ,
    CLUSTER_DELETE_FAILED(Type.FINAL){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)CLUSTER_STACK_FAILED_AND_REQUIRES_DELETION), (Object)((Object)CRUD_CLUSTER_MONITORING_STACK), (Object)((Object)CRUDING_CLUSTER_MONITORING_STACK), (Object)((Object)CLUSTER_MONITORING_STACK_FAILED_AND_REQUIRES_DELETION));
        }

        @Override
        public State getExternalState(State desiredState) {
            return FAILED;
        }
    }
    ,
    CLUSTER_DELETE_ROLLED_BACK(Type.FINAL){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)CLUSTER_DELETE_REQUEST_RECEIVED), (Object)((Object)CREATE_RDS_SNAPSHOT_REQUEST_RECEIVED), (Object)((Object)CREATING_RDS_SNAPSHOT));
        }

        @Override
        public State getExternalState(State desiredState) {
            return RUNNING;
        }
    }
    ,
    CLUSTER_PAUSED(Type.FINAL){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)CLUSTER_STACK_DELETED));
        }

        @Override
        public State getExternalState(State desiredState) {
            return PAUSED;
        }
    }
    ,
    CLUSTER_STOPPED(Type.FINAL){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)CLUSTER_STACK_DELETED));
        }

        @Override
        public State getExternalState(State desiredState) {
            return STOPPED;
        }
    }
    ,
    CLUSTER_STOP_ROLLED_BACK(Type.FINAL){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)CREATE_RDS_SNAPSHOT_REQUEST_RECEIVED), (Object)((Object)CREATING_RDS_SNAPSHOT));
        }

        @Override
        public State getExternalState(State desiredState) {
            return RUNNING;
        }
    }
    ,
    CLUSTER_PAUSE_FAILED(Type.FINAL){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)CLUSTER_STACK_FAILED_AND_REQUIRES_DELETION));
        }

        @Override
        public State getExternalState(State desiredState) {
            return FAILED;
        }
    }
    ,
    CLUSTER_STOP_FAILED(Type.FINAL){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)CLUSTER_STACK_FAILED_AND_REQUIRES_DELETION), (Object)((Object)CRUD_CLUSTER_MONITORING_STACK), (Object)((Object)CRUDING_CLUSTER_MONITORING_STACK), (Object)((Object)CLUSTER_MONITORING_STACK_FAILED_AND_REQUIRES_DELETION));
        }

        @Override
        public State getExternalState(State desiredState) {
            return FAILED;
        }
    }
    ,
    CLUSTER_STARTED(Type.FINAL){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)CLUSTER_STACK_CREATED), (Object)((Object)CLUSTER_STAGED_CREATION_COMPLETE));
        }

        @Override
        public State getExternalState(State desiredState) {
            return RUNNING;
        }
    }
    ,
    CLUSTER_START_FAILED(Type.FINAL){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)CREATING_CLUSTER_STACK), (Object)((Object)CLUSTER_START_REQUEST_RECEIVED), (Object)((Object)CLUSTER_STACK_FAILED_AND_REQUIRES_DELETION), (Object)((Object)CLUSTER_STACK_DELETED), (Object)((Object)CRUD_CLUSTER_MONITORING_STACK), (Object)((Object)CRUDING_CLUSTER_MONITORING_STACK), (Object[])new State[]{CLUSTER_MONITORING_STACK_FAILED_AND_REQUIRES_DELETION, CREATE_CLUSTER_STACK});
        }

        @Override
        public State getExternalState(State desiredState) {
            return FAILED;
        }
    }
    ,
    CLUSTER_RESTART_REQUEST_RECEIVED(Type.USER_INITIATED){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)CLUSTER_CREATED), (Object)((Object)CLUSTER_DELETE_ROLLED_BACK), (Object)((Object)CLUSTER_STOP_ROLLED_BACK), (Object)((Object)CLUSTER_STARTED), (Object)((Object)CLUSTER_UPDATED), (Object)((Object)CLUSTER_AGENT_UPDATED), (Object[])new State[]{CLUSTER_UPDATE_FAILED, CLUSTER_AGENT_UPDATE_FAILED, CLUSTER_UPDATE_ROLLED_BACK, CLUSTER_UPDATE_FAILED_PROMPT_USER, RDS_UPDATE_FAILED, RDS_UPDATED});
        }

        @Override
        public State getExternalState(State desiredState) {
            return UPDATING;
        }
    }
    ,
    CLUSTER_UPDATE_REQUEST_RECEIVED(Type.USER_INITIATED){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)CLUSTER_CREATED), (Object)((Object)CLUSTER_CREATION_FAILED), (Object)((Object)CLUSTER_DELETE_FAILED), (Object)((Object)CLUSTER_DELETE_ROLLED_BACK), (Object)((Object)CLUSTER_STOPPED), (Object)((Object)CLUSTER_PAUSED), (Object[])new State[]{CLUSTER_STOP_FAILED, CLUSTER_PAUSE_FAILED, CLUSTER_STOP_ROLLED_BACK, CLUSTER_STARTED, CLUSTER_START_FAILED, CLUSTER_UPDATED, CLUSTER_AGENT_UPDATED, CLUSTER_UPDATE_FAILED, CLUSTER_AGENT_UPDATE_FAILED, CLUSTER_UPDATE_ROLLED_BACK, CLUSTER_UPDATE_FAILED_PROMPT_USER, CLUSTER_RETRY_UPDATE_REQUEST_RECEIVED, RDS_UPDATE_FAILED, RDS_UPDATED});
        }

        @Override
        public State getExternalState(State desiredState) {
            return UPDATING;
        }
    }
    ,
    CLUSTER_UPDATE_REQUEST_INTERNAL(Type.TRANSITION){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)CLUSTER_RETRY_UPDATE_REQUEST_RECEIVED), (Object)((Object)CLUSTER_UPDATE_REQUEST_RECEIVED), (Object)((Object)CLUSTER_UPDATE_ROLLBACK_STACK), (Object)((Object)CLUSTER_RESTART_REQUEST_RECEIVED));
        }

        @Override
        public State getExternalState(State desiredState) {
            return UPDATING;
        }
    }
    ,
    UPDATING_CLUSTER_STACK(Type.TRANSITION){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)RDS_SNAPSHOT_CREATED), (Object)((Object)CLUSTER_UPDATE_REQUEST_RECEIVED), (Object)((Object)CLUSTER_UPDATE_REQUEST_INTERNAL), (Object)((Object)KUBERNETES_STATEFULSET_ROLLING_UPDATE), (Object)((Object)CLUSTER_RESTART_REQUEST_RECEIVED));
        }

        @Override
        public State getExternalState(State desiredState) {
            return UPDATING;
        }

        @Override
        public Period getTimeoutPeriod(ApplicationConfig applicationConfig) {
            return applicationConfig.isKubernetesMode() ? new Period((Object)"P1W") : super.getTimeoutPeriod(applicationConfig);
        }
    }
    ,
    CLUSTER_STACK_UPDATED(Type.TRANSITION){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)UPDATING_CLUSTER_STACK), (Object)((Object)CLUSTER_UPDATE_ROLLED_BACK_STACK), (Object)((Object)CRUD_CLUSTER_MONITORING_STACK), (Object)((Object)CRUDING_CLUSTER_MONITORING_STACK), (Object)((Object)CLUSTER_MONITORING_STACK_FAILED_AND_REQUIRES_DELETION));
        }

        @Override
        public State getExternalState(State desiredState) {
            return UPDATING;
        }

        @Override
        public Period getTimeoutPeriod(ApplicationConfig applicationConfig) {
            return new Period((Object)"PT20M");
        }
    }
    ,
    CLUSTER_UPDATED(Type.FINAL){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)CLUSTER_ROLLING_UPDATE_COMPLETE));
        }

        @Override
        public State getExternalState(State desiredState) {
            return RUNNING;
        }
    }
    ,
    CLUSTER_UPDATE_REVERT_SPEC_THEN_SET_ROLLED_BACK(Type.TRANSITION){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)CLUSTER_UPDATE_REQUEST_RECEIVED), (Object)((Object)CREATE_RDS_SNAPSHOT_REQUEST_RECEIVED), (Object)((Object)CREATING_RDS_SNAPSHOT), (Object)((Object)RDS_SNAPSHOT_CREATED), (Object)((Object)UPDATING_CLUSTER_STACK), (Object)((Object)CLUSTER_ROLLBACK_UPDATE_REQUEST_RECEIVED), (Object[])new State[]{CLUSTER_CANCEL_UPDATE_WITH_ROLLBACK_REQUEST_RECEIVED, CLUSTER_RESTART_REQUEST_RECEIVED});
        }

        @Override
        public State getExternalState(State desiredState) {
            return UPDATING;
        }
    }
    ,
    CLUSTER_UPDATE_REVERT_SPEC_THEN_REQUEST_CF_ROLLBACK(Type.TRANSITION){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)CLUSTER_UPDATE_FAILED_PROMPT_USER), (Object)((Object)CLUSTER_STACK_UPDATED), (Object)((Object)CLUSTER_ROLLING_UPDATE_IN_PROGRESS), (Object)((Object)CLUSTER_ROLLBACK_UPDATE_REQUEST_RECEIVED), (Object)((Object)CLUSTER_CANCEL_UPDATE_WITH_ROLLBACK_REQUEST_RECEIVED));
        }

        @Override
        public State getExternalState(State desiredState) {
            return UPDATING;
        }
    }
    ,
    CLUSTER_UPDATE_REVERT_SPEC_THEN_SET_FAILED(Type.TRANSITION){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)CLUSTER_STACK_DELETED), (Object)((Object)CLUSTER_STACK_FAILED_AND_REQUIRES_DELETION), (Object)((Object)CRUD_CLUSTER_MONITORING_STACK), (Object)((Object)CRUDING_CLUSTER_MONITORING_STACK), (Object)((Object)CLUSTER_MONITORING_STACK_FAILED_AND_REQUIRES_DELETION));
        }

        @Override
        public State getExternalState(State desiredState) {
            return UPDATING;
        }
    }
    ,
    CLUSTER_UPDATE_ROLLED_BACK(Type.FINAL){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)CLUSTER_UPDATE_REVERT_SPEC_THEN_SET_ROLLED_BACK), (Object)((Object)CLUSTER_UPDATE_ROLLED_BACK_STACK), (Object)((Object)CLUSTER_ROLLING_UPDATE_COMPLETE), (Object)((Object)CLUSTER_AGENT_CANCEL_UPDATE));
        }

        @Override
        public State getExternalState(State desiredState) {
            return RUNNING;
        }
    }
    ,
    CLUSTER_UPDATE_FAILED(Type.FINAL){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)CLUSTER_UPDATE_FAILED_PROMPT_USER), (Object)((Object)CLUSTER_UPDATE_REVERT_SPEC_THEN_SET_FAILED), (Object)((Object)CLUSTER_UPDATE_ROLLBACK_STACK), (Object)((Object)CLUSTER_UPDATE_ROLLING_BACK_STACK));
        }

        @Override
        public State getExternalState(State desiredState) {
            return RUNNING;
        }
    }
    ,
    CLUSTER_UPDATE_ROLLBACK_STACK(Type.TRANSITION){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)CLUSTER_UPDATE_REVERT_SPEC_THEN_REQUEST_CF_ROLLBACK));
        }

        @Override
        public State getExternalState(State desiredState) {
            return UPDATING;
        }
    }
    ,
    CLUSTER_UPDATE_ROLLING_BACK_STACK(Type.TRANSITION){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)CLUSTER_UPDATE_ROLLBACK_STACK));
        }

        @Override
        public State getExternalState(State desiredState) {
            return UPDATING;
        }
    }
    ,
    CLUSTER_UPDATE_ROLLED_BACK_STACK(Type.TRANSITION){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)CLUSTER_UPDATE_ROLLING_BACK_STACK));
        }

        @Override
        public State getExternalState(State desiredState) {
            return UPDATING;
        }
    }
    ,
    CLUSTER_ROLLING_UPDATE_IN_PROGRESS(Type.TRANSITION){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)CLUSTER_STACK_UPDATED), (Object)((Object)CLUSTER_UPDATE_FAILED_PROMPT_USER), (Object)((Object)CLUSTER_RETRY_UPDATE_REQUEST_RECEIVED), (Object)((Object)PLAN_CLUSTER_UPDATE));
        }

        @Override
        public State getExternalState(State desiredState) {
            return UPDATING;
        }

        @Override
        public Period getTimeoutPeriod(ApplicationConfig applicationConfig) {
            return new Period((Object)"P1M");
        }
    }
    ,
    PLAN_KUBERNETES_STATEFULSET_ROLLING_UPDATE(Type.TRANSITION){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)CLUSTER_UPDATE_REQUEST_INTERNAL));
        }

        @Override
        public State getExternalState(State desiredState) {
            return UPDATING;
        }

        @Override
        public Period getTimeoutPeriod(ApplicationConfig applicationConfig) {
            return new Period((Object)"P1W");
        }
    }
    ,
    KUBERNETES_STATEFULSET_ROLLING_UPDATE(Type.TRANSITION){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)PLAN_KUBERNETES_STATEFULSET_ROLLING_UPDATE));
        }

        @Override
        public State getExternalState(State desiredState) {
            return UPDATING;
        }

        @Override
        public Period getTimeoutPeriod(ApplicationConfig applicationConfig) {
            return new Period((Object)"P1W");
        }
    }
    ,
    CLUSTER_ROLLING_UPDATE_COMPLETE(Type.TRANSITION){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)CLUSTER_ROLLING_UPDATE_IN_PROGRESS));
        }

        @Override
        public State getExternalState(State desiredState) {
            return UPDATING;
        }
    }
    ,
    CLUSTER_UPDATE_FAILED_PROMPT_USER(Type.FINAL){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)CLUSTER_ROLLING_UPDATE_IN_PROGRESS), (Object)((Object)KUBERNETES_STATEFULSET_ROLLING_UPDATE), (Object)((Object)CLUSTER_UPDATE_REQUEST_RECEIVED), (Object)((Object)UPDATING_CLUSTER_STACK), (Object)((Object)CLUSTER_CANCEL_UPDATE_WITH_ROLLBACK_REQUEST_RECEIVED), (Object)((Object)RDS_SNAPSHOT_CREATED), (Object[])new State[]{CLUSTER_RESTART_REQUEST_RECEIVED});
        }

        @Override
        public State getExternalState(State desiredState) {
            return UPDATING;
        }
    }
    ,
    CLUSTER_RETRY_UPDATE_REQUEST_RECEIVED(Type.USER_INITIATED){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)CLUSTER_UPDATE_FAILED_PROMPT_USER));
        }

        @Override
        public State getExternalState(State desiredState) {
            return PENDING;
        }
    }
    ,
    CLUSTER_ROLLBACK_UPDATE_REQUEST_RECEIVED(Type.USER_INITIATED){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)CLUSTER_UPDATE_FAILED_PROMPT_USER));
        }

        @Override
        public State getExternalState(State desiredState) {
            return PENDING;
        }
    }
    ,
    CLUSTER_CANCEL_UPDATE_WITH_ROLLBACK_REQUEST_RECEIVED(Type.USER_INITIATED){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)CLUSTER_ROLLING_UPDATE_IN_PROGRESS), (Object)((Object)CLUSTER_AGENT_UPDATE_IN_PROGRESS));
        }

        @Override
        public State getExternalState(State desiredState) {
            return PENDING;
        }
    }
    ,
    PLAN_CLUSTER_CREATION(Type.TRANSITION){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)CREATE_CLUSTER_STACK), (Object)((Object)CREATING_CLUSTER_STACK));
        }

        @Override
        public State getExternalState(State desiredState) {
            return CLUSTER_STARTED.equals((Object)desiredState) ? STARTING : CREATING;
        }
    }
    ,
    PLAN_CLUSTER_UPDATE(Type.TRANSITION){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)CLUSTER_UPDATE_REQUEST_RECEIVED), (Object)((Object)UPDATING_CLUSTER_STACK), (Object)((Object)CLUSTER_RESTART_REQUEST_RECEIVED), (Object)((Object)CLUSTER_UPDATE_REQUEST_INTERNAL));
        }

        @Override
        public State getExternalState(State desiredState) {
            return UPDATING;
        }
    }
    ,
    CLUSTER_STAGED_CREATION_IN_PROGRESS(Type.TRANSITION){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)PLAN_CLUSTER_CREATION));
        }

        @Override
        public State getExternalState(State desiredState) {
            return CLUSTER_STARTED.equals((Object)desiredState) ? STARTING : CREATING;
        }

        @Override
        public Period getTimeoutPeriod(ApplicationConfig applicationConfig) {
            return new Period((Object)"P1W");
        }
    }
    ,
    CLUSTER_STAGED_CREATION_COMPLETE(Type.TRANSITION){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)CLUSTER_STAGED_CREATION_IN_PROGRESS), (Object)((Object)PLAN_CLUSTER_CREATION));
        }

        @Override
        public State getExternalState(State desiredState) {
            return CLUSTER_STARTED.equals((Object)desiredState) ? STARTING : CREATING;
        }
    }
    ,
    CLUSTER_STAGED_CREATION_FAILED(Type.TRANSITION){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)CLUSTER_STACK_FAILED_AND_REQUIRES_DELETION));
        }

        @Override
        public State getExternalState(State desiredState) {
            return CLUSTER_STARTED.equals((Object)desiredState) ? STARTING : CREATING;
        }
    }
    ,
    PLAN_CLUSTER_AGENT_UPDATE(Type.USER_INITIATED){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)CLUSTER_CREATED), (Object)((Object)CLUSTER_DELETE_ROLLED_BACK), (Object)((Object)CLUSTER_STOP_ROLLED_BACK), (Object)((Object)CLUSTER_STARTED), (Object)((Object)CLUSTER_UPDATED), (Object)((Object)CLUSTER_AGENT_UPDATED), (Object[])new State[]{CLUSTER_AGENT_UPDATE_FAILED, CLUSTER_UPDATE_ROLLED_BACK, CLUSTER_UPDATE_FAILED});
        }

        @Override
        public State getExternalState(State desiredState) {
            return PENDING;
        }
    }
    ,
    CLUSTER_AGENT_UPDATE_IN_PROGRESS(Type.TRANSITION){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)PLAN_CLUSTER_AGENT_UPDATE));
        }

        @Override
        public State getExternalState(State desiredState) {
            return UPDATING;
        }
    }
    ,
    CLUSTER_AGENT_CANCEL_UPDATE(Type.USER_INITIATED){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)CLUSTER_AGENT_UPDATE_IN_PROGRESS));
        }

        @Override
        public State getExternalState(State desiredState) {
            return PENDING;
        }
    }
    ,
    CLUSTER_AGENT_UPDATE_FAILED(Type.FINAL){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)PLAN_CLUSTER_AGENT_UPDATE), (Object)((Object)CLUSTER_AGENT_UPDATE_IN_PROGRESS));
        }

        @Override
        public State getExternalState(State desiredState) {
            return RUNNING;
        }
    }
    ,
    CLUSTER_AGENT_UPDATED(Type.FINAL){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)PLAN_CLUSTER_AGENT_UPDATE), (Object)((Object)CLUSTER_AGENT_UPDATE_IN_PROGRESS));
        }

        @Override
        public State getExternalState(State desiredState) {
            return RUNNING;
        }
    }
    ,
    CRUD_CLUSTER_MONITORING_STACK(Type.TRANSITION){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)CREATING_CLUSTER_STACK), (Object)((Object)UPDATING_CLUSTER_STACK), (Object)((Object)DELETING_CLUSTER_STACK), (Object)((Object)RDS_SNAPSHOT_CREATED), (Object)((Object)CLUSTER_DELETE_REQUEST_RECEIVED), (Object)((Object)CLUSTER_DELETE_REQUEST_INTERNAL), (Object[])new State[]{CLUSTER_STACK_FAILED_AND_REQUIRES_DELETION});
        }

        @Override
        public State getNextState(List<State> transitionStateChain, State desiredState) {
            State previousState = this.getPreviousState(transitionStateChain, 1);
            return 78.getNextStateAfterClusterMonitoringStates(desiredState, previousState);
        }

        @Override
        public State getExternalState(State desiredState) {
            return CLUSTER_STARTED.equals((Object)desiredState) ? STARTING : CREATING;
        }
    }
    ,
    CRUDING_CLUSTER_MONITORING_STACK(Type.TRANSITION){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)CRUD_CLUSTER_MONITORING_STACK));
        }

        @Override
        public State getNextState(List<State> transitionStateChain, State desiredState) {
            State previousState = this.getPreviousState(transitionStateChain, 2);
            return 79.getNextStateAfterClusterMonitoringStates(desiredState, previousState);
        }

        @Override
        public State getExternalState(State desiredState) {
            if (desiredState == null) {
                return UNKNOWN;
            }
            switch (desiredState) {
                case CLUSTER_STARTED: {
                    return STARTING;
                }
                case CLUSTER_UPDATED: {
                    return UPDATING;
                }
                case CLUSTER_DELETED: {
                    return TERMINATING;
                }
            }
            return CREATING;
        }
    }
    ,
    CLUSTER_MONITORING_STACK_FAILED_AND_REQUIRES_DELETION(Type.TRANSITION){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)CRUDING_CLUSTER_MONITORING_STACK));
        }

        @Override
        public State getNextState(List<State> transitionStateChain, State desiredState) {
            State previousState = this.getPreviousState(transitionStateChain, 3);
            return 80.getNextStateAfterClusterMonitoringStates(desiredState, previousState);
        }

        @Override
        public State getExternalState(State desiredState) {
            if (desiredState == null) {
                return UNKNOWN;
            }
            switch (desiredState) {
                case CLUSTER_CREATED: {
                    return CREATING;
                }
                case CLUSTER_STOPPED: {
                    return STOPPING;
                }
                case CLUSTER_PAUSED: {
                    return PAUSING;
                }
                case CLUSTER_STARTED: {
                    return STARTING;
                }
                case CLUSTER_UPDATED: {
                    return UPDATING;
                }
            }
            return TERMINATING;
        }
    }
    ,
    PLAN_RDS_UPDATE(Type.USER_INITIATED){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)CLUSTER_CREATED), (Object)((Object)CLUSTER_DELETE_ROLLED_BACK), (Object)((Object)CLUSTER_STOP_ROLLED_BACK), (Object)((Object)CLUSTER_STARTED), (Object)((Object)CLUSTER_UPDATED), (Object)((Object)CLUSTER_UPDATE_ROLLED_BACK), (Object[])new State[]{CLUSTER_UPDATE_FAILED, RDS_UPDATE_FAILED, RDS_UPDATED});
        }

        @Override
        public State getExternalState(State desiredState) {
            return UPDATING;
        }
    }
    ,
    RDS_UPDATE_IN_PROGRESS(Type.TRANSITION){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)PLAN_RDS_UPDATE));
        }

        @Override
        public State getExternalState(State desiredState) {
            return UPDATING;
        }

        @Override
        public Period getTimeoutPeriod(ApplicationConfig applicationConfig) {
            return new Period((Object)"P1D");
        }
    }
    ,
    RDS_UPDATE_ROLLBACK(Type.TRANSITION){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)RDS_UPDATE_IN_PROGRESS));
        }

        @Override
        public State getExternalState(State desiredState) {
            return UPDATING;
        }
    }
    ,
    RDS_UPDATE_FAILED(Type.FINAL){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)PLAN_RDS_UPDATE), (Object)((Object)RDS_UPDATE_ROLLBACK));
        }

        @Override
        public State getExternalState(State desiredState) {
            return RUNNING;
        }
    }
    ,
    RDS_UPDATED(Type.FINAL){

        @Override
        public Set<State> getValidPreviousStates() {
            return ImmutableSet.of((Object)((Object)PLAN_RDS_UPDATE), (Object)((Object)RDS_UPDATE_IN_PROGRESS));
        }

        @Override
        public State getExternalState(State desiredState) {
            return RUNNING;
        }
    }
    ,
    CLEAR_FIELD(Type.OTHER);

    @Generated
    private static final Logger log;
    private final Type type;

    public static State getNextStateAfterClusterMonitoringStates(State desiredState, State previousState) {
        State nextState;
        if (FAILED.equals((Object)previousState)) {
            nextState = FAILED;
        } else {
            switch (previousState) {
                case CREATING_CLUSTER_STACK: {
                    nextState = CLUSTER_STACK_CREATED;
                    break;
                }
                case UPDATING_CLUSTER_STACK: {
                    nextState = CLUSTER_STACK_UPDATED;
                    break;
                }
                case DELETING_CLUSTER_STACK: 
                case CLUSTER_DELETE_REQUEST_RECEIVED: 
                case CLUSTER_DELETE_REQUEST_INTERNAL: {
                    nextState = CLUSTER_STACK_DELETED;
                    break;
                }
                case RDS_SNAPSHOT_CREATED: {
                    if (ImmutableList.of((Object)((Object)CLUSTER_DELETED), (Object)((Object)CLUSTER_STOPPED)).contains((Object)desiredState)) {
                        nextState = CLUSTER_STACK_DELETED;
                        break;
                    }
                    log.error("unexpected desired state '%s' for previous state RDS_SNAPSHOT_CREATED", new Object[]{desiredState});
                    nextState = FAILED;
                    break;
                }
                case CLUSTER_STACK_FAILED_AND_REQUIRES_DELETION: {
                    nextState = CLUSTER_STACK_FAILED_AND_REQUIRES_DELETION.getExceptionState(desiredState);
                    if (!FAILED.equals((Object)nextState)) break;
                    log.error("unexpected desired state '%s' for previous state CLUSTER_STACK_FAILED_AND_REQUIRES_DELETION", new Object[]{desiredState});
                    break;
                }
                default: {
                    log.error("unexpected previous state '%s'", new Object[]{previousState});
                    nextState = FAILED;
                }
            }
        }
        if (FAILED.equals((Object)nextState)) {
            return State.getNextStateForFailedStateForClusterMonitoringStates(desiredState);
        }
        return nextState;
    }

    public static State getNextStateForFailedStateForClusterMonitoringStates(State desiredState) {
        switch (desiredState) {
            case CLUSTER_STARTED: 
            case CLUSTER_CREATED: {
                return CLUSTER_STAGED_CREATION_FAILED;
            }
            case CLUSTER_DELETED: {
                return CLUSTER_DELETE_FAILED;
            }
            case CLUSTER_STOPPED: {
                return CLUSTER_STOP_FAILED;
            }
            case CLUSTER_PAUSED: {
                return CLUSTER_PAUSE_FAILED;
            }
            case CLUSTER_UPDATED: 
            case CLUSTER_UPDATE_ROLLED_BACK: {
                return CLUSTER_UPDATE_FAILED;
            }
        }
        return FAILED;
    }

    private State(Type type) {
        this.type = type;
    }

    public boolean isUserInitiated() {
        return Type.USER_INITIATED.equals((Object)this.type);
    }

    public boolean isExternalState() {
        return Type.EXTERNAL.equals((Object)this.type);
    }

    public boolean isFinalState() {
        return Type.FINAL.equals((Object)this.type);
    }

    public boolean isTransitionState() {
        return Type.TRANSITION.equals((Object)this.type);
    }

    public boolean isRunning() {
        return ImmutableList.of((Object)((Object)RUNNING), (Object)((Object)UPDATING)).contains((Object)this.getExternalState(null));
    }

    public boolean isStoppedTerminatedOrFailed() {
        return ImmutableList.of((Object)((Object)STOPPED), (Object)((Object)TERMINATED), (Object)((Object)FAILED), (Object)((Object)PAUSED)).contains((Object)this.getExternalState(null));
    }

    public boolean isCreatingStartingOrUpdating() {
        return CREATING.equals((Object)this.getExternalState(CLUSTER_CREATED)) || STARTING.equals((Object)this.getExternalState(CLUSTER_STARTED)) || UPDATING.equals((Object)this.getExternalState(CLUSTER_UPDATED));
    }

    public boolean isTerminated() {
        return TERMINATED.equals((Object)this.getExternalState(null));
    }

    public boolean isFailed() {
        return FAILED.equals((Object)this.getExternalState(null));
    }

    public Set<State> getValidPreviousStates() {
        return ImmutableSet.of();
    }

    public State getNextState(List<State> transitionStateChain, State desiredState) {
        throw new UnsupportedOperationException("getNextState not defined");
    }

    protected State getPreviousState(List<State> transitionStateChain, int numStatesBack) {
        int previousStateReverseIndex = numStatesBack + 1;
        if (transitionStateChain == null || transitionStateChain.size() < previousStateReverseIndex) {
            log.error("State transition chain '%s' smaller than minimum size of %d", transitionStateChain, previousStateReverseIndex);
            return FAILED;
        }
        return transitionStateChain.get(transitionStateChain.size() - previousStateReverseIndex);
    }

    public State getExceptionState(State desiredState) {
        throw new UnsupportedOperationException("getExceptionState not defined");
    }

    public State getExternalState(State desiredState) {
        return this;
    }

    public Period getTimeoutPeriod(ApplicationConfig applicationConfig) {
        return Constants.DEFAULT_TRANSITION_STATE_TIMEOUT;
    }

    static {
        log = Logger.from(State.class);
    }

    private static enum Type {
        USER_INITIATED,
        TRANSITION,
        FINAL,
        EXTERNAL,
        OTHER;

    }
}

