/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model;

import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang3.StringUtils;

public enum ServiceType {
    COMMON("common", "COM", "Common"),
    BROKER("broker", "BKR", "Broker"),
    COORDINATOR("coordinator", "COR", "Coordinator"),
    HISTORICAL("historical", "HIS", "Historical"),
    MIDDLE_MANAGER("middleManager", "MM", "Middle Manager"),
    INDEXER("indexer", "IDX", "Indexer"),
    OVERLORD("overlord", "OVR", "Overlord"),
    ROUTER("router", "ROU", "Router"),
    PIVOT("pivot", "PIV", "Pivot"),
    PEON("peon", "PEON", "Peon"),
    COLD_BROKER("coldBroker", "CBK", "Cold Broker"),
    COLD_HISTORICAL("coldHistorical", "CHI", "Cold Historical"),
    NONE(null, null, "Unknown");

    private final String name;
    private final String shortName;
    private final String label;

    private ServiceType(String name, String shortName, String label) {
        this.name = name;
        this.shortName = shortName;
        this.label = label;
    }

    @JsonValue
    public String getName() {
        return this.name;
    }

    public String getCustomDruidPropertiesKey() {
        return this.getName();
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getLabel() {
        return this.label;
    }

    public static ServiceType fromString(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return NONE;
        }
        for (ServiceType serviceType : ServiceType.values()) {
            if (!StringUtils.startsWithIgnoreCase((CharSequence)key, (CharSequence)serviceType.getName())) continue;
            return serviceType;
        }
        return NONE;
    }
}

