/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import io.imply.cloud.Constants;
import io.imply.cloud.config.SecurityConfig;
import io.imply.cloud.model.ImplyConstraintViolation;
import io.imply.cloud.model.Mergeable;
import io.imply.cloud.tls.CertAndKeyHolder;
import io.imply.cloud.tls.TLSUtils;
import io.imply.cloud.util.SecurityUtil;
import io.imply.cloud.util.ToStringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SecurityConfiguration
implements Mergeable<SecurityConfiguration> {
    private final byte[] rootCertificate;
    private final byte[] intermediatePrivateKey;
    private final byte[] intermediatePublicKey;
    private final byte[] intermediateCertificate;
    private final List<byte[]> parentIntermediateCertificates;
    private final String keyStorePassword;
    private final String hmacSecret;
    private final String initialDruidAdminPassword;
    private final String dataVolumeEncryptionKey;
    private final String logviewSecret;

    @JsonCreator
    protected SecurityConfiguration(@JsonProperty(value="rootCertificate") byte[] rootCertificate, @JsonProperty(value="intermediatePrivateKey") byte[] intermediatePrivateKey, @JsonProperty(value="intermediatePublicKey") byte[] intermediatePublicKey, @JsonProperty(value="intermediateCertificate") byte[] intermediateCertificate, @JsonProperty(value="parentIntermediateCertificates") List<byte[]> parentIntermediateCertificates, @JsonProperty(value="keyStorePassword") String keyStorePassword, @JsonProperty(value="hmacSecret") String hmacSecret, @JsonProperty(value="initialDruidAdminPassword") String initialDruidAdminPassword, @JsonProperty(value="dataVolumeEncryptionKey") String dataVolumeEncryptionKey, @JsonProperty(value="logviewSecret") String logviewSecret) {
        this.rootCertificate = rootCertificate;
        this.intermediatePrivateKey = intermediatePrivateKey;
        this.intermediatePublicKey = intermediatePublicKey;
        this.intermediateCertificate = intermediateCertificate;
        this.parentIntermediateCertificates = parentIntermediateCertificates;
        this.keyStorePassword = keyStorePassword;
        this.hmacSecret = hmacSecret;
        this.initialDruidAdminPassword = initialDruidAdminPassword;
        this.dataVolumeEncryptionKey = dataVolumeEncryptionKey;
        this.logviewSecret = logviewSecret;
    }

    @JsonProperty
    public byte[] getRootCertificate() {
        return this.rootCertificate;
    }

    @JsonProperty
    public byte[] getIntermediatePrivateKey() {
        return this.intermediatePrivateKey;
    }

    @JsonProperty
    public byte[] getIntermediatePublicKey() {
        return this.intermediatePublicKey;
    }

    @JsonProperty
    public byte[] getIntermediateCertificate() {
        return this.intermediateCertificate;
    }

    @JsonProperty
    public List<byte[]> getParentIntermediateCertificates() {
        return this.parentIntermediateCertificates;
    }

    @JsonProperty
    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    @JsonProperty
    public String getHmacSecret() {
        return this.hmacSecret;
    }

    @JsonProperty
    public String getInitialDruidAdminPassword() {
        return this.initialDruidAdminPassword;
    }

    @JsonProperty
    public String getDataVolumeEncryptionKey() {
        return this.dataVolumeEncryptionKey;
    }

    @JsonProperty
    public String getLogviewSecret() {
        return this.logviewSecret;
    }

    @JsonProperty
    public String getInitialDruidAdminUsername() {
        return "admin";
    }

    @Override
    public SecurityConfiguration mergeDiff(SecurityConfiguration baseConfiguration) {
        String dataVolumeEncryptionKey;
        String initialDruidAdminPassword;
        String hmacSecret;
        String keyStorePassword;
        List<byte[]> parentIntermediateCertificates;
        byte[] intermediateCertificate;
        byte[] intermediatePublicKey;
        byte[] intermediatePrivateKey;
        byte[] rootCertificate;
        if (baseConfiguration == null) {
            return this;
        }
        byte[] byArray = this.rootCertificate == null ? null : (rootCertificate = Arrays.equals(this.rootCertificate, baseConfiguration.rootCertificate) ? null : this.rootCertificate);
        byte[] byArray2 = this.intermediatePrivateKey == null ? null : (intermediatePrivateKey = Arrays.equals(this.intermediatePrivateKey, baseConfiguration.intermediatePrivateKey) ? null : this.intermediatePrivateKey);
        byte[] byArray3 = this.intermediatePublicKey == null ? null : (intermediatePublicKey = Arrays.equals(this.intermediatePublicKey, baseConfiguration.intermediatePublicKey) ? null : this.intermediatePublicKey);
        byte[] byArray4 = this.intermediateCertificate == null ? null : (intermediateCertificate = Arrays.equals(this.intermediateCertificate, baseConfiguration.intermediateCertificate) ? null : this.intermediateCertificate);
        List<byte[]> list = this.parentIntermediateCertificates == null ? null : (parentIntermediateCertificates = this.byteArrayListsEqual(this.parentIntermediateCertificates, baseConfiguration.parentIntermediateCertificates) ? null : this.parentIntermediateCertificates);
        String string = this.keyStorePassword == null ? null : (keyStorePassword = this.keyStorePassword.equals(baseConfiguration.keyStorePassword) ? null : this.keyStorePassword);
        String string2 = this.hmacSecret == null ? null : (hmacSecret = this.hmacSecret.equals(baseConfiguration.hmacSecret) ? null : this.hmacSecret);
        String string3 = this.initialDruidAdminPassword == null ? null : (initialDruidAdminPassword = this.initialDruidAdminPassword.equals(baseConfiguration.initialDruidAdminPassword) ? null : this.initialDruidAdminPassword);
        String string4 = this.dataVolumeEncryptionKey == null ? null : (dataVolumeEncryptionKey = this.dataVolumeEncryptionKey.equals(baseConfiguration.dataVolumeEncryptionKey) ? null : this.dataVolumeEncryptionKey);
        String logviewSecret = this.logviewSecret == null ? null : (this.logviewSecret.equals(baseConfiguration.logviewSecret) ? null : this.logviewSecret);
        return new SecurityConfiguration(rootCertificate, intermediatePrivateKey, intermediatePublicKey, intermediateCertificate, parentIntermediateCertificates, keyStorePassword, hmacSecret, initialDruidAdminPassword, dataVolumeEncryptionKey, logviewSecret);
    }

    public SecurityConfiguration filterNonNullFields(SecurityConfiguration filter) {
        if (filter == null) {
            return new SecurityConfiguration(null, null, null, null, null, null, null, null, null, null);
        }
        byte[] rootCertificate = filter.rootCertificate == null ? null : this.rootCertificate;
        byte[] intermediatePrivateKey = filter.intermediatePrivateKey == null ? null : this.intermediatePrivateKey;
        byte[] intermediatePublicKey = filter.intermediatePublicKey == null ? null : this.intermediatePublicKey;
        byte[] intermediateCertificate = filter.intermediateCertificate == null ? null : this.intermediateCertificate;
        List<byte[]> parentIntermediateCertificates = filter.parentIntermediateCertificates == null ? null : this.parentIntermediateCertificates;
        String keyStorePassword = filter.keyStorePassword == null ? null : this.keyStorePassword;
        String hmacSecret = filter.hmacSecret == null ? null : this.hmacSecret;
        String initialDruidAdminPassword = filter.initialDruidAdminPassword == null ? null : this.initialDruidAdminPassword;
        String dataVolumeEncryptionKey = filter.dataVolumeEncryptionKey == null ? null : this.dataVolumeEncryptionKey;
        String logviewSecret = filter.logviewSecret == null ? null : this.logviewSecret;
        return new SecurityConfiguration(rootCertificate, intermediatePrivateKey, intermediatePublicKey, intermediateCertificate, parentIntermediateCertificates, keyStorePassword, hmacSecret, initialDruidAdminPassword, dataVolumeEncryptionKey, logviewSecret);
    }

    public SecurityConfiguration stripInternalFields() {
        return new SecurityConfiguration(this.rootCertificate, null, null, null, null, null, this.hmacSecret, this.initialDruidAdminPassword, null, this.logviewSecret);
    }

    public SecurityConfiguration withoutNonUpdatableFields() {
        return new SecurityConfiguration(null, null, null, null, null, null, null, null, null, null);
    }

    public void validate(List<ImplyConstraintViolation> results) {
    }

    @Override
    public boolean isEmpty() {
        return this.rootCertificate == null && this.intermediatePrivateKey == null && this.intermediatePublicKey == null && this.intermediateCertificate == null && this.parentIntermediateCertificates == null && this.keyStorePassword == null && this.hmacSecret == null && this.initialDruidAdminPassword == null && this.dataVolumeEncryptionKey == null && this.logviewSecret == null;
    }

    public boolean isComplete() {
        return this.rootCertificate != null && this.intermediatePrivateKey != null && this.intermediatePublicKey != null && this.intermediateCertificate != null && this.keyStorePassword != null && this.hmacSecret != null && this.initialDruidAdminPassword != null && this.dataVolumeEncryptionKey != null && this.logviewSecret != null;
    }

    public String toString() {
        return new ToStringBuilder(this).append("rootCertificate", "*****************").append("intermediatePrivateKey", (Object)"*****************").append("intermediatePublicKey", (Object)"*****************").append("intermediateCertificate", (Object)"*****************").append("parentIntermediateCertificates", (Object)"*****************").append("keyStorePassword", (Object)"*****************").append("hmacSecret", (Object)"*****************").append("initialDruidAdminPassword", (Object)"*****************").append("dataVolumeEncryptionKey", (Object)"*****************").append("logviewSecret", (Object)"*****************").toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityConfiguration that = (SecurityConfiguration)o;
        return Arrays.equals(this.rootCertificate, that.rootCertificate) && Arrays.equals(this.intermediatePrivateKey, that.intermediatePrivateKey) && Arrays.equals(this.intermediatePublicKey, that.intermediatePublicKey) && Arrays.equals(this.intermediateCertificate, that.intermediateCertificate) && this.byteArrayListsEqual(this.parentIntermediateCertificates, that.parentIntermediateCertificates) && Objects.equals(this.keyStorePassword, that.keyStorePassword) && Objects.equals(this.hmacSecret, that.hmacSecret) && Objects.equals(this.initialDruidAdminPassword, that.initialDruidAdminPassword) && Objects.equals(this.dataVolumeEncryptionKey, that.dataVolumeEncryptionKey) && Objects.equals(this.logviewSecret, that.logviewSecret);
    }

    public int hashCode() {
        int result = Objects.hash(this.parentIntermediateCertificates, this.keyStorePassword, this.hmacSecret, this.initialDruidAdminPassword, this.dataVolumeEncryptionKey, this.logviewSecret);
        result = 31 * result + Arrays.hashCode(this.rootCertificate);
        result = 31 * result + Arrays.hashCode(this.intermediatePrivateKey);
        result = 31 * result + Arrays.hashCode(this.intermediatePublicKey);
        result = 31 * result + Arrays.hashCode(this.intermediateCertificate);
        return result;
    }

    private boolean byteArrayListsEqual(List<byte[]> first, List<byte[]> second) {
        if (first == null && second == null) {
            return true;
        }
        if (first == null || second == null || first.size() != second.size()) {
            return false;
        }
        boolean isEqual = true;
        for (int i = 0; i < first.size(); ++i) {
            isEqual &= Arrays.equals(first.get(i), second.get(i));
        }
        return isEqual;
    }

    private static CertAndKeyHolder generateIntermediateCertAndKeypair(String clusterId, SecurityConfig securityConfig) {
        Preconditions.checkArgument((clusterId != null && !clusterId.isEmpty() ? 1 : 0) != 0, (Object)"clusterId cannot be empty");
        try {
            return TLSUtils.generateIntermediateKeysAndCert(Constants.BASE_SUBJECT_INFO.withCommonName(String.format("%s.imply", clusterId)), securityConfig.getSigningPrivateKey(), securityConfig.getSigningCertificate(), 3072, 128);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Builder cloner() {
        return SecurityConfiguration.builder().withSecurityConfiguration(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder<B extends Builder<B, T>, T extends SecurityConfiguration> {
        protected byte[] rootCertificate;
        protected byte[] intermediatePrivateKey;
        protected byte[] intermediatePublicKey;
        protected byte[] intermediateCertificate;
        protected List<byte[]> parentIntermediateCertificates;
        protected String keyStorePassword;
        protected String hmacSecret;
        protected String initialDruidAdminPassword;
        protected String dataVolumeEncryptionKey;
        protected String logviewSecret;

        protected Builder() {
        }

        protected final B getBuilder() {
            return (B)this;
        }

        public B withSecurityConfiguration(SecurityConfiguration securityConfiguration) {
            return this.withSecurityConfiguration(securityConfiguration, false);
        }

        public B withSecurityConfiguration(SecurityConfiguration securityConfiguration, boolean merge) {
            if (securityConfiguration == null) {
                return this.getBuilder();
            }
            if (securityConfiguration.rootCertificate != null) {
                this.rootCertificate = (byte[])securityConfiguration.rootCertificate.clone();
            }
            if (securityConfiguration.intermediatePrivateKey != null) {
                this.intermediatePrivateKey = (byte[])securityConfiguration.intermediatePrivateKey.clone();
            }
            if (securityConfiguration.intermediatePublicKey != null) {
                this.intermediatePublicKey = (byte[])securityConfiguration.intermediatePublicKey.clone();
            }
            if (securityConfiguration.intermediateCertificate != null) {
                this.intermediateCertificate = (byte[])securityConfiguration.intermediateCertificate.clone();
            }
            if (securityConfiguration.parentIntermediateCertificates != null) {
                this.parentIntermediateCertificates = securityConfiguration.parentIntermediateCertificates.stream().map(rec$ -> (byte[])((byte[])rec$).clone()).collect(Collectors.toList());
            }
            if (securityConfiguration.keyStorePassword != null) {
                this.keyStorePassword = securityConfiguration.keyStorePassword;
            }
            if (securityConfiguration.hmacSecret != null) {
                this.hmacSecret = securityConfiguration.hmacSecret;
            }
            if (securityConfiguration.initialDruidAdminPassword != null) {
                this.initialDruidAdminPassword = securityConfiguration.initialDruidAdminPassword;
            }
            if (securityConfiguration.dataVolumeEncryptionKey != null) {
                this.dataVolumeEncryptionKey = securityConfiguration.dataVolumeEncryptionKey;
            }
            if (securityConfiguration.logviewSecret != null) {
                this.logviewSecret = securityConfiguration.logviewSecret;
            }
            return this.getBuilder();
        }

        public B withMissingKeysGenerated(String clusterId, SecurityConfig securityConfig) {
            if (this.rootCertificate == null || this.intermediatePrivateKey == null || this.intermediatePublicKey == null || this.intermediateCertificate == null) {
                CertAndKeyHolder intermediateCertAndKeyHolder = SecurityConfiguration.generateIntermediateCertAndKeypair(clusterId, securityConfig);
                this.rootCertificate = securityConfig.getRootCertificate();
                this.parentIntermediateCertificates = securityConfig.getIntermediateCertificates();
                this.intermediatePrivateKey = intermediateCertAndKeyHolder.getPrivateKey();
                this.intermediatePublicKey = intermediateCertAndKeyHolder.getPublicKey();
                this.intermediateCertificate = intermediateCertAndKeyHolder.getCertificate();
            }
            if (this.keyStorePassword == null) {
                this.keyStorePassword = SecurityUtil.generateSecret(32);
            }
            if (this.hmacSecret == null) {
                this.hmacSecret = SecurityUtil.generateSecret(32);
            }
            if (this.initialDruidAdminPassword == null) {
                this.initialDruidAdminPassword = SecurityUtil.generateSecret(16);
            }
            if (this.dataVolumeEncryptionKey == null) {
                this.dataVolumeEncryptionKey = SecurityUtil.generateSecret(1024);
            }
            if (this.logviewSecret == null) {
                this.logviewSecret = SecurityUtil.generateSecret(32);
            }
            return this.getBuilder();
        }

        public B withRootCertificate(byte[] rootCertificate) {
            this.rootCertificate = rootCertificate;
            return this.getBuilder();
        }

        public B withIntermediatePrivateKey(byte[] intermediatePrivateKey) {
            this.intermediatePrivateKey = intermediatePrivateKey;
            return this.getBuilder();
        }

        public B withIntermediatePublicKey(byte[] intermediatePublicKey) {
            this.intermediatePublicKey = intermediatePublicKey;
            return this.getBuilder();
        }

        public B withIntermediateCertificate(byte[] intermediateCertificate) {
            this.intermediateCertificate = intermediateCertificate;
            return this.getBuilder();
        }

        public B withParentIntermediateCertificates(List<byte[]> parentIntermediateCertificates) {
            this.parentIntermediateCertificates = parentIntermediateCertificates;
            return this.getBuilder();
        }

        public B withKeyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
            return this.getBuilder();
        }

        public B withHmacSecret(String hmacSecret) {
            this.hmacSecret = hmacSecret;
            return this.getBuilder();
        }

        public B withInitialDruidAdminPassword(String initialDruidAdminPassword) {
            this.initialDruidAdminPassword = initialDruidAdminPassword;
            return this.getBuilder();
        }

        public B withDataVolumeEncryptionKey(String dataVolumeEncryptionKey) {
            this.dataVolumeEncryptionKey = dataVolumeEncryptionKey;
            return this.getBuilder();
        }

        public B withLogviewSecret(String logviewSecret) {
            this.logviewSecret = logviewSecret;
            return this.getBuilder();
        }

        public T build() {
            return (T)new SecurityConfiguration(this.rootCertificate, this.intermediatePrivateKey, this.intermediatePublicKey, this.intermediateCertificate, this.parentIntermediateCertificates, this.keyStorePassword, this.hmacSecret, this.initialDruidAdminPassword, this.dataVolumeEncryptionKey, this.logviewSecret);
        }
    }
}

